/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * An element of this type defines header and footer values for a page of the document.
 */
@Schema(description = "An element of this type defines header and footer values for a page of the document.")
@JsonPropertyOrder({
  MetadataHeaderFooter.JSON_PROPERTY_COLOR,
  MetadataHeaderFooter.JSON_PROPERTY_FONT,
  MetadataHeaderFooter.JSON_PROPERTY_FOOTER,
  MetadataHeaderFooter.JSON_PROPERTY_HEADER,
  MetadataHeaderFooter.JSON_PROPERTY_MARGIN,
  MetadataHeaderFooter.JSON_PROPERTY_OBJECT_KEY,
  MetadataHeaderFooter.JSON_PROPERTY_PAGE
})
@JsonTypeName("Metadata_HeaderFooter")

public class MetadataHeaderFooter {
  public static final String JSON_PROPERTY_COLOR = "color";
  private String color = "";

  public static final String JSON_PROPERTY_FONT = "font";
  private MetadataFont font;

  public static final String JSON_PROPERTY_FOOTER = "footer";
  private MetadataFooterHeaderFooter footer;

  public static final String JSON_PROPERTY_HEADER = "header";
  private MetadataHeaderHeaderFooter header;

  public static final String JSON_PROPERTY_MARGIN = "margin";
  private MetadataMargin margin;

  public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
  private String objectKey = "";

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page = 0;

  public MetadataHeaderFooter() {
  }

  public MetadataHeaderFooter color(String color) {
    
    this.color = color;
    return this;
  }

  /**
   * The text of headers and footers color.
   * @return color
   **/
  @Nullable
  @Schema(name = "The text of headers and footers color.")
  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColor(String color) {
    this.color = color;
  }


  public MetadataHeaderFooter font(MetadataFont font) {
    
    this.font = font;
    return this;
  }

  /**
   * Get font
   * @return font
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_FONT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MetadataFont getFont() {
    return font;
  }


  @JsonProperty(JSON_PROPERTY_FONT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFont(MetadataFont font) {
    this.font = font;
  }


  public MetadataHeaderFooter footer(MetadataFooterHeaderFooter footer) {
    
    this.footer = footer;
    return this;
  }

  /**
   * Get footer
   * @return footer
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FOOTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataFooterHeaderFooter getFooter() {
    return footer;
  }


  @JsonProperty(JSON_PROPERTY_FOOTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFooter(MetadataFooterHeaderFooter footer) {
    this.footer = footer;
  }


  public MetadataHeaderFooter header(MetadataHeaderHeaderFooter header) {
    
    this.header = header;
    return this;
  }

  /**
   * Get header
   * @return header
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_HEADER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataHeaderHeaderFooter getHeader() {
    return header;
  }


  @JsonProperty(JSON_PROPERTY_HEADER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeader(MetadataHeaderHeaderFooter header) {
    this.header = header;
  }


  public MetadataHeaderFooter margin(MetadataMargin margin) {
    
    this.margin = margin;
    return this;
  }

  /**
   * Get margin
   * @return margin
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_MARGIN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MetadataMargin getMargin() {
    return margin;
  }


  @JsonProperty(JSON_PROPERTY_MARGIN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMargin(MetadataMargin margin) {
    this.margin = margin;
  }


  public MetadataHeaderFooter objectKey(String objectKey) {
    
    this.objectKey = objectKey;
    return this;
  }

  /**
   * The object ID of the header/footer definition. **Info:** A PDF object ID consists of two numbers, where the first number selects the object&#39;s number and the second the \&quot;generation\&quot; of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.
   * @return objectKey
   **/
  @Nullable
  @Schema(name = "The object ID of the header/footer definition. **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObjectKey() {
    return objectKey;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObjectKey(String objectKey) {
    this.objectKey = objectKey;
  }


  public MetadataHeaderFooter page(Integer page) {
    
    this.page = page;
    return this;
  }

  /**
   * The page headers/footers shall be defined for.
   * minimum: 0
   * @return page
   **/
  @Nullable
  @Schema(name = "The page headers/footers shall be defined for.")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataHeaderFooter metadataHeaderFooter = (MetadataHeaderFooter) o;
    return Objects.equals(this.color, metadataHeaderFooter.color) &&
        Objects.equals(this.font, metadataHeaderFooter.font) &&
        Objects.equals(this.footer, metadataHeaderFooter.footer) &&
        Objects.equals(this.header, metadataHeaderFooter.header) &&
        Objects.equals(this.margin, metadataHeaderFooter.margin) &&
        Objects.equals(this.objectKey, metadataHeaderFooter.objectKey) &&
        Objects.equals(this.page, metadataHeaderFooter.page);
  }

  @Override
  public int hashCode() {
    return Objects.hash(color, font, footer, header, margin, objectKey, page);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataHeaderFooter {\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    font: ").append(toIndentedString(font)).append("\n");
    sb.append("    footer: ").append(toIndentedString(footer)).append("\n");
    sb.append("    header: ").append(toIndentedString(header)).append("\n");
    sb.append("    margin: ").append(toIndentedString(margin)).append("\n");
    sb.append("    objectKey: ").append(toIndentedString(objectKey)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
