/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Describes the properties of the document&#39;s form. (Should the document contain a form.)
 */
@Schema(description = "Describes the properties of the document's form. (Should the document contain a form.)")
@JsonPropertyOrder({
  MetadataFormDocument.JSON_PROPERTY_DEFAULT_APPEARANCE,
  MetadataFormDocument.JSON_PROPERTY_FIELD,
  MetadataFormDocument.JSON_PROPERTY_FORM_TYPE,
  MetadataFormDocument.JSON_PROPERTY_NEED_APPEARANCES,
  MetadataFormDocument.JSON_PROPERTY_OBJECT_KEY
})
@JsonTypeName("Metadata_FormDocument")

public class MetadataFormDocument {
  public static final String JSON_PROPERTY_DEFAULT_APPEARANCE = "defaultAppearance";
  private String defaultAppearance = "";

  public static final String JSON_PROPERTY_FIELD = "field";
  private List<MetadataField> field = null;

  /**
   * When set to another value than \&quot;none\&quot;, the document does contain a PDF form in the hereby given format.  *   none &#x3D; The document does not contain a form. *   acroForm &#x3D; The document contains a standard PDF Acroform. *   staticXFA &#x3D; The document contains a \&quot;XML Forms Architecture\&quot; form with a fixed layout (static). *   dynamicXFA &#x3D; The document contains a \&quot;XML Forms Architecture\&quot; form with an adaptable/interactive layout (dynamic).
   */
  public enum FormTypeEnum {
    NONE("none"),
    
    ACROFORM("acroForm"),
    
    STATICXFA("staticXFA"),
    
    DYNAMICXFA("dynamicXFA");

    private String value;

    FormTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FormTypeEnum fromValue(String value) {
      for (FormTypeEnum b : FormTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FORM_TYPE = "formType";
  private FormTypeEnum formType = FormTypeEnum.NONE;

  public static final String JSON_PROPERTY_NEED_APPEARANCES = "needAppearances";
  private Boolean needAppearances = false;

  public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
  private String objectKey = "";

  public MetadataFormDocument() {
  }

  public MetadataFormDocument defaultAppearance(String defaultAppearance) {
    
    this.defaultAppearance = defaultAppearance;
    return this;
  }

  /**
   * If present, this contains the default appearance of the form&#39;s fields. This shall be a string containing graphics and text state operators for example defining text colors, sizes etc.
   * @return defaultAppearance
   **/
  @Nullable
  @Schema(name = "If present, this contains the default appearance of the form's fields. This shall be a string containing graphics and text state operators for example defining text colors, sizes etc.")
  @JsonProperty(JSON_PROPERTY_DEFAULT_APPEARANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultAppearance() {
    return defaultAppearance;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_APPEARANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultAppearance(String defaultAppearance) {
    this.defaultAppearance = defaultAppearance;
  }


  public MetadataFormDocument field(List<MetadataField> field) {
    
    this.field = field;
    return this;
  }

  public MetadataFormDocument addFieldItem(MetadataField fieldItem) {
    if (this.field == null) {
      this.field = new ArrayList<>();
    }
    this.field.add(fieldItem);
    return this;
  }

  /**
   * Get field
   * @return field
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MetadataField> getField() {
    return field;
  }


  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setField(List<MetadataField> field) {
    this.field = field;
  }


  public MetadataFormDocument formType(FormTypeEnum formType) {
    
    this.formType = formType;
    return this;
  }

  /**
   * When set to another value than \&quot;none\&quot;, the document does contain a PDF form in the hereby given format.  *   none &#x3D; The document does not contain a form. *   acroForm &#x3D; The document contains a standard PDF Acroform. *   staticXFA &#x3D; The document contains a \&quot;XML Forms Architecture\&quot; form with a fixed layout (static). *   dynamicXFA &#x3D; The document contains a \&quot;XML Forms Architecture\&quot; form with an adaptable/interactive layout (dynamic).
   * @return formType
   **/
  @Nullable
  @Schema(name = "When set to another value than \"none\", the document does contain a PDF form in the hereby given format.  *   none = The document does not contain a form. *   acroForm = The document contains a standard PDF Acroform. *   staticXFA = The document contains a \"XML Forms Architecture\" form with a fixed layout (static). *   dynamicXFA = The document contains a \"XML Forms Architecture\" form with an adaptable/interactive layout (dynamic).")
  @JsonProperty(JSON_PROPERTY_FORM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FormTypeEnum getFormType() {
    return formType;
  }


  @JsonProperty(JSON_PROPERTY_FORM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormType(FormTypeEnum formType) {
    this.formType = formType;
  }


  public MetadataFormDocument needAppearances(Boolean needAppearances) {
    
    this.needAppearances = needAppearances;
    return this;
  }

  /**
   * When set to \&quot;true\&quot; the displaying Application shall generate appearances for all widgets defining the document&#39;s form.
   * @return needAppearances
   **/
  @Nullable
  @Schema(name = "When set to \"true\" the displaying Application shall generate appearances for all widgets defining the document's form.")
  @JsonProperty(JSON_PROPERTY_NEED_APPEARANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getNeedAppearances() {
    return needAppearances;
  }


  @JsonProperty(JSON_PROPERTY_NEED_APPEARANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNeedAppearances(Boolean needAppearances) {
    this.needAppearances = needAppearances;
  }


  public MetadataFormDocument objectKey(String objectKey) {
    
    this.objectKey = objectKey;
    return this;
  }

  /**
   * The object ID of the form.  **Info:** A PDF object ID consists of two numbers, where the first number selects the object&#39;s number and the second the \&quot;generation\&quot; of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.
   * @return objectKey
   **/
  @Nullable
  @Schema(name = "The object ID of the form.  **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObjectKey() {
    return objectKey;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObjectKey(String objectKey) {
    this.objectKey = objectKey;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataFormDocument metadataFormDocument = (MetadataFormDocument) o;
    return Objects.equals(this.defaultAppearance, metadataFormDocument.defaultAppearance) &&
        Objects.equals(this.field, metadataFormDocument.field) &&
        Objects.equals(this.formType, metadataFormDocument.formType) &&
        Objects.equals(this.needAppearances, metadataFormDocument.needAppearances) &&
        Objects.equals(this.objectKey, metadataFormDocument.objectKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(defaultAppearance, field, formType, needAppearances, objectKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataFormDocument {\n");
    sb.append("    defaultAppearance: ").append(toIndentedString(defaultAppearance)).append("\n");
    sb.append("    field: ").append(toIndentedString(field)).append("\n");
    sb.append("    formType: ").append(toIndentedString(formType)).append("\n");
    sb.append("    needAppearances: ").append(toIndentedString(needAppearances)).append("\n");
    sb.append("    objectKey: ").append(toIndentedString(objectKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
