/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * An element of this type describes an Annotation placed on a page of the document.
 */
@Schema(description = "An element of this type describes an Annotation placed on a page of the document.")
@JsonPropertyOrder({
  MetadataAnnotation.JSON_PROPERTY_APPEARANCE,
  MetadataAnnotation.JSON_PROPERTY_BORDER,
  MetadataAnnotation.JSON_PROPERTY_COLOR,
  MetadataAnnotation.JSON_PROPERTY_CONTENTS,
  MetadataAnnotation.JSON_PROPERTY_DRAW_STYLE,
  MetadataAnnotation.JSON_PROPERTY_HIDDEN,
  MetadataAnnotation.JSON_PROPERTY_ICON_NAME,
  MetadataAnnotation.JSON_PROPERTY_INVISIBLE,
  MetadataAnnotation.JSON_PROPERTY_LINE,
  MetadataAnnotation.JSON_PROPERTY_LOCKED,
  MetadataAnnotation.JSON_PROPERTY_MARKUP,
  MetadataAnnotation.JSON_PROPERTY_NAME,
  MetadataAnnotation.JSON_PROPERTY_OBJECT_KEY,
  MetadataAnnotation.JSON_PROPERTY_PAGE,
  MetadataAnnotation.JSON_PROPERTY_POPUP,
  MetadataAnnotation.JSON_PROPERTY_POSITIONS,
  MetadataAnnotation.JSON_PROPERTY_PRINTABLE,
  MetadataAnnotation.JSON_PROPERTY_ROTATABLE,
  MetadataAnnotation.JSON_PROPERTY_ROTATION,
  MetadataAnnotation.JSON_PROPERTY_SUB_TYPE,
  MetadataAnnotation.JSON_PROPERTY_VIEWABLE,
  MetadataAnnotation.JSON_PROPERTY_WRITABLE,
  MetadataAnnotation.JSON_PROPERTY_ZOOMABLE
})
@JsonTypeName("Metadata_Annotation")

public class MetadataAnnotation {
  public static final String JSON_PROPERTY_APPEARANCE = "appearance";
  private Object appearance;

  public static final String JSON_PROPERTY_BORDER = "border";
  private MetadataBorderStyle border;

  public static final String JSON_PROPERTY_COLOR = "color";
  private String color = "#4800FF";

  public static final String JSON_PROPERTY_CONTENTS = "contents";
  private String contents = "";

  public static final String JSON_PROPERTY_DRAW_STYLE = "drawStyle";
  private MetadataDrawStyle drawStyle;

  public static final String JSON_PROPERTY_HIDDEN = "hidden";
  private Boolean hidden = false;

  public static final String JSON_PROPERTY_ICON_NAME = "iconName";
  private String iconName = "";

  public static final String JSON_PROPERTY_INVISIBLE = "invisible";
  private Boolean invisible = false;

  public static final String JSON_PROPERTY_LINE = "line";
  private MetadataLine line;

  public static final String JSON_PROPERTY_LOCKED = "locked";
  private Boolean locked = true;

  public static final String JSON_PROPERTY_MARKUP = "markup";
  private MetadataMarkup markup;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name = "";

  public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
  private String objectKey = "";

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page = 0;

  public static final String JSON_PROPERTY_POPUP = "popup";
  private MetadataPopup popup;

  public static final String JSON_PROPERTY_POSITIONS = "positions";
  private List<MetadataPositions> positions = null;

  public static final String JSON_PROPERTY_PRINTABLE = "printable";
  private Boolean printable = false;

  public static final String JSON_PROPERTY_ROTATABLE = "rotatable";
  private Boolean rotatable = true;

  public static final String JSON_PROPERTY_ROTATION = "rotation";
  private Integer rotation = 0;

  public static final String JSON_PROPERTY_SUB_TYPE = "subType";
  private String subType = "";

  public static final String JSON_PROPERTY_VIEWABLE = "viewable";
  private Boolean viewable = true;

  public static final String JSON_PROPERTY_WRITABLE = "writable";
  private Boolean writable = true;

  public static final String JSON_PROPERTY_ZOOMABLE = "zoomable";
  private Boolean zoomable = true;

  public MetadataAnnotation() {
  }

  public MetadataAnnotation appearance(Object appearance) {
    
    this.appearance = appearance;
    return this;
  }

  /**
   * Defines a set of attributes concerning the appearance of the annotation.
   * @return appearance
   **/
  @Nullable
  @Schema(name = "Defines a set of attributes concerning the appearance of the annotation.")
  @JsonProperty(JSON_PROPERTY_APPEARANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getAppearance() {
    return appearance;
  }


  @JsonProperty(JSON_PROPERTY_APPEARANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppearance(Object appearance) {
    this.appearance = appearance;
  }


  public MetadataAnnotation border(MetadataBorderStyle border) {
    
    this.border = border;
    return this;
  }

  /**
   * Get border
   * @return border
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_BORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataBorderStyle getBorder() {
    return border;
  }


  @JsonProperty(JSON_PROPERTY_BORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBorder(MetadataBorderStyle border) {
    this.border = border;
  }


  public MetadataAnnotation color(String color) {
    
    this.color = color;
    return this;
  }

  /**
   * The main color of visible annotations. The color will be specified as a hexadecimal RGB value with a number sign before it.
   * @return color
   **/
  @Nullable
  @Schema(name = "The main color of visible annotations. The color will be specified as a hexadecimal RGB value with a number sign before it.")
  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColor(String color) {
    this.color = color;
  }


  public MetadataAnnotation contents(String contents) {
    
    this.contents = contents;
    return this;
  }

  /**
   * The annotation&#39;s textual contents or (should an annotation of this type not have such contents) it&#39;s description.
   * @return contents
   **/
  @Nullable
  @Schema(name = "The annotation's textual contents or (should an annotation of this type not have such contents) it's description.")
  @JsonProperty(JSON_PROPERTY_CONTENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContents() {
    return contents;
  }


  @JsonProperty(JSON_PROPERTY_CONTENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContents(String contents) {
    this.contents = contents;
  }


  public MetadataAnnotation drawStyle(MetadataDrawStyle drawStyle) {
    
    this.drawStyle = drawStyle;
    return this;
  }

  /**
   * Get drawStyle
   * @return drawStyle
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_DRAW_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataDrawStyle getDrawStyle() {
    return drawStyle;
  }


  @JsonProperty(JSON_PROPERTY_DRAW_STYLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDrawStyle(MetadataDrawStyle drawStyle) {
    this.drawStyle = drawStyle;
  }


  public MetadataAnnotation hidden(Boolean hidden) {
    
    this.hidden = hidden;
    return this;
  }

  /**
   * If this value is set to true, the annotation will not be shown on the page and will not be printed either.
   * @return hidden
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the annotation will not be shown on the page and will not be printed either.")
  @JsonProperty(JSON_PROPERTY_HIDDEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHidden() {
    return hidden;
  }


  @JsonProperty(JSON_PROPERTY_HIDDEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHidden(Boolean hidden) {
    this.hidden = hidden;
  }


  public MetadataAnnotation iconName(String iconName) {
    
    this.iconName = iconName;
    return this;
  }

  /**
   * If the annotation selects an icon (Text annotations), this is the name of that icon.
   * @return iconName
   **/
  @Nullable
  @Schema(name = "If the annotation selects an icon (Text annotations), this is the name of that icon.")
  @JsonProperty(JSON_PROPERTY_ICON_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIconName() {
    return iconName;
  }


  @JsonProperty(JSON_PROPERTY_ICON_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIconName(String iconName) {
    this.iconName = iconName;
  }


  public MetadataAnnotation invisible(Boolean invisible) {
    
    this.invisible = invisible;
    return this;
  }

  /**
   * If this value is set to true, the annotation will be visible on the page only when printed, and provided it is a PDF standard annotation.
   * @return invisible
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the annotation will be visible on the page only when printed, and provided it is a PDF standard annotation.")
  @JsonProperty(JSON_PROPERTY_INVISIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getInvisible() {
    return invisible;
  }


  @JsonProperty(JSON_PROPERTY_INVISIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvisible(Boolean invisible) {
    this.invisible = invisible;
  }


  public MetadataAnnotation line(MetadataLine line) {
    
    this.line = line;
    return this;
  }

  /**
   * Get line
   * @return line
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataLine getLine() {
    return line;
  }


  @JsonProperty(JSON_PROPERTY_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLine(MetadataLine line) {
    this.line = line;
  }


  public MetadataAnnotation locked(Boolean locked) {
    
    this.locked = locked;
    return this;
  }

  /**
   * If this value is set to true, the annotation will be locked so that no changes can be made to it.
   * @return locked
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the annotation will be locked so that no changes can be made to it.")
  @JsonProperty(JSON_PROPERTY_LOCKED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLocked() {
    return locked;
  }


  @JsonProperty(JSON_PROPERTY_LOCKED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocked(Boolean locked) {
    this.locked = locked;
  }


  public MetadataAnnotation markup(MetadataMarkup markup) {
    
    this.markup = markup;
    return this;
  }

  /**
   * Get markup
   * @return markup
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_MARKUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataMarkup getMarkup() {
    return markup;
  }


  @JsonProperty(JSON_PROPERTY_MARKUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarkup(MetadataMarkup markup) {
    this.markup = markup;
  }


  public MetadataAnnotation name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * The annotation&#39;s name.  **Important:** This name is optional and in the best case unique in the annotation&#39;s page context only. Don&#39;t use the name to select an annotation, always prefer selecting objects by object ID, when possible.
   * @return name
   **/
  @Nullable
  @Schema(name = "The annotation's name.  **Important:** This name is optional and in the best case unique in the annotation's page context only. Don't use the name to select an annotation, always prefer selecting objects by object ID, when possible.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public MetadataAnnotation objectKey(String objectKey) {
    
    this.objectKey = objectKey;
    return this;
  }

  /**
   * The object ID of the annotation. **Info:** A PDF object ID consists of two numbers, where the first number selects the object&#39;s number and the second the \&quot;generation\&quot; of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.
   * @return objectKey
   **/
  @Nullable
  @Schema(name = "The object ID of the annotation. **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObjectKey() {
    return objectKey;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObjectKey(String objectKey) {
    this.objectKey = objectKey;
  }


  public MetadataAnnotation page(Integer page) {
    
    this.page = page;
    return this;
  }

  /**
   * The number of the page the annotation is placed on.
   * minimum: 0
   * @return page
   **/
  @Nullable
  @Schema(name = "The number of the page the annotation is placed on.")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }


  public MetadataAnnotation popup(MetadataPopup popup) {
    
    this.popup = popup;
    return this;
  }

  /**
   * Get popup
   * @return popup
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_POPUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataPopup getPopup() {
    return popup;
  }


  @JsonProperty(JSON_PROPERTY_POPUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPopup(MetadataPopup popup) {
    this.popup = popup;
  }


  public MetadataAnnotation positions(List<MetadataPositions> positions) {
    
    this.positions = positions;
    return this;
  }

  public MetadataAnnotation addPositionsItem(MetadataPositions positionsItem) {
    if (this.positions == null) {
      this.positions = new ArrayList<>();
    }
    this.positions.add(positionsItem);
    return this;
  }

  /**
   * Get positions
   * @return positions
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_POSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MetadataPositions> getPositions() {
    return positions;
  }


  @JsonProperty(JSON_PROPERTY_POSITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPositions(List<MetadataPositions> positions) {
    this.positions = positions;
  }


  public MetadataAnnotation printable(Boolean printable) {
    
    this.printable = printable;
    return this;
  }

  /**
   * If this value is set to true, the annotation will be included when the page is printed out.
   * @return printable
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the annotation will be included when the page is printed out.")
  @JsonProperty(JSON_PROPERTY_PRINTABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPrintable() {
    return printable;
  }


  @JsonProperty(JSON_PROPERTY_PRINTABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrintable(Boolean printable) {
    this.printable = printable;
  }


  public MetadataAnnotation rotatable(Boolean rotatable) {
    
    this.rotatable = rotatable;
    return this;
  }

  /**
   * If this value is set to true, the annotation shall be rotatable according to the displayed page rotation.
   * @return rotatable
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the annotation shall be rotatable according to the displayed page rotation.")
  @JsonProperty(JSON_PROPERTY_ROTATABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRotatable() {
    return rotatable;
  }


  @JsonProperty(JSON_PROPERTY_ROTATABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRotatable(Boolean rotatable) {
    this.rotatable = rotatable;
  }


  public MetadataAnnotation rotation(Integer rotation) {
    
    this.rotation = rotation;
    return this;
  }

  /**
   * The annotation&#39;s rotation.
   * @return rotation
   **/
  @Nullable
  @Schema(name = "The annotation's rotation.")
  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRotation() {
    return rotation;
  }


  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRotation(Integer rotation) {
    this.rotation = rotation;
  }


  public MetadataAnnotation subType(String subType) {
    
    this.subType = subType;
    return this;
  }

  /**
   * The type of an annotation is always \&quot;Annot\&quot;, this is the sub type of the annotation determining the actual behavior and function of the annotation. (i.e. Text, Link, Widget etc.)
   * @return subType
   **/
  @Nullable
  @Schema(name = "The type of an annotation is always \"Annot\", this is the sub type of the annotation determining the actual behavior and function of the annotation. (i.e. Text, Link, Widget etc.)")
  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubType() {
    return subType;
  }


  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubType(String subType) {
    this.subType = subType;
  }


  public MetadataAnnotation viewable(Boolean viewable) {
    
    this.viewable = viewable;
    return this;
  }

  /**
   * If this value is set to true, the annotation will be shown on the document&#39;s page.
   * @return viewable
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the annotation will be shown on the document's page.")
  @JsonProperty(JSON_PROPERTY_VIEWABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getViewable() {
    return viewable;
  }


  @JsonProperty(JSON_PROPERTY_VIEWABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setViewable(Boolean viewable) {
    this.viewable = viewable;
  }


  public MetadataAnnotation writable(Boolean writable) {
    
    this.writable = writable;
    return this;
  }

  /**
   * If this value is set to true, it will be possible to change the annotation&#39;s contents later on.
   * @return writable
   **/
  @Nullable
  @Schema(name = "If this value is set to true, it will be possible to change the annotation's contents later on.")
  @JsonProperty(JSON_PROPERTY_WRITABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getWritable() {
    return writable;
  }


  @JsonProperty(JSON_PROPERTY_WRITABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWritable(Boolean writable) {
    this.writable = writable;
  }


  public MetadataAnnotation zoomable(Boolean zoomable) {
    
    this.zoomable = zoomable;
    return this;
  }

  /**
   * If this value is set to true, the annotation will adjust its own zoom factor as required for the page in order to always be clearly readable / recognizable.
   * @return zoomable
   **/
  @Nullable
  @Schema(name = "If this value is set to true, the annotation will adjust its own zoom factor as required for the page in order to always be clearly readable / recognizable.")
  @JsonProperty(JSON_PROPERTY_ZOOMABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getZoomable() {
    return zoomable;
  }


  @JsonProperty(JSON_PROPERTY_ZOOMABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setZoomable(Boolean zoomable) {
    this.zoomable = zoomable;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataAnnotation metadataAnnotation = (MetadataAnnotation) o;
    return Objects.equals(this.appearance, metadataAnnotation.appearance) &&
        Objects.equals(this.border, metadataAnnotation.border) &&
        Objects.equals(this.color, metadataAnnotation.color) &&
        Objects.equals(this.contents, metadataAnnotation.contents) &&
        Objects.equals(this.drawStyle, metadataAnnotation.drawStyle) &&
        Objects.equals(this.hidden, metadataAnnotation.hidden) &&
        Objects.equals(this.iconName, metadataAnnotation.iconName) &&
        Objects.equals(this.invisible, metadataAnnotation.invisible) &&
        Objects.equals(this.line, metadataAnnotation.line) &&
        Objects.equals(this.locked, metadataAnnotation.locked) &&
        Objects.equals(this.markup, metadataAnnotation.markup) &&
        Objects.equals(this.name, metadataAnnotation.name) &&
        Objects.equals(this.objectKey, metadataAnnotation.objectKey) &&
        Objects.equals(this.page, metadataAnnotation.page) &&
        Objects.equals(this.popup, metadataAnnotation.popup) &&
        Objects.equals(this.positions, metadataAnnotation.positions) &&
        Objects.equals(this.printable, metadataAnnotation.printable) &&
        Objects.equals(this.rotatable, metadataAnnotation.rotatable) &&
        Objects.equals(this.rotation, metadataAnnotation.rotation) &&
        Objects.equals(this.subType, metadataAnnotation.subType) &&
        Objects.equals(this.viewable, metadataAnnotation.viewable) &&
        Objects.equals(this.writable, metadataAnnotation.writable) &&
        Objects.equals(this.zoomable, metadataAnnotation.zoomable);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appearance, border, color, contents, drawStyle, hidden, iconName, invisible, line, locked, markup, name, objectKey, page, popup, positions, printable, rotatable, rotation, subType, viewable, writable, zoomable);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataAnnotation {\n");
    sb.append("    appearance: ").append(toIndentedString(appearance)).append("\n");
    sb.append("    border: ").append(toIndentedString(border)).append("\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    contents: ").append(toIndentedString(contents)).append("\n");
    sb.append("    drawStyle: ").append(toIndentedString(drawStyle)).append("\n");
    sb.append("    hidden: ").append(toIndentedString(hidden)).append("\n");
    sb.append("    iconName: ").append(toIndentedString(iconName)).append("\n");
    sb.append("    invisible: ").append(toIndentedString(invisible)).append("\n");
    sb.append("    line: ").append(toIndentedString(line)).append("\n");
    sb.append("    locked: ").append(toIndentedString(locked)).append("\n");
    sb.append("    markup: ").append(toIndentedString(markup)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    objectKey: ").append(toIndentedString(objectKey)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    popup: ").append(toIndentedString(popup)).append("\n");
    sb.append("    positions: ").append(toIndentedString(positions)).append("\n");
    sb.append("    printable: ").append(toIndentedString(printable)).append("\n");
    sb.append("    rotatable: ").append(toIndentedString(rotatable)).append("\n");
    sb.append("    rotation: ").append(toIndentedString(rotation)).append("\n");
    sb.append("    subType: ").append(toIndentedString(subType)).append("\n");
    sb.append("    viewable: ").append(toIndentedString(viewable)).append("\n");
    sb.append("    writable: ").append(toIndentedString(writable)).append("\n");
    sb.append("    zoomable: ").append(toIndentedString(zoomable)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
