/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines settings specific for the MS Visio application in the office bridge.
 */
@Schema(description = "Defines settings specific for the MS Visio application in the office bridge.")
@JsonPropertyOrder({
  ApplicationConfigOfficeBridgeApp.JSON_PROPERTY_MIN_EXECUTION_TIME,
  ApplicationConfigOfficeBridgeApp.JSON_PROPERTY_OLE_START_WAIT_TIME,
  ApplicationConfigOfficeBridgeApp.JSON_PROPERTY_OLE_TERMINATION_TIMEOUT,
  ApplicationConfigOfficeBridgeApp.JSON_PROPERTY_USE_EXECUTION_TEST
})
@JsonTypeName("ApplicationConfig_OfficeBridgeApp")

public class ApplicationConfigOfficeBridgeApp {
  public static final String JSON_PROPERTY_MIN_EXECUTION_TIME = "minExecutionTime";
  private Integer minExecutionTime = 5000;

  public static final String JSON_PROPERTY_OLE_START_WAIT_TIME = "oleStartWaitTime";
  private Integer oleStartWaitTime = 0;

  public static final String JSON_PROPERTY_OLE_TERMINATION_TIMEOUT = "oleTerminationTimeout";
  private Integer oleTerminationTimeout = 0;

  public static final String JSON_PROPERTY_USE_EXECUTION_TEST = "useExecutionTest";
  private Boolean useExecutionTest = true;

  public ApplicationConfigOfficeBridgeApp() {
  }

  public ApplicationConfigOfficeBridgeApp minExecutionTime(Integer minExecutionTime) {
    
    this.minExecutionTime = minExecutionTime;
    return this;
  }

  /**
   * The minimum time frame provided for the execution of an operation with the Office bridge.
   * minimum: 0
   * @return minExecutionTime
   **/
  @Nullable
  @Schema(name = "The minimum time frame provided for the execution of an operation with the Office bridge.")
  @JsonProperty(JSON_PROPERTY_MIN_EXECUTION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinExecutionTime() {
    return minExecutionTime;
  }


  @JsonProperty(JSON_PROPERTY_MIN_EXECUTION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinExecutionTime(Integer minExecutionTime) {
    this.minExecutionTime = minExecutionTime;
  }


  public ApplicationConfigOfficeBridgeApp oleStartWaitTime(Integer oleStartWaitTime) {
    
    this.oleStartWaitTime = oleStartWaitTime;
    return this;
  }

  /**
   * The time in seconds to wait for the OLE server to start during initialization.
   * minimum: 0
   * @return oleStartWaitTime
   **/
  @Nullable
  @Schema(name = "The time in seconds to wait for the OLE server to start during initialization.")
  @JsonProperty(JSON_PROPERTY_OLE_START_WAIT_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOleStartWaitTime() {
    return oleStartWaitTime;
  }


  @JsonProperty(JSON_PROPERTY_OLE_START_WAIT_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOleStartWaitTime(Integer oleStartWaitTime) {
    this.oleStartWaitTime = oleStartWaitTime;
  }


  public ApplicationConfigOfficeBridgeApp oleTerminationTimeout(Integer oleTerminationTimeout) {
    
    this.oleTerminationTimeout = oleTerminationTimeout;
    return this;
  }

  /**
   * The time in seconds to wait for the OLE server to terminate at shutdown.
   * minimum: 0
   * @return oleTerminationTimeout
   **/
  @Nullable
  @Schema(name = "The time in seconds to wait for the OLE server to terminate at shutdown.")
  @JsonProperty(JSON_PROPERTY_OLE_TERMINATION_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOleTerminationTimeout() {
    return oleTerminationTimeout;
  }


  @JsonProperty(JSON_PROPERTY_OLE_TERMINATION_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOleTerminationTimeout(Integer oleTerminationTimeout) {
    this.oleTerminationTimeout = oleTerminationTimeout;
  }


  public ApplicationConfigOfficeBridgeApp useExecutionTest(Boolean useExecutionTest) {
    
    this.useExecutionTest = useExecutionTest;
    return this;
  }

  /**
   * If this option is enabled, the Office Bridge application is started in test mode when the server is initialized, which provides advanced debugging information.
   * @return useExecutionTest
   **/
  @Nullable
  @Schema(name = "If this option is enabled, the Office Bridge application is started in test mode when the server is initialized, which provides advanced debugging information.")
  @JsonProperty(JSON_PROPERTY_USE_EXECUTION_TEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseExecutionTest() {
    return useExecutionTest;
  }


  @JsonProperty(JSON_PROPERTY_USE_EXECUTION_TEST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseExecutionTest(Boolean useExecutionTest) {
    this.useExecutionTest = useExecutionTest;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApplicationConfigOfficeBridgeApp applicationConfigOfficeBridgeApp = (ApplicationConfigOfficeBridgeApp) o;
    return Objects.equals(this.minExecutionTime, applicationConfigOfficeBridgeApp.minExecutionTime) &&
        Objects.equals(this.oleStartWaitTime, applicationConfigOfficeBridgeApp.oleStartWaitTime) &&
        Objects.equals(this.oleTerminationTimeout, applicationConfigOfficeBridgeApp.oleTerminationTimeout) &&
        Objects.equals(this.useExecutionTest, applicationConfigOfficeBridgeApp.useExecutionTest);
  }

  @Override
  public int hashCode() {
    return Objects.hash(minExecutionTime, oleStartWaitTime, oleTerminationTimeout, useExecutionTest);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApplicationConfigOfficeBridgeApp {\n");
    sb.append("    minExecutionTime: ").append(toIndentedString(minExecutionTime)).append("\n");
    sb.append("    oleStartWaitTime: ").append(toIndentedString(oleStartWaitTime)).append("\n");
    sb.append("    oleTerminationTimeout: ").append(toIndentedString(oleTerminationTimeout)).append("\n");
    sb.append("    useExecutionTest: ").append(toIndentedString(useExecutionTest)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
