/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3479 (2024-07-23T08:38:02Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Provides information about the used Java virtual machine and it´sexecution context.
 */
@Schema(description = "Provides information about the used Java virtual machine and it´sexecution context.")
@JsonPropertyOrder({
  AdminJavaStatus.JSON_PROPERTY_CONTAINER,
  AdminJavaStatus.JSON_PROPERTY_GC,
  AdminJavaStatus.JSON_PROPERTY_JAVA_NAME,
  AdminJavaStatus.JSON_PROPERTY_JAVA_VENDOR,
  AdminJavaStatus.JSON_PROPERTY_JAVA_VERSION,
  AdminJavaStatus.JSON_PROPERTY_MEMORY_ALLOCATED,
  AdminJavaStatus.JSON_PROPERTY_MEMORY_FREE,
  AdminJavaStatus.JSON_PROPERTY_MEMORY_MAX,
  AdminJavaStatus.JSON_PROPERTY_MEMORY_TOTAL_FREE,
  AdminJavaStatus.JSON_PROPERTY_MEMORY_USED,
  AdminJavaStatus.JSON_PROPERTY_OS_ARCHITECTURE,
  AdminJavaStatus.JSON_PROPERTY_OS_DISTRO,
  AdminJavaStatus.JSON_PROPERTY_OS_NAME
})
@JsonTypeName("Admin_JavaStatus")

public class AdminJavaStatus {
  public static final String JSON_PROPERTY_CONTAINER = "container";
  private AdminJavaStatusContainer container;

  public static final String JSON_PROPERTY_GC = "gc";
  private List<AdminJavaStatusGC> gc = null;

  public static final String JSON_PROPERTY_JAVA_NAME = "javaName";
  private String javaName = "";

  public static final String JSON_PROPERTY_JAVA_VENDOR = "javaVendor";
  private String javaVendor = "";

  public static final String JSON_PROPERTY_JAVA_VERSION = "javaVersion";
  private String javaVersion = "";

  public static final String JSON_PROPERTY_MEMORY_ALLOCATED = "memoryAllocated";
  private String memoryAllocated = "";

  public static final String JSON_PROPERTY_MEMORY_FREE = "memoryFree";
  private String memoryFree = "";

  public static final String JSON_PROPERTY_MEMORY_MAX = "memoryMax";
  private String memoryMax = "";

  public static final String JSON_PROPERTY_MEMORY_TOTAL_FREE = "memoryTotalFree";
  private String memoryTotalFree = "";

  public static final String JSON_PROPERTY_MEMORY_USED = "memoryUsed";
  private String memoryUsed = "";

  public static final String JSON_PROPERTY_OS_ARCHITECTURE = "osArchitecture";
  private String osArchitecture = "";

  public static final String JSON_PROPERTY_OS_DISTRO = "osDistro";
  private AdminJavaStatusOsDistro osDistro;

  public static final String JSON_PROPERTY_OS_NAME = "osName";
  private String osName = "";

  public AdminJavaStatus() {
  }

  public AdminJavaStatus container(AdminJavaStatusContainer container) {
    
    this.container = container;
    return this;
  }

  /**
   * Get container
   * @return container
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CONTAINER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdminJavaStatusContainer getContainer() {
    return container;
  }


  @JsonProperty(JSON_PROPERTY_CONTAINER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContainer(AdminJavaStatusContainer container) {
    this.container = container;
  }


  public AdminJavaStatus gc(List<AdminJavaStatusGC> gc) {
    
    this.gc = gc;
    return this;
  }

  public AdminJavaStatus addGcItem(AdminJavaStatusGC gcItem) {
    if (this.gc == null) {
      this.gc = new ArrayList<>();
    }
    this.gc.add(gcItem);
    return this;
  }

  /**
   * The list of GC used and their execution values.
   * @return gc
   **/
  @Nullable
  @Schema(name = "The list of GC used and their execution values.")
  @JsonProperty(JSON_PROPERTY_GC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<AdminJavaStatusGC> getGc() {
    return gc;
  }


  @JsonProperty(JSON_PROPERTY_GC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGc(List<AdminJavaStatusGC> gc) {
    this.gc = gc;
  }


  public AdminJavaStatus javaName(String javaName) {
    
    this.javaName = javaName;
    return this;
  }

  /**
   * The name of the running JVM.
   * @return javaName
   **/
  @Nullable
  @Schema(name = "The name of the running JVM.")
  @JsonProperty(JSON_PROPERTY_JAVA_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getJavaName() {
    return javaName;
  }


  @JsonProperty(JSON_PROPERTY_JAVA_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJavaName(String javaName) {
    this.javaName = javaName;
  }


  public AdminJavaStatus javaVendor(String javaVendor) {
    
    this.javaVendor = javaVendor;
    return this;
  }

  /**
   * The vendor of the running JVM.
   * @return javaVendor
   **/
  @Nullable
  @Schema(name = "The vendor of the running JVM.")
  @JsonProperty(JSON_PROPERTY_JAVA_VENDOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getJavaVendor() {
    return javaVendor;
  }


  @JsonProperty(JSON_PROPERTY_JAVA_VENDOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJavaVendor(String javaVendor) {
    this.javaVendor = javaVendor;
  }


  public AdminJavaStatus javaVersion(String javaVersion) {
    
    this.javaVersion = javaVersion;
    return this;
  }

  /**
   * The java version of the running JVM.
   * @return javaVersion
   **/
  @Nullable
  @Schema(name = "The java version of the running JVM.")
  @JsonProperty(JSON_PROPERTY_JAVA_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getJavaVersion() {
    return javaVersion;
  }


  @JsonProperty(JSON_PROPERTY_JAVA_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJavaVersion(String javaVersion) {
    this.javaVersion = javaVersion;
  }


  public AdminJavaStatus memoryAllocated(String memoryAllocated) {
    
    this.memoryAllocated = memoryAllocated;
    return this;
  }

  /**
   * The MB size of the memory currently allocated for the running JVM.
   * @return memoryAllocated
   **/
  @Nullable
  @Schema(name = "The MB size of the memory currently allocated for the running JVM.")
  @JsonProperty(JSON_PROPERTY_MEMORY_ALLOCATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMemoryAllocated() {
    return memoryAllocated;
  }


  @JsonProperty(JSON_PROPERTY_MEMORY_ALLOCATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMemoryAllocated(String memoryAllocated) {
    this.memoryAllocated = memoryAllocated;
  }


  public AdminJavaStatus memoryFree(String memoryFree) {
    
    this.memoryFree = memoryFree;
    return this;
  }

  /**
   * The MB size of free memory, that currently is available for further object allocations.
   * @return memoryFree
   **/
  @Nullable
  @Schema(name = "The MB size of free memory, that currently is available for further object allocations.")
  @JsonProperty(JSON_PROPERTY_MEMORY_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMemoryFree() {
    return memoryFree;
  }


  @JsonProperty(JSON_PROPERTY_MEMORY_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMemoryFree(String memoryFree) {
    this.memoryFree = memoryFree;
  }


  public AdminJavaStatus memoryMax(String memoryMax) {
    
    this.memoryMax = memoryMax;
    return this;
  }

  /**
   * The MB size of the maximum memory, that could be allocated by the JVM, if required.
   * @return memoryMax
   **/
  @Nullable
  @Schema(name = "The MB size of the maximum memory, that could be allocated by the JVM, if required.")
  @JsonProperty(JSON_PROPERTY_MEMORY_MAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMemoryMax() {
    return memoryMax;
  }


  @JsonProperty(JSON_PROPERTY_MEMORY_MAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMemoryMax(String memoryMax) {
    this.memoryMax = memoryMax;
  }


  public AdminJavaStatus memoryTotalFree(String memoryTotalFree) {
    
    this.memoryTotalFree = memoryTotalFree;
    return this;
  }

  /**
   * The MB size of the free memory, that would currently be available for further object allocations, if the JVM would allocate the maximum allowed memory size.
   * @return memoryTotalFree
   **/
  @Nullable
  @Schema(name = "The MB size of the free memory, that would currently be available for further object allocations, if the JVM would allocate the maximum allowed memory size.")
  @JsonProperty(JSON_PROPERTY_MEMORY_TOTAL_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMemoryTotalFree() {
    return memoryTotalFree;
  }


  @JsonProperty(JSON_PROPERTY_MEMORY_TOTAL_FREE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMemoryTotalFree(String memoryTotalFree) {
    this.memoryTotalFree = memoryTotalFree;
  }


  public AdminJavaStatus memoryUsed(String memoryUsed) {
    
    this.memoryUsed = memoryUsed;
    return this;
  }

  /**
   * The MB size of the allocated memory, that is actually used by the JVM at the moment.
   * @return memoryUsed
   **/
  @Nullable
  @Schema(name = "The MB size of the allocated memory, that is actually used by the JVM at the moment.")
  @JsonProperty(JSON_PROPERTY_MEMORY_USED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMemoryUsed() {
    return memoryUsed;
  }


  @JsonProperty(JSON_PROPERTY_MEMORY_USED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMemoryUsed(String memoryUsed) {
    this.memoryUsed = memoryUsed;
  }


  public AdminJavaStatus osArchitecture(String osArchitecture) {
    
    this.osArchitecture = osArchitecture;
    return this;
  }

  /**
   * The operating system´s architecture.
   * @return osArchitecture
   **/
  @Nullable
  @Schema(name = "The operating system´s architecture.")
  @JsonProperty(JSON_PROPERTY_OS_ARCHITECTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOsArchitecture() {
    return osArchitecture;
  }


  @JsonProperty(JSON_PROPERTY_OS_ARCHITECTURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOsArchitecture(String osArchitecture) {
    this.osArchitecture = osArchitecture;
  }


  public AdminJavaStatus osDistro(AdminJavaStatusOsDistro osDistro) {
    
    this.osDistro = osDistro;
    return this;
  }

  /**
   * Get osDistro
   * @return osDistro
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_OS_DISTRO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdminJavaStatusOsDistro getOsDistro() {
    return osDistro;
  }


  @JsonProperty(JSON_PROPERTY_OS_DISTRO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOsDistro(AdminJavaStatusOsDistro osDistro) {
    this.osDistro = osDistro;
  }


  public AdminJavaStatus osName(String osName) {
    
    this.osName = osName;
    return this;
  }

  /**
   * The name of the operating system, the server is running on.
   * @return osName
   **/
  @Nullable
  @Schema(name = "The name of the operating system, the server is running on.")
  @JsonProperty(JSON_PROPERTY_OS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOsName() {
    return osName;
  }


  @JsonProperty(JSON_PROPERTY_OS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOsName(String osName) {
    this.osName = osName;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdminJavaStatus adminJavaStatus = (AdminJavaStatus) o;
    return Objects.equals(this.container, adminJavaStatus.container) &&
        Objects.equals(this.gc, adminJavaStatus.gc) &&
        Objects.equals(this.javaName, adminJavaStatus.javaName) &&
        Objects.equals(this.javaVendor, adminJavaStatus.javaVendor) &&
        Objects.equals(this.javaVersion, adminJavaStatus.javaVersion) &&
        Objects.equals(this.memoryAllocated, adminJavaStatus.memoryAllocated) &&
        Objects.equals(this.memoryFree, adminJavaStatus.memoryFree) &&
        Objects.equals(this.memoryMax, adminJavaStatus.memoryMax) &&
        Objects.equals(this.memoryTotalFree, adminJavaStatus.memoryTotalFree) &&
        Objects.equals(this.memoryUsed, adminJavaStatus.memoryUsed) &&
        Objects.equals(this.osArchitecture, adminJavaStatus.osArchitecture) &&
        Objects.equals(this.osDistro, adminJavaStatus.osDistro) &&
        Objects.equals(this.osName, adminJavaStatus.osName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(container, gc, javaName, javaVendor, javaVersion, memoryAllocated, memoryFree, memoryMax, memoryTotalFree, memoryUsed, osArchitecture, osDistro, osName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdminJavaStatus {\n");
    sb.append("    container: ").append(toIndentedString(container)).append("\n");
    sb.append("    gc: ").append(toIndentedString(gc)).append("\n");
    sb.append("    javaName: ").append(toIndentedString(javaName)).append("\n");
    sb.append("    javaVendor: ").append(toIndentedString(javaVendor)).append("\n");
    sb.append("    javaVersion: ").append(toIndentedString(javaVersion)).append("\n");
    sb.append("    memoryAllocated: ").append(toIndentedString(memoryAllocated)).append("\n");
    sb.append("    memoryFree: ").append(toIndentedString(memoryFree)).append("\n");
    sb.append("    memoryMax: ").append(toIndentedString(memoryMax)).append("\n");
    sb.append("    memoryTotalFree: ").append(toIndentedString(memoryTotalFree)).append("\n");
    sb.append("    memoryUsed: ").append(toIndentedString(memoryUsed)).append("\n");
    sb.append("    osArchitecture: ").append(toIndentedString(osArchitecture)).append("\n");
    sb.append("    osDistro: ").append(toIndentedString(osDistro)).append("\n");
    sb.append("    osName: ").append(toIndentedString(osName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
