/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.webservice.rest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.openapi.OperationBilling;
import net.webpdf.wsclient.openapi.OperationPdfPassword;
import net.webpdf.wsclient.openapi.OperationSettings;
import net.webpdf.wsclient.schema.beans.DocumentFile;
import net.webpdf.wsclient.session.DataFormat;
import net.webpdf.wsclient.session.connection.http.HttpMethod;
import net.webpdf.wsclient.session.connection.http.HttpRestRequest;
import net.webpdf.wsclient.session.rest.RestSession;
import net.webpdf.wsclient.session.rest.documents.DocumentManager;
import net.webpdf.wsclient.session.rest.documents.RestDocument;
import net.webpdf.wsclient.tools.SerializeHelper;
import net.webpdf.wsclient.webservice.AbstractWebService;
import net.webpdf.wsclient.webservice.WebServiceType;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RestWebService<T_OPERATION_DATA, T_OPERATION_PARAMETER, T_REST_DOCUMENT extends RestDocument>
extends AbstractWebService<RestSession<T_REST_DOCUMENT>, T_OPERATION_DATA, T_OPERATION_PARAMETER, T_REST_DOCUMENT, OperationBilling, OperationPdfPassword, OperationSettings> {
    public RestWebService(@NotNull RestSession<T_REST_DOCUMENT> session, @NotNull WebServiceType webServiceType) {
        super(webServiceType, session);
    }

    @Override
    @NotNull
    public T_REST_DOCUMENT process() throws ResultException {
        T_REST_DOCUMENT document = this.process(this.getWebServiceType().equals((Object)WebServiceType.URLCONVERTER) ? this.getWebServiceType().getRestEndpoint() : this.getWebServiceType().getRestEndpoint().replace("{documentId}", "new"));
        if (document == null) {
            throw new ClientResultException(Error.INVALID_RESULT_DOCUMENT);
        }
        return document;
    }

    @Override
    @NotNull
    public T_REST_DOCUMENT process(@NotNull T_REST_DOCUMENT sourceDocument) throws ResultException {
        T_REST_DOCUMENT document = this.process(this.getWebServiceType().equals((Object)WebServiceType.URLCONVERTER) ? this.getWebServiceType().getRestEndpoint() : this.getWebServiceType().getRestEndpoint().replace("{documentId}", sourceDocument.getDocumentId()));
        if (document == null) {
            throw new ClientResultException(Error.INVALID_RESULT_DOCUMENT);
        }
        return document;
    }

    @Override
    @Nullable
    protected T_REST_DOCUMENT process(@NotNull String urlPath) throws ResultException {
        DocumentManager documentManager = ((RestSession)this.getSession()).getDocumentManager();
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("history", Boolean.toString(documentManager.isDocumentHistoryActive())));
        parameters.addAll(this.getAdditionalParameter());
        DocumentFile documentFile = HttpRestRequest.createRequest((RestSession)this.getSession()).buildRequest(HttpMethod.POST, ((RestSession)this.getSession()).getURI(urlPath, parameters), this.getWebServiceOptions()).executeRequest(DocumentFile.class);
        T_REST_DOCUMENT restDocument = null;
        if (documentFile != null) {
            restDocument = documentManager.synchronizeDocument(documentFile);
        }
        return restDocument;
    }

    @NotNull
    private HttpEntity getWebServiceOptions() throws ResultException {
        try {
            return new StringEntity(SerializeHelper.toJSON(this.getOperationData()), ContentType.create((String)DataFormat.JSON.getMimeType(), (Charset)StandardCharsets.UTF_8));
        }
        catch (UnsupportedCharsetException ex) {
            throw new ClientResultException(Error.XML_OR_JSON_CONVERSION_FAILURE, ex);
        }
    }
}

