/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.soap.documents.datasource;

import jakarta.activation.DataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class PathDataSource
implements DataSource {
    @NotNull
    private final Path path;

    public PathDataSource(@NotNull Path path) throws IOException {
        this.path = path;
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @NotNull
    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this.path, new OpenOption[0]);
    }

    @NotNull
    public String getContentType() {
        return "application/octet-stream";
    }

    @NotNull
    public String getName() {
        return this.path.getFileName().toString();
    }
}

