/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.rest.documents;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.openapi.DocumentFileExtract;
import net.webpdf.wsclient.openapi.DocumentInfo;
import net.webpdf.wsclient.openapi.DocumentInfoType;
import net.webpdf.wsclient.schema.beans.DocumentFile;
import net.webpdf.wsclient.schema.beans.HistoryEntry;
import net.webpdf.wsclient.schema.operation.PdfPasswordType;
import net.webpdf.wsclient.session.documents.AbstractDocument;
import net.webpdf.wsclient.session.rest.documents.RestDocument;
import net.webpdf.wsclient.session.rest.documents.RestWebServiceDocumentState;
import org.jetbrains.annotations.NotNull;

public class RestWebServiceDocument
extends AbstractDocument
implements RestDocument {
    @NotNull
    private final RestWebServiceDocumentState documentState;

    RestWebServiceDocument(@NotNull RestWebServiceDocumentState documentState) {
        super(null);
        this.documentState = documentState;
    }

    @NotNull
    RestWebServiceDocumentState accessInternalState() {
        return this.documentState;
    }

    @Override
    @NotNull
    public String getDocumentId() {
        return this.accessInternalState().getDocumentId();
    }

    @Override
    @NotNull
    public DocumentFile getDocumentFile() {
        return this.accessInternalState().getDocumentFile();
    }

    @Override
    @NotNull
    public List<HistoryEntry> getHistory() {
        return this.accessInternalState().getHistory();
    }

    @Override
    @NotNull
    public HistoryEntry getHistoryEntry(int historyId) throws ResultException {
        return this.accessInternalState().getHistoryEntry(historyId);
    }

    @Override
    public void downloadDocument(@NotNull OutputStream target) throws ResultException {
        this.accessInternalState().getDocumentManager().downloadDocument(this.getDocumentId(), target);
    }

    @Override
    public void downloadDocument(@NotNull File target) throws ResultException {
        try (FileOutputStream outputStream = new FileOutputStream(target);){
            this.accessInternalState().getDocumentManager().downloadDocument(this.getDocumentId(), (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new ClientResultException(Error.REST_EXECUTION);
        }
    }

    @Override
    public void deleteDocument() throws ResultException {
        this.accessInternalState().getDocumentManager().deleteDocument(this.getDocumentId());
    }

    @Override
    @NotNull
    public RestDocument renameDocument(@NotNull String fileName) throws ResultException {
        return this.accessInternalState().getDocumentManager().renameDocument(this.getDocumentId(), fileName);
    }

    @Override
    public RestDocument updateDocumentSecurity(@NotNull PdfPasswordType passwordType) throws ResultException {
        return this.accessInternalState().getDocumentManager().updateDocumentSecurity(this.getDocumentId(), passwordType);
    }

    @Override
    public DocumentInfo getDocumentInfo(@NotNull DocumentInfoType infoType) throws ResultException {
        return this.accessInternalState().getDocumentManager().getDocumentInfo(this.getDocumentId(), infoType);
    }

    public List<RestWebServiceDocument> extractDocument(@NotNull DocumentFileExtract fileExtract) throws ResultException {
        return this.accessInternalState().getDocumentManager().extractDocument(this.getDocumentId(), fileExtract);
    }
}

