/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.session.connection.https;

import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import net.webpdf.wsclient.exception.ClientResultException;
import net.webpdf.wsclient.exception.Error;
import net.webpdf.wsclient.exception.ResultException;
import net.webpdf.wsclient.session.connection.https.AlwaysTrustManager;
import net.webpdf.wsclient.session.connection.https.TLSProtocol;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TLSContext {
    private static final TrustManager[] TRUST_ALL = new TrustManager[]{new AlwaysTrustManager()};
    @Nullable
    private final File trustStore;
    @Nullable
    private final String trustStorePassword;
    private final boolean allowSelfSigned;
    @NotNull
    private final TLSProtocol tlsProtocol;

    public TLSContext(@NotNull TLSProtocol tlsProtocol, boolean allowSelfSigned, @NotNull File trustStore, @Nullable String trustStorePassword) {
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
        this.allowSelfSigned = allowSelfSigned;
        this.tlsProtocol = tlsProtocol;
    }

    public TLSContext(@NotNull TLSProtocol tlsProtocol, boolean allowSelfSigned) {
        this.trustStore = null;
        this.trustStorePassword = null;
        this.allowSelfSigned = allowSelfSigned;
        this.tlsProtocol = tlsProtocol;
    }

    public TLSContext() {
        this(TLSProtocol.TLSV1_3, false);
    }

    public boolean isAllowSelfSigned() {
        return this.allowSelfSigned;
    }

    @NotNull
    public TLSProtocol getTlsProtocol() {
        return this.tlsProtocol;
    }

    @Nullable
    public File getTrustStore() {
        return this.trustStore;
    }

    @Nullable
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @NotNull
    public SSLContext create() throws ResultException {
        SSLContext tlsContext;
        try {
            if (this.getTrustStore() != null || this.isAllowSelfSigned()) {
                SSLContext sSLContext = this.getTrustStore() != null ? new SSLContextBuilder().setProtocol(this.getTlsProtocol().getName()).loadTrustMaterial(this.getTrustStore(), this.getTrustStorePassword() != null ? this.getTrustStorePassword().toCharArray() : null, null).build() : (tlsContext = new SSLContextBuilder().setProtocol(this.getTlsProtocol().getName()).build());
                if (this.isAllowSelfSigned()) {
                    tlsContext.init(new KeyManager[0], TRUST_ALL, new SecureRandom());
                }
            } else {
                tlsContext = SSLContexts.createDefault();
            }
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new ClientResultException(Error.TLS_INITIALIZATION_FAILURE, ex);
        }
        return tlsContext;
    }
}

