/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ServerConfigValveHost;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the host name and context path of the server.")
@JsonPropertyOrder(value={"contextPath", "name", "valve"})
@JsonTypeName(value="ServerConfig_Host")
public class ServerConfigHost {
    public static final String JSON_PROPERTY_CONTEXT_PATH = "contextPath";
    private String contextPath = "webPDF";
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "localhost";
    public static final String JSON_PROPERTY_VALVE = "valve";
    private List<ServerConfigValveHost> valve = null;

    public ServerConfigHost contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @Schema(name="Sets the context path of the server address for the portal and the web services (e.g. http://localhost/webPDF).")
    @JsonProperty(value="contextPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getContextPath() {
        return this.contextPath;
    }

    @JsonProperty(value="contextPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public ServerConfigHost name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="Sets the host name part of the server address (e.g. http://localhost).")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ServerConfigHost valve(List<ServerConfigValveHost> valve) {
        this.valve = valve;
        return this;
    }

    public ServerConfigHost addValveItem(ServerConfigValveHost valveItem) {
        if (this.valve == null) {
            this.valve = new ArrayList<ServerConfigValveHost>();
        }
        this.valve.add(valveItem);
        return this;
    }

    @Schema(name="A component to insert into the request processing pipeline of the underlying tomcat server. (See: https://tomcat.apache.org/tomcat-8.5-doc/config/valve.html for further information.)")
    @JsonProperty(value="valve")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<ServerConfigValveHost> getValve() {
        return this.valve;
    }

    @JsonProperty(value="valve")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValve(List<ServerConfigValveHost> valve) {
        this.valve = valve;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfigHost serverConfigHost = (ServerConfigHost)o;
        return Objects.equals(this.contextPath, serverConfigHost.contextPath) && Objects.equals(this.name, serverConfigHost.name) && Objects.equals(this.valve, serverConfigHost.valve);
    }

    public int hashCode() {
        return Objects.hash(this.contextPath, this.name, this.valve);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServerConfigHost {\n");
        sb.append("    contextPath: ").append(this.toIndentedString(this.contextPath)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    valve: ").append(this.toIndentedString(this.valve)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

