/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@JsonPropertyOrder(value={"arguments", "directory", "fileName", "operation"})
@JsonTypeName(value="Operation_WindowsLaunchParameter")
public class OperationWindowsLaunchParameter {
    public static final String JSON_PROPERTY_ARGUMENTS = "arguments";
    private String arguments = "";
    public static final String JSON_PROPERTY_DIRECTORY = "directory";
    private String directory = "";
    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    private String fileName = "";
    public static final String JSON_PROPERTY_OPERATION = "operation";
    private OperationEnum operation = OperationEnum.OPEN;

    public OperationWindowsLaunchParameter arguments(String arguments) {
        this.arguments = arguments;
        return this;
    }

    @Schema(name="The arguments that should be passed to the application when making a call.")
    @JsonProperty(value="arguments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getArguments() {
        return this.arguments;
    }

    @JsonProperty(value="arguments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public OperationWindowsLaunchParameter directory(String directory) {
        this.directory = directory;
        return this;
    }

    @Schema(name="Used to specify the basic path, using standard DOS syntax, from which navigation will take place.")
    @JsonProperty(value="directory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getDirectory() {
        return this.directory;
    }

    @JsonProperty(value="directory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public OperationWindowsLaunchParameter fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Schema(name="A Windows filename using the standard Windows path syntax. If there is a backslash in the specified path, it must be escaped by preceding it with another backslash.")
    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public OperationWindowsLaunchParameter operation(OperationEnum operation) {
        this.operation = operation;
        return this;
    }

    @Schema(name="Used to specify the standard operation that should be carried out with the specified document.  *   open = Open the document. *   print = Print the document.")
    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationEnum getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperation(OperationEnum operation) {
        this.operation = operation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationWindowsLaunchParameter operationWindowsLaunchParameter = (OperationWindowsLaunchParameter)o;
        return Objects.equals(this.arguments, operationWindowsLaunchParameter.arguments) && Objects.equals(this.directory, operationWindowsLaunchParameter.directory) && Objects.equals(this.fileName, operationWindowsLaunchParameter.fileName) && Objects.equals((Object)this.operation, (Object)operationWindowsLaunchParameter.operation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.arguments, this.directory, this.fileName, this.operation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationWindowsLaunchParameter {\n");
        sb.append("    arguments: ").append(this.toIndentedString(this.arguments)).append("\n");
        sb.append("    directory: ").append(this.toIndentedString(this.directory)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperationEnum {
        OPEN("open"),
        PRINT("print");

        private String value;

        private OperationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperationEnum fromValue(String value) {
            for (OperationEnum b : OperationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

