/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Allows to change PDF reader specific settings and dialog defaults.  **Important:** Whether these parameters actually have an effect, depends directly on their support in the application used to display the PDF.  **Important:** Only few of those settings are actually \"enforced\" and most PDF readers will provide the viewer with the means to circumvent or even alter those settings.")
@JsonPropertyOrder(value={"centerWindow", "displayDocTitle", "duplex", "fitWindow", "hideMenuBar", "hideToolbar", "hideWindowUI", "nonFullScreenPageMode", "numCopies", "printArea", "printClip", "printPageRange", "printScaling", "printTraySelection", "textDirection", "viewArea", "viewClip"})
@JsonTypeName(value="Operation_ViewerPreferences")
public class OperationViewerPreferences {
    public static final String JSON_PROPERTY_CENTER_WINDOW = "centerWindow";
    private Boolean centerWindow = false;
    public static final String JSON_PROPERTY_DISPLAY_DOC_TITLE = "displayDocTitle";
    private Boolean displayDocTitle = false;
    public static final String JSON_PROPERTY_DUPLEX = "duplex";
    private DuplexEnum duplex = DuplexEnum.NONE;
    public static final String JSON_PROPERTY_FIT_WINDOW = "fitWindow";
    private Boolean fitWindow = false;
    public static final String JSON_PROPERTY_HIDE_MENU_BAR = "hideMenuBar";
    private Boolean hideMenuBar = false;
    public static final String JSON_PROPERTY_HIDE_TOOLBAR = "hideToolbar";
    private Boolean hideToolbar = false;
    public static final String JSON_PROPERTY_HIDE_WINDOW_U_I = "hideWindowUI";
    private Boolean hideWindowUI = false;
    public static final String JSON_PROPERTY_NON_FULL_SCREEN_PAGE_MODE = "nonFullScreenPageMode";
    private NonFullScreenPageModeEnum nonFullScreenPageMode = NonFullScreenPageModeEnum.NONE;
    public static final String JSON_PROPERTY_NUM_COPIES = "numCopies";
    private Integer numCopies = 1;
    public static final String JSON_PROPERTY_PRINT_AREA = "printArea";
    private PrintAreaEnum printArea = PrintAreaEnum.CROP_BOX;
    public static final String JSON_PROPERTY_PRINT_CLIP = "printClip";
    private PrintClipEnum printClip = PrintClipEnum.CROP_BOX;
    public static final String JSON_PROPERTY_PRINT_PAGE_RANGE = "printPageRange";
    private String printPageRange = "";
    public static final String JSON_PROPERTY_PRINT_SCALING = "printScaling";
    private PrintScalingEnum printScaling = PrintScalingEnum.READERDEFAULT;
    public static final String JSON_PROPERTY_PRINT_TRAY_SELECTION = "printTraySelection";
    private PrintTraySelectionEnum printTraySelection = PrintTraySelectionEnum.READERDEFAULT;
    public static final String JSON_PROPERTY_TEXT_DIRECTION = "textDirection";
    private TextDirectionEnum textDirection = TextDirectionEnum.LEFTTORIGHT;
    public static final String JSON_PROPERTY_VIEW_AREA = "viewArea";
    private ViewAreaEnum viewArea = ViewAreaEnum.CROP_BOX;
    public static final String JSON_PROPERTY_VIEW_CLIP = "viewClip";
    private ViewClipEnum viewClip = ViewClipEnum.CROP_BOX;

    public OperationViewerPreferences centerWindow(Boolean centerWindow) {
        this.centerWindow = centerWindow;
        return this;
    }

    @Schema(name="If true, the PDF reader window is moved to the center of the screen.")
    @JsonProperty(value="centerWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCenterWindow() {
        return this.centerWindow;
    }

    @JsonProperty(value="centerWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCenterWindow(Boolean centerWindow) {
        this.centerWindow = centerWindow;
    }

    public OperationViewerPreferences displayDocTitle(Boolean displayDocTitle) {
        this.displayDocTitle = displayDocTitle;
        return this;
    }

    @Schema(name="If true, the document title of the document is displayed in the title bar of the PDF reader instead of the file name.")
    @JsonProperty(value="displayDocTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getDisplayDocTitle() {
        return this.displayDocTitle;
    }

    @JsonProperty(value="displayDocTitle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayDocTitle(Boolean displayDocTitle) {
        this.displayDocTitle = displayDocTitle;
    }

    public OperationViewerPreferences duplex(DuplexEnum duplex) {
        this.duplex = duplex;
        return this;
    }

    @Schema(name="Sets whether and how pages are to be printed on both sides. (This setting is only a dialog default and can be changed by the user at any time).  *   simplex = Print on one side. *   duplexFlipLongEdge = Print on both sides and flip over the longer edge of the page. *   duplexFlipShortEdge = Print on both sides and flip over the shorter side edge. *   none = Use the default settings of the display program.")
    @JsonProperty(value="duplex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public DuplexEnum getDuplex() {
        return this.duplex;
    }

    @JsonProperty(value="duplex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDuplex(DuplexEnum duplex) {
        this.duplex = duplex;
    }

    public OperationViewerPreferences fitWindow(Boolean fitWindow) {
        this.fitWindow = fitWindow;
        return this;
    }

    @Schema(name="If true, the window size of the PDF reader will be tried to fit the first page of the document.")
    @JsonProperty(value="fitWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getFitWindow() {
        return this.fitWindow;
    }

    @JsonProperty(value="fitWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFitWindow(Boolean fitWindow) {
        this.fitWindow = fitWindow;
    }

    public OperationViewerPreferences hideMenuBar(Boolean hideMenuBar) {
        this.hideMenuBar = hideMenuBar;
        return this;
    }

    @Schema(name="If true, the menu bars of the PDF reader are hidden for the display of this document.")
    @JsonProperty(value="hideMenuBar")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHideMenuBar() {
        return this.hideMenuBar;
    }

    @JsonProperty(value="hideMenuBar")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHideMenuBar(Boolean hideMenuBar) {
        this.hideMenuBar = hideMenuBar;
    }

    public OperationViewerPreferences hideToolbar(Boolean hideToolbar) {
        this.hideToolbar = hideToolbar;
        return this;
    }

    @Schema(name="If true, the toolbars of the PDF reader are hidden for the display of this document.")
    @JsonProperty(value="hideToolbar")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHideToolbar() {
        return this.hideToolbar;
    }

    @JsonProperty(value="hideToolbar")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHideToolbar(Boolean hideToolbar) {
        this.hideToolbar = hideToolbar;
    }

    public OperationViewerPreferences hideWindowUI(Boolean hideWindowUI) {
        this.hideWindowUI = hideWindowUI;
        return this;
    }

    @Schema(name="If true, the scrollbars and other navigation features of the PDF reader are hidden for the display of this document.")
    @JsonProperty(value="hideWindowUI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHideWindowUI() {
        return this.hideWindowUI;
    }

    @JsonProperty(value="hideWindowUI")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHideWindowUI(Boolean hideWindowUI) {
        this.hideWindowUI = hideWindowUI;
    }

    public OperationViewerPreferences nonFullScreenPageMode(NonFullScreenPageModeEnum nonFullScreenPageMode) {
        this.nonFullScreenPageMode = nonFullScreenPageMode;
        return this;
    }

    @Schema(name="Konfiguriert die Anzeige des Dokuments, wenn das Dokument nicht im Vollbildmodus betrachtet wird. Dies konfiguriert in erste Linie welche Navigationsansicht f\u00fcr den Betrachter ge\u00f6ffnet werden soll.  *   none = Weder die Inhalts\u00fcbersicht, noch die Miniaturansicht der Seiten sollen angezeigt werden. *   outlines = Die Inhalts\u00fcbersicht des Dokuments soll angezeigt werden. *   thumbnails = Die Miniaturansicht der Seiten des Dokuments soll angezeigt werden. *   optionalContents = Die Layer (Optional Content Groups) des Dokuments sollen angezeigt werden.")
    @JsonProperty(value="nonFullScreenPageMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public NonFullScreenPageModeEnum getNonFullScreenPageMode() {
        return this.nonFullScreenPageMode;
    }

    @JsonProperty(value="nonFullScreenPageMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNonFullScreenPageMode(NonFullScreenPageModeEnum nonFullScreenPageMode) {
        this.nonFullScreenPageMode = nonFullScreenPageMode;
    }

    public OperationViewerPreferences numCopies(Integer numCopies) {
        this.numCopies = numCopies;
        return this;
    }

    @Schema(name="Specifies how many copies of the document are to be printed. (This setting is only a dialog default and can be changed by the user at any time).")
    @JsonProperty(value="numCopies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getNumCopies() {
        return this.numCopies;
    }

    @JsonProperty(value="numCopies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumCopies(Integer numCopies) {
        this.numCopies = numCopies;
    }

    public OperationViewerPreferences printArea(PrintAreaEnum printArea) {
        this.printArea = printArea;
        return this;
    }

    @Schema(name="Used to select the box that should be scaled.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
    @JsonProperty(value="printArea")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PrintAreaEnum getPrintArea() {
        return this.printArea;
    }

    @JsonProperty(value="printArea")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintArea(PrintAreaEnum printArea) {
        this.printArea = printArea;
    }

    public OperationViewerPreferences printClip(PrintClipEnum printClip) {
        this.printClip = printClip;
        return this;
    }

    @Schema(name="Used to select the box that should be scaled.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
    @JsonProperty(value="printClip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PrintClipEnum getPrintClip() {
        return this.printClip;
    }

    @JsonProperty(value="printClip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintClip(PrintClipEnum printClip) {
        this.printClip = printClip;
    }

    public OperationViewerPreferences printPageRange(String printPageRange) {
        this.printPageRange = printPageRange;
        return this;
    }

    @Schema(name="Specifies which page(s) to print. For the page number, either a single page, a range of pages or a list (separated by commas) can be specified (e.g. \"1,5-6,9\"). The specification of all pages is done with \"\\*\". (This setting is only a dialog default and can be changed by the user at any time).")
    @JsonProperty(value="printPageRange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPrintPageRange() {
        return this.printPageRange;
    }

    @JsonProperty(value="printPageRange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintPageRange(String printPageRange) {
        this.printPageRange = printPageRange;
    }

    public OperationViewerPreferences printScaling(PrintScalingEnum printScaling) {
        this.printScaling = printScaling;
        return this;
    }

    @Schema(name="Selects the page  *   scaling mode for printouts of the document. (This setting is only a dialog default and can be changed by the user at any time). *   readerDefault = Use the scaling functions provided by the display program. *   noPrintScaling = Do no page scaling and print the pages in original size.")
    @JsonProperty(value="printScaling")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PrintScalingEnum getPrintScaling() {
        return this.printScaling;
    }

    @JsonProperty(value="printScaling")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintScaling(PrintScalingEnum printScaling) {
        this.printScaling = printScaling;
    }

    public OperationViewerPreferences printTraySelection(PrintTraySelectionEnum printTraySelection) {
        this.printTraySelection = printTraySelection;
        return this;
    }

    @Schema(name="Selects the default setting for how print trays should be selected for printing the pages of the document. (This setting is only a dialog default and can be changed by the user at any time).  *   readerDefault = Use the default settings of the display program. *   byPDFSize = Try to determine the necessary paper size and the used print tray automatically based on the size of the pages of the document.")
    @JsonProperty(value="printTraySelection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PrintTraySelectionEnum getPrintTraySelection() {
        return this.printTraySelection;
    }

    @JsonProperty(value="printTraySelection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintTraySelection(PrintTraySelectionEnum printTraySelection) {
        this.printTraySelection = printTraySelection;
    }

    public OperationViewerPreferences textDirection(TextDirectionEnum textDirection) {
        this.textDirection = textDirection;
        return this;
    }

    @Schema(name="Specifies the text reading direction for the display program's read aloud.  *   leftToRight = From left to right. *   rightToLeft = From right to left. (Including vertical fonts, such as: Chinese, Japanese, Korean, etc.).")
    @JsonProperty(value="textDirection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public TextDirectionEnum getTextDirection() {
        return this.textDirection;
    }

    @JsonProperty(value="textDirection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTextDirection(TextDirectionEnum textDirection) {
        this.textDirection = textDirection;
    }

    public OperationViewerPreferences viewArea(ViewAreaEnum viewArea) {
        this.viewArea = viewArea;
        return this;
    }

    @Schema(name="Used to select the box that should be scaled.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
    @JsonProperty(value="viewArea")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ViewAreaEnum getViewArea() {
        return this.viewArea;
    }

    @JsonProperty(value="viewArea")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setViewArea(ViewAreaEnum viewArea) {
        this.viewArea = viewArea;
    }

    public OperationViewerPreferences viewClip(ViewClipEnum viewClip) {
        this.viewClip = viewClip;
        return this;
    }

    @Schema(name="Used to select the box that should be scaled.  *   media\\_box = The page's physical dimensions. *   crop\\_box = The visible (printable) page area. *   bleed\\_box = Untrimmed content position on the page (content dimensions plus trim box). *   trim\\_box = Trimmed content position on the page (final content dimensions). *   art\\_box = Position for special page content (images).")
    @JsonProperty(value="viewClip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ViewClipEnum getViewClip() {
        return this.viewClip;
    }

    @JsonProperty(value="viewClip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setViewClip(ViewClipEnum viewClip) {
        this.viewClip = viewClip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationViewerPreferences operationViewerPreferences = (OperationViewerPreferences)o;
        return Objects.equals(this.centerWindow, operationViewerPreferences.centerWindow) && Objects.equals(this.displayDocTitle, operationViewerPreferences.displayDocTitle) && Objects.equals((Object)this.duplex, (Object)operationViewerPreferences.duplex) && Objects.equals(this.fitWindow, operationViewerPreferences.fitWindow) && Objects.equals(this.hideMenuBar, operationViewerPreferences.hideMenuBar) && Objects.equals(this.hideToolbar, operationViewerPreferences.hideToolbar) && Objects.equals(this.hideWindowUI, operationViewerPreferences.hideWindowUI) && Objects.equals((Object)this.nonFullScreenPageMode, (Object)operationViewerPreferences.nonFullScreenPageMode) && Objects.equals(this.numCopies, operationViewerPreferences.numCopies) && Objects.equals((Object)this.printArea, (Object)operationViewerPreferences.printArea) && Objects.equals((Object)this.printClip, (Object)operationViewerPreferences.printClip) && Objects.equals(this.printPageRange, operationViewerPreferences.printPageRange) && Objects.equals((Object)this.printScaling, (Object)operationViewerPreferences.printScaling) && Objects.equals((Object)this.printTraySelection, (Object)operationViewerPreferences.printTraySelection) && Objects.equals((Object)this.textDirection, (Object)operationViewerPreferences.textDirection) && Objects.equals((Object)this.viewArea, (Object)operationViewerPreferences.viewArea) && Objects.equals((Object)this.viewClip, (Object)operationViewerPreferences.viewClip);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.centerWindow, this.displayDocTitle, this.duplex, this.fitWindow, this.hideMenuBar, this.hideToolbar, this.hideWindowUI, this.nonFullScreenPageMode, this.numCopies, this.printArea, this.printClip, this.printPageRange, this.printScaling, this.printTraySelection, this.textDirection, this.viewArea, this.viewClip});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationViewerPreferences {\n");
        sb.append("    centerWindow: ").append(this.toIndentedString(this.centerWindow)).append("\n");
        sb.append("    displayDocTitle: ").append(this.toIndentedString(this.displayDocTitle)).append("\n");
        sb.append("    duplex: ").append(this.toIndentedString((Object)this.duplex)).append("\n");
        sb.append("    fitWindow: ").append(this.toIndentedString(this.fitWindow)).append("\n");
        sb.append("    hideMenuBar: ").append(this.toIndentedString(this.hideMenuBar)).append("\n");
        sb.append("    hideToolbar: ").append(this.toIndentedString(this.hideToolbar)).append("\n");
        sb.append("    hideWindowUI: ").append(this.toIndentedString(this.hideWindowUI)).append("\n");
        sb.append("    nonFullScreenPageMode: ").append(this.toIndentedString((Object)this.nonFullScreenPageMode)).append("\n");
        sb.append("    numCopies: ").append(this.toIndentedString(this.numCopies)).append("\n");
        sb.append("    printArea: ").append(this.toIndentedString((Object)this.printArea)).append("\n");
        sb.append("    printClip: ").append(this.toIndentedString((Object)this.printClip)).append("\n");
        sb.append("    printPageRange: ").append(this.toIndentedString(this.printPageRange)).append("\n");
        sb.append("    printScaling: ").append(this.toIndentedString((Object)this.printScaling)).append("\n");
        sb.append("    printTraySelection: ").append(this.toIndentedString((Object)this.printTraySelection)).append("\n");
        sb.append("    textDirection: ").append(this.toIndentedString((Object)this.textDirection)).append("\n");
        sb.append("    viewArea: ").append(this.toIndentedString((Object)this.viewArea)).append("\n");
        sb.append("    viewClip: ").append(this.toIndentedString((Object)this.viewClip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ViewClipEnum {
        MEDIA_BOX("media_box"),
        CROP_BOX("crop_box"),
        BLEED_BOX("bleed_box"),
        TRIM_BOX("trim_box"),
        ART_BOX("art_box");

        private String value;

        private ViewClipEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ViewClipEnum fromValue(String value) {
            for (ViewClipEnum b : ViewClipEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ViewAreaEnum {
        MEDIA_BOX("media_box"),
        CROP_BOX("crop_box"),
        BLEED_BOX("bleed_box"),
        TRIM_BOX("trim_box"),
        ART_BOX("art_box");

        private String value;

        private ViewAreaEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ViewAreaEnum fromValue(String value) {
            for (ViewAreaEnum b : ViewAreaEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TextDirectionEnum {
        LEFTTORIGHT("leftToRight"),
        RIGHTTOLEFT("rightToLeft");

        private String value;

        private TextDirectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TextDirectionEnum fromValue(String value) {
            for (TextDirectionEnum b : TextDirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PrintTraySelectionEnum {
        READERDEFAULT("readerDefault"),
        BYPDFSIZE("byPDFSize");

        private String value;

        private PrintTraySelectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrintTraySelectionEnum fromValue(String value) {
            for (PrintTraySelectionEnum b : PrintTraySelectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PrintScalingEnum {
        READERDEFAULT("readerDefault"),
        NOPRINTSCALING("noPrintScaling");

        private String value;

        private PrintScalingEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrintScalingEnum fromValue(String value) {
            for (PrintScalingEnum b : PrintScalingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PrintClipEnum {
        MEDIA_BOX("media_box"),
        CROP_BOX("crop_box"),
        BLEED_BOX("bleed_box"),
        TRIM_BOX("trim_box"),
        ART_BOX("art_box");

        private String value;

        private PrintClipEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrintClipEnum fromValue(String value) {
            for (PrintClipEnum b : PrintClipEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PrintAreaEnum {
        MEDIA_BOX("media_box"),
        CROP_BOX("crop_box"),
        BLEED_BOX("bleed_box"),
        TRIM_BOX("trim_box"),
        ART_BOX("art_box");

        private String value;

        private PrintAreaEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrintAreaEnum fromValue(String value) {
            for (PrintAreaEnum b : PrintAreaEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum NonFullScreenPageModeEnum {
        NONE("none"),
        OUTLINES("outlines"),
        THUMBNAILS("thumbnails"),
        OPTIONALCONTENTS("optionalContents");

        private String value;

        private NonFullScreenPageModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NonFullScreenPageModeEnum fromValue(String value) {
            for (NonFullScreenPageModeEnum b : NonFullScreenPageModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DuplexEnum {
        NONE("none"),
        SIMPLEX("simplex"),
        DUPLEXFLIPSHORTEDGE("duplexFlipShortEdge"),
        DUPLEXFLIPLONGEDGE("duplexFlipLongEdge");

        private String value;

        private DuplexEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DuplexEnum fromValue(String value) {
            for (DuplexEnum b : DuplexEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

