/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The split operation element can be used to split documents.  **Important:** Acroforms are correctly split, but contained XFA data are removed.")
@JsonPropertyOrder(value={"fileNameTemplate", "mode", "pages", "singleFileAsZip", "startPage"})
@JsonTypeName(value="Operation_ToolboxSplit_split")
public class OperationToolboxSplitSplit {
    public static final String JSON_PROPERTY_FILE_NAME_TEMPLATE = "fileNameTemplate";
    private String fileNameTemplate = "page[%d]";
    public static final String JSON_PROPERTY_MODE = "mode";
    private ModeEnum mode = ModeEnum.LAST;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "1";
    public static final String JSON_PROPERTY_SINGLE_FILE_AS_ZIP = "singleFileAsZip";
    private Boolean singleFileAsZip = true;
    public static final String JSON_PROPERTY_START_PAGE = "startPage";
    private Integer startPage = 1;

    public OperationToolboxSplitSplit fileNameTemplate(String fileNameTemplate) {
        this.fileNameTemplate = fileNameTemplate;
        return this;
    }

    @Schema(name="If the \"split\" operation generates a ZIP document (please refer to \"mode\"), this template can be used to define the file name of the PDF document in the ZIP document. The \"%d\" placeholder must be used in the template in order to define the PDF document page.")
    @JsonProperty(value="fileNameTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFileNameTemplate() {
        return this.fileNameTemplate;
    }

    @JsonProperty(value="fileNameTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileNameTemplate(String fileNameTemplate) {
        this.fileNameTemplate = fileNameTemplate;
    }

    public OperationToolboxSplitSplit mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Schema(name="Defines the mode used to split the PDF document.  *   last = Last page - Uses \"pages\" to define the last page that will be contained in the new PDF document. *   first = First page - Uses \"pages\" to define the first page that will be contained in the new PDF document. *   list = List of pages - Uses \"pages\" to define a list of pages that should be extracted from the document. A single PDF document will be created on the basis of this list. *   single = Selected pages - Uses the \"pages\" attribute to define a list of pages that should be extracted from the document. And creates a ZIP file with the corresponding pages. *   each = Every nth page - Uses the \"pages\" attribute to define the interval at which pages should be extracted. The \"startPage\" attribute is used to define the page on which the process will start. The result will be a ZIP file. *   group = Group pages - Multiple pages will be added to a single PDF document. The \"pages\" attribute can be used to define how many pages will be saved in a single PDF document. The \"startPage\" attribute is used to define the page on which the process will start. The result will be a ZIP file. *   burst = Ungroup pages - A new PDF document will be generated from each page. The result will be a ZIP file.")
    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ModeEnum getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public OperationToolboxSplitSplit pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="Defines which page(s) should be used for the split operation. The page number can be an individual page, a page range, or a list (separated with commas) (e.g. \"1,5-6,9\"). The \"mode\" attribute defines whether a single page or a range of pages can be used: With \"last\" and \"first,\" an individual page is specified; with \"list,\" a list of pages can be used.")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public OperationToolboxSplitSplit singleFileAsZip(Boolean singleFileAsZip) {
        this.singleFileAsZip = singleFileAsZip;
        return this;
    }

    @Schema(name="Only mode with \"single\", \"burst\", \"each\", or \"group\". The returned pages will be generated as a ZIP file even if selection is used to select only one single file. You can change this behaviour by setting this option to \"false\". In this case, the page will not be zipped, and will instead be returned directly as is. However, this will only work if selection has been used to select one page and one page only.")
    @JsonProperty(value="singleFileAsZip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getSingleFileAsZip() {
        return this.singleFileAsZip;
    }

    @JsonProperty(value="singleFileAsZip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSingleFileAsZip(Boolean singleFileAsZip) {
        this.singleFileAsZip = singleFileAsZip;
    }

    public OperationToolboxSplitSplit startPage(Integer startPage) {
        this.startPage = startPage;
        return this;
    }

    @Schema(name="Used for \"each\" and \"group\" in the \"mode\" attribute.")
    @JsonProperty(value="startPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getStartPage() {
        return this.startPage;
    }

    @JsonProperty(value="startPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartPage(Integer startPage) {
        this.startPage = startPage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationToolboxSplitSplit operationToolboxSplitSplit = (OperationToolboxSplitSplit)o;
        return Objects.equals(this.fileNameTemplate, operationToolboxSplitSplit.fileNameTemplate) && Objects.equals((Object)this.mode, (Object)operationToolboxSplitSplit.mode) && Objects.equals(this.pages, operationToolboxSplitSplit.pages) && Objects.equals(this.singleFileAsZip, operationToolboxSplitSplit.singleFileAsZip) && Objects.equals(this.startPage, operationToolboxSplitSplit.startPage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileNameTemplate, this.mode, this.pages, this.singleFileAsZip, this.startPage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationToolboxSplitSplit {\n");
        sb.append("    fileNameTemplate: ").append(this.toIndentedString(this.fileNameTemplate)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    singleFileAsZip: ").append(this.toIndentedString(this.singleFileAsZip)).append("\n");
        sb.append("    startPage: ").append(this.toIndentedString(this.startPage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ModeEnum {
        LAST("last"),
        FIRST("first"),
        LIST("list"),
        SINGLE("single"),
        EACH("each"),
        GROUP("group"),
        BURST("burst");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

