/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="This element is used to configure the display of contents for which the syntax highlighter was unable to identify a known language.")
@JsonPropertyOrder(value={"color", "fontFamily", "fontOrigin", "fontSize", "lineHeight", "lineNumbers", "wordBreak"})
@JsonTypeName(value="Operation_TextHighlight")
public class OperationTextHighlight {
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color = "#000000";
    public static final String JSON_PROPERTY_FONT_FAMILY = "fontFamily";
    private String fontFamily = "";
    public static final String JSON_PROPERTY_FONT_ORIGIN = "fontOrigin";
    private FontOriginEnum fontOrigin = FontOriginEnum.SYSTEM;
    public static final String JSON_PROPERTY_FONT_SIZE = "fontSize";
    private String fontSize = "10px";
    public static final String JSON_PROPERTY_LINE_HEIGHT = "lineHeight";
    private String lineHeight = "12px";
    public static final String JSON_PROPERTY_LINE_NUMBERS = "lineNumbers";
    private Boolean lineNumbers = false;
    public static final String JSON_PROPERTY_WORD_BREAK = "wordBreak";
    private WordBreakEnum wordBreak = WordBreakEnum.AUTO;

    public OperationTextHighlight color(String color) {
        this.color = color;
        return this;
    }

    @Schema(name="Sets the font color for the text to the given value. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColor(String color) {
        this.color = color;
    }

    public OperationTextHighlight fontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
        return this;
    }

    @Schema(name="Specifies the font to use for the text. If you select \"folder\" for the \"fontOrigin\" parameter, the font here needs to be specified with the filename for the file. Otherwise, use the name of the font you want. If the value is left blank, the \"SourceHanSans\" font will be used automatically.")
    @JsonProperty(value="fontFamily")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFontFamily() {
        return this.fontFamily;
    }

    @JsonProperty(value="fontFamily")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public OperationTextHighlight fontOrigin(FontOriginEnum fontOrigin) {
        this.fontOrigin = fontOrigin;
        return this;
    }

    @Schema(name="Used to specify whether the selected font should be obtained from your operating system or from the \"templates/fonts\" folder (in your webPDF installation path). Possible values:  *   system = It will be possible to select from the fonts available system-wide. *   folder =It will be possible to select from the fonts in \"templates/fonts\".")
    @JsonProperty(value="fontOrigin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FontOriginEnum getFontOrigin() {
        return this.fontOrigin;
    }

    @JsonProperty(value="fontOrigin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFontOrigin(FontOriginEnum fontOrigin) {
        this.fontOrigin = fontOrigin;
    }

    public OperationTextHighlight fontSize(String fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @Schema(name="Used to set the font size for the text to the specified value. You can use any of the following units:  *   px = Pixels *   cm = Centimeters *   mm = Millimeters *   in = Inches *   pt = Points *   pc = Pica")
    @JsonProperty(value="fontSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFontSize() {
        return this.fontSize;
    }

    @JsonProperty(value="fontSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public OperationTextHighlight lineHeight(String lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }

    @Schema(name="Used to set the line height. You can use any of the following units:  *   px = Pixels *   cm = Centimeters *   mm = Millimeters *   in = Inches *   pt = Points *   pc = Pica")
    @JsonProperty(value="lineHeight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getLineHeight() {
        return this.lineHeight;
    }

    @JsonProperty(value="lineHeight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLineHeight(String lineHeight) {
        this.lineHeight = lineHeight;
    }

    public OperationTextHighlight lineNumbers(Boolean lineNumbers) {
        this.lineNumbers = lineNumbers;
        return this;
    }

    @Schema(name="If this value is set to \"true\", line numbers are added before the code.")
    @JsonProperty(value="lineNumbers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getLineNumbers() {
        return this.lineNumbers;
    }

    @JsonProperty(value="lineNumbers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLineNumbers(Boolean lineNumbers) {
        this.lineNumbers = lineNumbers;
    }

    public OperationTextHighlight wordBreak(WordBreakEnum wordBreak) {
        this.wordBreak = wordBreak;
        return this;
    }

    @Schema(name="Can be used to configure the word wrap behaviour during highlighting Possible values:  *   auto = Automatic word wrap if necessary. *   none = Suppress the addition of extra line breaks. *   word = Line breaks allowed only after words. *   all = Line breaks allowed unconditionally.")
    @JsonProperty(value="wordBreak")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public WordBreakEnum getWordBreak() {
        return this.wordBreak;
    }

    @JsonProperty(value="wordBreak")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWordBreak(WordBreakEnum wordBreak) {
        this.wordBreak = wordBreak;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationTextHighlight operationTextHighlight = (OperationTextHighlight)o;
        return Objects.equals(this.color, operationTextHighlight.color) && Objects.equals(this.fontFamily, operationTextHighlight.fontFamily) && Objects.equals((Object)this.fontOrigin, (Object)operationTextHighlight.fontOrigin) && Objects.equals(this.fontSize, operationTextHighlight.fontSize) && Objects.equals(this.lineHeight, operationTextHighlight.lineHeight) && Objects.equals(this.lineNumbers, operationTextHighlight.lineNumbers) && Objects.equals((Object)this.wordBreak, (Object)operationTextHighlight.wordBreak);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.color, this.fontFamily, this.fontOrigin, this.fontSize, this.lineHeight, this.lineNumbers, this.wordBreak});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationTextHighlight {\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    fontFamily: ").append(this.toIndentedString(this.fontFamily)).append("\n");
        sb.append("    fontOrigin: ").append(this.toIndentedString((Object)this.fontOrigin)).append("\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.fontSize)).append("\n");
        sb.append("    lineHeight: ").append(this.toIndentedString(this.lineHeight)).append("\n");
        sb.append("    lineNumbers: ").append(this.toIndentedString(this.lineNumbers)).append("\n");
        sb.append("    wordBreak: ").append(this.toIndentedString((Object)this.wordBreak)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum WordBreakEnum {
        AUTO("auto"),
        NONE("none"),
        WORD("word"),
        ALL("all");

        private String value;

        private WordBreakEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static WordBreakEnum fromValue(String value) {
            for (WordBreakEnum b : WordBreakEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FontOriginEnum {
        SYSTEM("system"),
        FOLDER("folder");

        private String value;

        private FontOriginEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FontOriginEnum fromValue(String value) {
            for (FontOriginEnum b : FontOriginEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

