/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationObjectKeyReplyToAnnotationEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Allows editing the content and properties of a textual reply to another annotation.")
@JsonPropertyOrder(value={"comment", "creator", "name", "objectKey", "page", "subject"})
@JsonTypeName(value="Operation_ReplyToAnnotationEdit")
public class OperationReplyToAnnotationEdit {
    public static final String JSON_PROPERTY_COMMENT = "comment";
    private String comment = "";
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private String creator = "";
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
    private OperationObjectKeyReplyToAnnotationEdit objectKey;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 1;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject = "";

    public OperationReplyToAnnotationEdit comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Schema(name="This value is used to set the textual comment/reply to display.")
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(String comment) {
        this.comment = comment;
    }

    public OperationReplyToAnnotationEdit creator(String creator) {
        this.creator = creator;
        return this;
    }

    @Schema(name="Used to specify the author of the annotation.")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreator(String creator) {
        this.creator = creator;
    }

    public OperationReplyToAnnotationEdit name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="Used to specify the name of the annotation.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OperationReplyToAnnotationEdit objectKey(OperationObjectKeyReplyToAnnotationEdit objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationObjectKeyReplyToAnnotationEdit getObjectKey() {
        return this.objectKey;
    }

    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setObjectKey(OperationObjectKeyReplyToAnnotationEdit objectKey) {
        this.objectKey = objectKey;
    }

    public OperationReplyToAnnotationEdit page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="Selects the page by page number, that shall contain the \"reply to\" annotation.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public OperationReplyToAnnotationEdit subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Schema(name="Used to specify the subject of the annotation.")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationReplyToAnnotationEdit operationReplyToAnnotationEdit = (OperationReplyToAnnotationEdit)o;
        return Objects.equals(this.comment, operationReplyToAnnotationEdit.comment) && Objects.equals(this.creator, operationReplyToAnnotationEdit.creator) && Objects.equals(this.name, operationReplyToAnnotationEdit.name) && Objects.equals(this.objectKey, operationReplyToAnnotationEdit.objectKey) && Objects.equals(this.page, operationReplyToAnnotationEdit.page) && Objects.equals(this.subject, operationReplyToAnnotationEdit.subject);
    }

    public int hashCode() {
        return Objects.hash(this.comment, this.creator, this.name, this.objectKey, this.page, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationReplyToAnnotationEdit {\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    objectKey: ").append(this.toIndentedString(this.objectKey)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

