/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationCertificateFileData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a rights recipient (Recipient) for the document to be encrypted. Recipients are defined on the basis of their rights and a certificate and are identified and distinguished on the basis of the certificate. Only with the associated \"PrivateKey\" and a certificate listed here can a user subsequently decrypt and open the document again. Exactly one certificate is expected for encryption for each rights recipient. However, it is possible to define multiple rights recipients  *   each with their own certificate.")
@JsonPropertyOrder(value={"canAssemble", "canExtractContent", "canExtractForAccessibility", "canFillInForm", "canModify", "canModifyAnnotations", "canPrint", "canPrintHighRes", "certificate"})
@JsonTypeName(value="Operation_Recipient")
public class OperationRecipient {
    public static final String JSON_PROPERTY_CAN_ASSEMBLE = "canAssemble";
    private Boolean canAssemble = false;
    public static final String JSON_PROPERTY_CAN_EXTRACT_CONTENT = "canExtractContent";
    private Boolean canExtractContent = false;
    public static final String JSON_PROPERTY_CAN_EXTRACT_FOR_ACCESSIBILITY = "canExtractForAccessibility";
    private Boolean canExtractForAccessibility = false;
    public static final String JSON_PROPERTY_CAN_FILL_IN_FORM = "canFillInForm";
    private Boolean canFillInForm = false;
    public static final String JSON_PROPERTY_CAN_MODIFY = "canModify";
    private Boolean canModify = false;
    public static final String JSON_PROPERTY_CAN_MODIFY_ANNOTATIONS = "canModifyAnnotations";
    private Boolean canModifyAnnotations = false;
    public static final String JSON_PROPERTY_CAN_PRINT = "canPrint";
    private Boolean canPrint = false;
    public static final String JSON_PROPERTY_CAN_PRINT_HIGH_RES = "canPrintHighRes";
    private Boolean canPrintHighRes = false;
    public static final String JSON_PROPERTY_CERTIFICATE = "certificate";
    private OperationCertificateFileData certificate;

    public OperationRecipient canAssemble(Boolean canAssemble) {
        this.canAssemble = canAssemble;
        return this;
    }

    @Schema(name="If \"true,\" the document can be rearranged (e.g., pages can be deleted, inserted, and rotated).")
    @JsonProperty(value="canAssemble")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanAssemble() {
        return this.canAssemble;
    }

    @JsonProperty(value="canAssemble")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanAssemble(Boolean canAssemble) {
        this.canAssemble = canAssemble;
    }

    public OperationRecipient canExtractContent(Boolean canExtractContent) {
        this.canExtractContent = canExtractContent;
        return this;
    }

    @Schema(name="If \"true,\" content can be extracted (copied) from the document.")
    @JsonProperty(value="canExtractContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanExtractContent() {
        return this.canExtractContent;
    }

    @JsonProperty(value="canExtractContent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanExtractContent(Boolean canExtractContent) {
        this.canExtractContent = canExtractContent;
    }

    public OperationRecipient canExtractForAccessibility(Boolean canExtractForAccessibility) {
        this.canExtractForAccessibility = canExtractForAccessibility;
        return this;
    }

    @Schema(name="If \"true,\" content can be extracted (copied) for accessibility purposes.")
    @JsonProperty(value="canExtractForAccessibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanExtractForAccessibility() {
        return this.canExtractForAccessibility;
    }

    @JsonProperty(value="canExtractForAccessibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanExtractForAccessibility(Boolean canExtractForAccessibility) {
        this.canExtractForAccessibility = canExtractForAccessibility;
    }

    public OperationRecipient canFillInForm(Boolean canFillInForm) {
        this.canFillInForm = canFillInForm;
        return this;
    }

    @Schema(name="If \"true,\" form fields can be filled out and the document can be signed.")
    @JsonProperty(value="canFillInForm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanFillInForm() {
        return this.canFillInForm;
    }

    @JsonProperty(value="canFillInForm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanFillInForm(Boolean canFillInForm) {
        this.canFillInForm = canFillInForm;
    }

    public OperationRecipient canModify(Boolean canModify) {
        this.canModify = canModify;
        return this;
    }

    @Schema(name="If \"true,\" changes to the document are permitted.")
    @JsonProperty(value="canModify")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanModify() {
        return this.canModify;
    }

    @JsonProperty(value="canModify")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanModify(Boolean canModify) {
        this.canModify = canModify;
    }

    public OperationRecipient canModifyAnnotations(Boolean canModifyAnnotations) {
        this.canModifyAnnotations = canModifyAnnotations;
        return this;
    }

    @Schema(name="If \"true,\" comments can be added to the document and deleted from the document.")
    @JsonProperty(value="canModifyAnnotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanModifyAnnotations() {
        return this.canModifyAnnotations;
    }

    @JsonProperty(value="canModifyAnnotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanModifyAnnotations(Boolean canModifyAnnotations) {
        this.canModifyAnnotations = canModifyAnnotations;
    }

    public OperationRecipient canPrint(Boolean canPrint) {
        this.canPrint = canPrint;
        return this;
    }

    @Schema(name="If \"true,\" the document can be printed.")
    @JsonProperty(value="canPrint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanPrint() {
        return this.canPrint;
    }

    @JsonProperty(value="canPrint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanPrint(Boolean canPrint) {
        this.canPrint = canPrint;
    }

    public OperationRecipient canPrintHighRes(Boolean canPrintHighRes) {
        this.canPrintHighRes = canPrintHighRes;
        return this;
    }

    @Schema(name="If \"true,\" the document can be printed at high resolution levels.")
    @JsonProperty(value="canPrintHighRes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanPrintHighRes() {
        return this.canPrintHighRes;
    }

    @JsonProperty(value="canPrintHighRes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanPrintHighRes(Boolean canPrintHighRes) {
        this.canPrintHighRes = canPrintHighRes;
    }

    public OperationRecipient certificate(OperationCertificateFileData certificate) {
        this.certificate = certificate;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="certificate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationCertificateFileData getCertificate() {
        return this.certificate;
    }

    @JsonProperty(value="certificate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCertificate(OperationCertificateFileData certificate) {
        this.certificate = certificate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationRecipient operationRecipient = (OperationRecipient)o;
        return Objects.equals(this.canAssemble, operationRecipient.canAssemble) && Objects.equals(this.canExtractContent, operationRecipient.canExtractContent) && Objects.equals(this.canExtractForAccessibility, operationRecipient.canExtractForAccessibility) && Objects.equals(this.canFillInForm, operationRecipient.canFillInForm) && Objects.equals(this.canModify, operationRecipient.canModify) && Objects.equals(this.canModifyAnnotations, operationRecipient.canModifyAnnotations) && Objects.equals(this.canPrint, operationRecipient.canPrint) && Objects.equals(this.canPrintHighRes, operationRecipient.canPrintHighRes) && Objects.equals(this.certificate, operationRecipient.certificate);
    }

    public int hashCode() {
        return Objects.hash(this.canAssemble, this.canExtractContent, this.canExtractForAccessibility, this.canFillInForm, this.canModify, this.canModifyAnnotations, this.canPrint, this.canPrintHighRes, this.certificate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationRecipient {\n");
        sb.append("    canAssemble: ").append(this.toIndentedString(this.canAssemble)).append("\n");
        sb.append("    canExtractContent: ").append(this.toIndentedString(this.canExtractContent)).append("\n");
        sb.append("    canExtractForAccessibility: ").append(this.toIndentedString(this.canExtractForAccessibility)).append("\n");
        sb.append("    canFillInForm: ").append(this.toIndentedString(this.canFillInForm)).append("\n");
        sb.append("    canModify: ").append(this.toIndentedString(this.canModify)).append("\n");
        sb.append("    canModifyAnnotations: ").append(this.toIndentedString(this.canModifyAnnotations)).append("\n");
        sb.append("    canPrint: ").append(this.toIndentedString(this.canPrint)).append("\n");
        sb.append("    canPrintHighRes: ").append(this.toIndentedString(this.canPrintHighRes)).append("\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

