/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationPortfolioSelection;
import org.jetbrains.annotations.Nullable;

@Schema(description="Removes one or more documents from the portfolio.")
@JsonPropertyOrder(value={"initialDocumentPath", "initialFileName", "selection"})
@JsonTypeName(value="Operation_PortfolioRemove")
public class OperationPortfolioRemove {
    public static final String JSON_PROPERTY_INITIAL_DOCUMENT_PATH = "initialDocumentPath";
    private String initialDocumentPath = "";
    public static final String JSON_PROPERTY_INITIAL_FILE_NAME = "initialFileName";
    private String initialFileName = "";
    public static final String JSON_PROPERTY_SELECTION = "selection";
    private List<OperationPortfolioSelection> selection = null;

    public OperationPortfolioRemove initialDocumentPath(String initialDocumentPath) {
        this.initialDocumentPath = initialDocumentPath;
        return this;
    }

    @Schema(name="Defines the path/folder where the initially shown document is stored in the portfolio.  **Important:** The \"path\" and \"fileName\" parameters follow and implement the glob selection patterns for files and paths. Which is: A portfolio path is defined by \"/\" separated nested folder names.")
    @JsonProperty(value="initialDocumentPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getInitialDocumentPath() {
        return this.initialDocumentPath;
    }

    @JsonProperty(value="initialDocumentPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitialDocumentPath(String initialDocumentPath) {
        this.initialDocumentPath = initialDocumentPath;
    }

    public OperationPortfolioRemove initialFileName(String initialFileName) {
        this.initialFileName = initialFileName;
        return this;
    }

    @Schema(name="Select the name of the initially shown document.  **Important:** The \"path\" and \"fileName\" parameters follow and implement the glob selection patterns for files and paths. Which is: A portfolio path is defined by \"/\" separated nested folder names.")
    @JsonProperty(value="initialFileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getInitialFileName() {
        return this.initialFileName;
    }

    @JsonProperty(value="initialFileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitialFileName(String initialFileName) {
        this.initialFileName = initialFileName;
    }

    public OperationPortfolioRemove selection(List<OperationPortfolioSelection> selection) {
        this.selection = selection;
        return this;
    }

    public OperationPortfolioRemove addSelectionItem(OperationPortfolioSelection selectionItem) {
        if (this.selection == null) {
            this.selection = new ArrayList<OperationPortfolioSelection>();
        }
        this.selection.add(selectionItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="selection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<OperationPortfolioSelection> getSelection() {
        return this.selection;
    }

    @JsonProperty(value="selection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelection(List<OperationPortfolioSelection> selection) {
        this.selection = selection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationPortfolioRemove operationPortfolioRemove = (OperationPortfolioRemove)o;
        return Objects.equals(this.initialDocumentPath, operationPortfolioRemove.initialDocumentPath) && Objects.equals(this.initialFileName, operationPortfolioRemove.initialFileName) && Objects.equals(this.selection, operationPortfolioRemove.selection);
    }

    public int hashCode() {
        return Objects.hash(this.initialDocumentPath, this.initialFileName, this.selection);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationPortfolioRemove {\n");
        sb.append("    initialDocumentPath: ").append(this.toIndentedString(this.initialDocumentPath)).append("\n");
        sb.append("    initialFileName: ").append(this.toIndentedString(this.initialFileName)).append("\n");
        sb.append("    selection: ").append(this.toIndentedString(this.selection)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

