/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="This parameter can be used to optionally activate automatic error correction. If a PDF/A conversion does not work, this may be due to defective PDF syntax structures in the source document. If error correction is enabled then an attempt will be made to correct these syntax errors automatically.  **Important:** If the conversion of an existing PDF document to a certain level (e.g. PDF/A-1) does not work, then there must not always be syntax errors in the document. It may also be that the source document does not have all the necessary content (e.g. missing font embedding) that is mandatory for conversion to a certain level. In this case it may be sufficient to switch to a different PDF/A level. Therefore, the conversion report should always be checked first to see if there is really a defective source document before activating error correction. Error correction tries to correct syntax errors such as defective XREF tables or defective objects (defective data streams) in the PDF structure. First the PDF/conversion is performed normally. If errors are then detected so that a valid PDF/A is not created, an attempt is made to perform error correction. If the error correction works, a second pass of the PDF/A conversion is performed. If this run works, then the corresponding PDF/A document is delivered. If not, the corresponding error code and possibly the error report will be delivered.  **Important:** If error correction is active, then visual and/or content deviations may occur in the converted PDF/A document. If you activate this option, then the resulting document should be checked in any case. It is recommended to perform the PDF/A conversion first without activating the error correction to be sure that the document is not visually and contentwise changed after the conversion. Only if the conversion was not possible (and the error report was checked) should the option be activated in a second call. The PDF/A document of the second call should be checked for visual and content problems.")
@JsonPropertyOrder(value={"enabled"})
@JsonTypeName(value="Operation_PdfaErrorCorrection")
public class OperationPdfaErrorCorrection {
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = false;

    public OperationPdfaErrorCorrection enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="Enables or disables error correction. If the option is set to \"true\" then PDF syntax errors in the PDF document will be corrected during PDF/A conversion.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationPdfaErrorCorrection operationPdfaErrorCorrection = (OperationPdfaErrorCorrection)o;
        return Objects.equals(this.enabled, operationPdfaErrorCorrection.enabled);
    }

    public int hashCode() {
        return Objects.hash(this.enabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationPdfaErrorCorrection {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

