/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationActionEvent;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to specify all the properties you want for a content structure entry that is to be created, including the actions it will trigger. An entry can contain any number of the specified subelements you want in the order you want them. All subelements represent a type of action that will be triggered when the entry is clicked on and that will be executed in succession.")
@JsonPropertyOrder(value={"actions", "bold", "color", "isOpen", "italic", "itemName", "path", "pathPosition"})
@JsonTypeName(value="Operation_Item")
public class OperationItem {
    public static final String JSON_PROPERTY_ACTIONS = "actions";
    private List<OperationActionEvent> actions = null;
    public static final String JSON_PROPERTY_BOLD = "bold";
    private Boolean bold = false;
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color = "#000000";
    public static final String JSON_PROPERTY_IS_OPEN = "isOpen";
    private Boolean isOpen = false;
    public static final String JSON_PROPERTY_ITALIC = "italic";
    private Boolean italic = false;
    public static final String JSON_PROPERTY_ITEM_NAME = "itemName";
    private String itemName = "";
    public static final String JSON_PROPERTY_PATH = "path";
    private String path = "";
    public static final String JSON_PROPERTY_PATH_POSITION = "pathPosition";
    private PathPositionEnum pathPosition = PathPositionEnum.INPLACE;

    public OperationItem actions(List<OperationActionEvent> actions) {
        this.actions = actions;
        return this;
    }

    public OperationItem addActionsItem(OperationActionEvent actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<OperationActionEvent>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="actions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<OperationActionEvent> getActions() {
        return this.actions;
    }

    @JsonProperty(value="actions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActions(List<OperationActionEvent> actions) {
        this.actions = actions;
    }

    public OperationItem bold(Boolean bold) {
        this.bold = bold;
        return this;
    }

    @Schema(name="If this value is set to true, the element's name will be shown in bold.")
    @JsonProperty(value="bold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getBold() {
        return this.bold;
    }

    @JsonProperty(value="bold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public OperationItem color(String color) {
        this.color = color;
        return this;
    }

    @Schema(name="Used to set the colour that will be used to display the element's name. The hereby defined color needs to be specified as a hexadecimal RGB value with a number sign before it.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColor(String color) {
        this.color = color;
    }

    public OperationItem isOpen(Boolean isOpen) {
        this.isOpen = isOpen;
        return this;
    }

    @Schema(name="If this value is set to true, the element will already be expanded when the document is opened.")
    @JsonProperty(value="isOpen")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIsOpen() {
        return this.isOpen;
    }

    @JsonProperty(value="isOpen")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public OperationItem italic(Boolean italic) {
        this.italic = italic;
        return this;
    }

    @Schema(name="If this value is set to true, the element's name will be shown in italics.")
    @JsonProperty(value="italic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getItalic() {
        return this.italic;
    }

    @JsonProperty(value="italic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public OperationItem itemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    @Schema(name="The name of the new entry in the content structure that should be placed relative to the selected path.")
    @JsonProperty(value="itemName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getItemName() {
        return this.itemName;
    }

    @JsonProperty(value="itemName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public OperationItem path(String path) {
        this.path = path;
        return this;
    }

    @Schema(name="The element paths are made of the visible names of the entries in the content structure separated with forward slashes (/), starting with an initial slash.")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPath(String path) {
        this.path = path;
    }

    public OperationItem pathPosition(PathPositionEnum pathPosition) {
        this.pathPosition = pathPosition;
        return this;
    }

    @Schema(name="Selects the position where the entry should be created. The path passed in \"path\" will be interpreted based on this value.  *   before = An entry will be generated on the same level before the entry that was selected with \"path. *   inplace = The entry selected with \"path\" will be treated as a parent element and will contain the new generated entry. *   after = An entry will be generated on the same level after the entry that was selected with \"path.")
    @JsonProperty(value="pathPosition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PathPositionEnum getPathPosition() {
        return this.pathPosition;
    }

    @JsonProperty(value="pathPosition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPathPosition(PathPositionEnum pathPosition) {
        this.pathPosition = pathPosition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationItem operationItem = (OperationItem)o;
        return Objects.equals(this.actions, operationItem.actions) && Objects.equals(this.bold, operationItem.bold) && Objects.equals(this.color, operationItem.color) && Objects.equals(this.isOpen, operationItem.isOpen) && Objects.equals(this.italic, operationItem.italic) && Objects.equals(this.itemName, operationItem.itemName) && Objects.equals(this.path, operationItem.path) && Objects.equals((Object)this.pathPosition, (Object)operationItem.pathPosition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actions, this.bold, this.color, this.isOpen, this.italic, this.itemName, this.path, this.pathPosition});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationItem {\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    bold: ").append(this.toIndentedString(this.bold)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    isOpen: ").append(this.toIndentedString(this.isOpen)).append("\n");
        sb.append("    italic: ").append(this.toIndentedString(this.italic)).append("\n");
        sb.append("    itemName: ").append(this.toIndentedString(this.itemName)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    pathPosition: ").append(this.toIndentedString((Object)this.pathPosition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PathPositionEnum {
        BEFORE("before"),
        INPLACE("inplace"),
        AFTER("after");

        private String value;

        private PathPositionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PathPositionEnum fromValue(String value) {
            for (PathPositionEnum b : PathPositionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

