/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationSvgFormat;
import org.jetbrains.annotations.Nullable;

@Schema(description="Converts the given document into a HTML representation.")
@JsonPropertyOrder(value={"dpi", "pages", "svgFormat"})
@JsonTypeName(value="Operation_HtmlTranscribe")
public class OperationHtmlTranscribe {
    public static final String JSON_PROPERTY_DPI = "dpi";
    private Integer dpi = 72;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "1";
    public static final String JSON_PROPERTY_SVG_FORMAT = "svgFormat";
    private OperationSvgFormat svgFormat;

    public OperationHtmlTranscribe dpi(Integer dpi) {
        this.dpi = dpi;
        return this;
    }

    @Schema(name="This parameter sets the DPI resolution of the document. The larger the value, the larger the X/Y resolution of the document's pages and generated raster graphics. Also, as the DPI resolution increases, so does the byte size of the document.")
    @JsonProperty(value="dpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDpi() {
        return this.dpi;
    }

    @JsonProperty(value="dpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public OperationHtmlTranscribe pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="Specifies which page(s) to convert. The page number can be either a single page, a range of pages or a list (separated by commas) (e.g. \"1,5-6,9\"). The specification of all pages is done with \"\\*\".")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public OperationHtmlTranscribe svgFormat(OperationSvgFormat svgFormat) {
        this.svgFormat = svgFormat;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="svgFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationSvgFormat getSvgFormat() {
        return this.svgFormat;
    }

    @JsonProperty(value="svgFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSvgFormat(OperationSvgFormat svgFormat) {
        this.svgFormat = svgFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationHtmlTranscribe operationHtmlTranscribe = (OperationHtmlTranscribe)o;
        return Objects.equals(this.dpi, operationHtmlTranscribe.dpi) && Objects.equals(this.pages, operationHtmlTranscribe.pages) && Objects.equals(this.svgFormat, operationHtmlTranscribe.svgFormat);
    }

    public int hashCode() {
        return Objects.hash(this.dpi, this.pages, this.svgFormat);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationHtmlTranscribe {\n");
        sb.append("    dpi: ").append(this.toIndentedString(this.dpi)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    svgFormat: ").append(this.toIndentedString(this.svgFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

