/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationFormsFileData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to import data into the form fields.")
@JsonPropertyOrder(value={"data", "flatten", "format"})
@JsonTypeName(value="Operation_FormsImport")
public class OperationFormsImport {
    public static final String JSON_PROPERTY_DATA = "data";
    private OperationFormsFileData data;
    public static final String JSON_PROPERTY_FLATTEN = "flatten";
    private Boolean flatten = false;
    public static final String JSON_PROPERTY_FORMAT = "format";
    private FormatEnum format = FormatEnum.XML;

    public OperationFormsImport data(OperationFormsFileData data) {
        this.data = data;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationFormsFileData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setData(OperationFormsFileData data) {
        this.data = data;
    }

    public OperationFormsImport flatten(Boolean flatten) {
        this.flatten = flatten;
        return this;
    }

    @Schema(name="When set to \"true\" this will render the field contents after importing the new form values. (please refer to the documentation of the \"flatten element\").")
    @JsonProperty(value="flatten")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getFlatten() {
        return this.flatten;
    }

    @JsonProperty(value="flatten")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFlatten(Boolean flatten) {
        this.flatten = flatten;
    }

    public OperationFormsImport format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @Schema(name="Used to set the format for exporting the data in a PDF form:  *   xml = XML *   fdf = FDF *   xfdf = XFDF *   xdp = XDP (only for PDF documents that contain XFA data)  The exported data will be returned with the web service call as per the selected format.  **Tip:** The format of this is described by the http://schema.webpdf.de/1.0/form/data.xsd schema.")
    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FormatEnum getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationFormsImport operationFormsImport = (OperationFormsImport)o;
        return Objects.equals(this.data, operationFormsImport.data) && Objects.equals(this.flatten, operationFormsImport.flatten) && Objects.equals((Object)this.format, (Object)operationFormsImport.format);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.data, this.flatten, this.format});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationFormsImport {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    flatten: ").append(this.toIndentedString(this.flatten)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FormatEnum {
        XML("xml"),
        FDF("fdf"),
        XFDF("xfdf"),
        XDP("xdp");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

