/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationConverterFooter;
import net.webpdf.wsclient.openapi.OperationConverterHeader;
import org.jetbrains.annotations.Nullable;

@Schema(description="Sets the page size, margins, and headers and footers for the converted document in the PDF document.  **Important:** The settings may override the default values for a format that itself has page settings. In addition, not all settings can be applied to all formats (see, for example, the description of headers and footers).")
@JsonPropertyOrder(value={"bottom", "footer", "header", "height", "left", "metrics", "right", "top", "width"})
@JsonTypeName(value="Operation_ConverterPage")
public class OperationConverterPage {
    public static final String JSON_PROPERTY_BOTTOM = "bottom";
    private Integer bottom = 20;
    public static final String JSON_PROPERTY_FOOTER = "footer";
    private OperationConverterFooter footer;
    public static final String JSON_PROPERTY_HEADER = "header";
    private OperationConverterHeader header;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Integer height = 297;
    public static final String JSON_PROPERTY_LEFT = "left";
    private Integer left = 20;
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private MetricsEnum metrics = MetricsEnum.MM;
    public static final String JSON_PROPERTY_RIGHT = "right";
    private Integer right = 20;
    public static final String JSON_PROPERTY_TOP = "top";
    private Integer top = 20;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Integer width = 210;

    public OperationConverterPage bottom(Integer bottom) {
        this.bottom = bottom;
        return this;
    }

    @Schema(name="Bottom margin settings.")
    @JsonProperty(value="bottom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getBottom() {
        return this.bottom;
    }

    @JsonProperty(value="bottom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBottom(Integer bottom) {
        this.bottom = bottom;
    }

    public OperationConverterPage footer(OperationConverterFooter footer) {
        this.footer = footer;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="footer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationConverterFooter getFooter() {
        return this.footer;
    }

    @JsonProperty(value="footer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFooter(OperationConverterFooter footer) {
        this.footer = footer;
    }

    public OperationConverterPage header(OperationConverterHeader header) {
        this.header = header;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="header")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationConverterHeader getHeader() {
        return this.header;
    }

    @JsonProperty(value="header")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeader(OperationConverterHeader header) {
        this.header = header;
    }

    public OperationConverterPage height(Integer height) {
        this.height = height;
        return this;
    }

    @Schema(name="Page height.")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeight(Integer height) {
        this.height = height;
    }

    public OperationConverterPage left(Integer left) {
        this.left = left;
        return this;
    }

    @Schema(name="Left margin settings.")
    @JsonProperty(value="left")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getLeft() {
        return this.left;
    }

    @JsonProperty(value="left")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLeft(Integer left) {
        this.left = left;
    }

    public OperationConverterPage metrics(MetricsEnum metrics) {
        this.metrics = metrics;
        return this;
    }

    @Schema(name="Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt = Points(1/72 inch) *   pc = Picas(12 points) *   px = Pixels(1/96 inch) *   mm = Millimeters *   in = Inches")
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetricsEnum getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetrics(MetricsEnum metrics) {
        this.metrics = metrics;
    }

    public OperationConverterPage right(Integer right) {
        this.right = right;
        return this;
    }

    @Schema(name="Right margin settings.")
    @JsonProperty(value="right")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getRight() {
        return this.right;
    }

    @JsonProperty(value="right")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRight(Integer right) {
        this.right = right;
    }

    public OperationConverterPage top(Integer top) {
        this.top = top;
        return this;
    }

    @Schema(name="Top margin settings.")
    @JsonProperty(value="top")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getTop() {
        return this.top;
    }

    @JsonProperty(value="top")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTop(Integer top) {
        this.top = top;
    }

    public OperationConverterPage width(Integer width) {
        this.width = width;
        return this;
    }

    @Schema(name="Page width.")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWidth(Integer width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationConverterPage operationConverterPage = (OperationConverterPage)o;
        return Objects.equals(this.bottom, operationConverterPage.bottom) && Objects.equals(this.footer, operationConverterPage.footer) && Objects.equals(this.header, operationConverterPage.header) && Objects.equals(this.height, operationConverterPage.height) && Objects.equals(this.left, operationConverterPage.left) && Objects.equals((Object)this.metrics, (Object)operationConverterPage.metrics) && Objects.equals(this.right, operationConverterPage.right) && Objects.equals(this.top, operationConverterPage.top) && Objects.equals(this.width, operationConverterPage.width);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bottom, this.footer, this.header, this.height, this.left, this.metrics, this.right, this.top, this.width});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationConverterPage {\n");
        sb.append("    bottom: ").append(this.toIndentedString(this.bottom)).append("\n");
        sb.append("    footer: ").append(this.toIndentedString(this.footer)).append("\n");
        sb.append("    header: ").append(this.toIndentedString(this.header)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    left: ").append(this.toIndentedString(this.left)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString((Object)this.metrics)).append("\n");
        sb.append("    right: ").append(this.toIndentedString(this.right)).append("\n");
        sb.append("    top: ").append(this.toIndentedString(this.top)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MetricsEnum {
        PT("pt"),
        PC("pc"),
        PX("px"),
        MM("mm"),
        IN("in");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MetricsEnum fromValue(String value) {
            for (MetricsEnum b : MetricsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

