/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationRectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="A aztec barcode.")
@JsonPropertyOrder(value={"charset", "errorCorrection", "layers", "margin", "pages", "position", "rotation", "value"})
@JsonTypeName(value="Operation_AztecBarcode")
public class OperationAztecBarcode {
    public static final String JSON_PROPERTY_CHARSET = "charset";
    private String charset = "utf-8";
    public static final String JSON_PROPERTY_ERROR_CORRECTION = "errorCorrection";
    private Integer errorCorrection = 7;
    public static final String JSON_PROPERTY_LAYERS = "layers";
    private Integer layers = 0;
    public static final String JSON_PROPERTY_MARGIN = "margin";
    private Integer margin = 0;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "";
    public static final String JSON_PROPERTY_POSITION = "position";
    private OperationRectangle position;
    public static final String JSON_PROPERTY_ROTATION = "rotation";
    private Integer rotation = 0;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value = "";

    public OperationAztecBarcode charset(String charset) {
        this.charset = charset;
        return this;
    }

    @Schema(name="Used to specify the character set in which the barcode contents should be stored.")
    @JsonProperty(value="charset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCharset() {
        return this.charset;
    }

    @JsonProperty(value="charset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public OperationAztecBarcode errorCorrection(Integer errorCorrection) {
        this.errorCorrection = errorCorrection;
        return this;
    }

    @Schema(name="Used to adjust the error correction level for generated Aztec Codes. The higher the level, the more error-resistant the barcode, ensuring that damaged codes will still be readable. A percentage value of one to one hundred can be entered.")
    @JsonProperty(value="errorCorrection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getErrorCorrection() {
        return this.errorCorrection;
    }

    @JsonProperty(value="errorCorrection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorCorrection(Integer errorCorrection) {
        this.errorCorrection = errorCorrection;
    }

    public OperationAztecBarcode layers(Integer layers) {
        this.layers = layers;
        return this;
    }

    @Schema(name="Used to specify the number of layers that the generated Aztec Code should use. The higher the number, the larger the resulting barcode and its capacity.  *   \"-4\" to \"-1\" = Compact Aztec Code with a minimum capacity of 13 digits or 12 letters and an area of 15 x 15 pixels. *   \"0\" = Standard Aztec Code that will be optimized in order to use the smallest possible of layers for the value that is being encoded. *   \"1\" to \"32\" = Standard Aztec Code with a maximum capacity of 3832 digits or 3067 letters and an area of 151 x 151 pixels.")
    @JsonProperty(value="layers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getLayers() {
        return this.layers;
    }

    @JsonProperty(value="layers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLayers(Integer layers) {
        this.layers = layers;
    }

    public OperationAztecBarcode margin(Integer margin) {
        this.margin = margin;
        return this;
    }

    @Schema(name="Used to specify the width of the empty frame that should be generated around the barcode. This shall use the same metrics as the position - if no position is present, the default (mm) shall be assumed.")
    @JsonProperty(value="margin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMargin() {
        return this.margin;
    }

    @JsonProperty(value="margin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMargin(Integer margin) {
        this.margin = margin;
    }

    public OperationAztecBarcode pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="The page range for generating barcodes. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: \"1-10\" or \"1,2,5-10\")")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public OperationAztecBarcode position(OperationRectangle position) {
        this.position = position;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationRectangle getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPosition(OperationRectangle position) {
        this.position = position;
    }

    public OperationAztecBarcode rotation(Integer rotation) {
        this.rotation = rotation;
        return this;
    }

    @Schema(name="Used to specify the barcode's rotation in 90-degree increments. When there is a value that falls under a full 90-degree increment, the next higher increment will be automatically selected.")
    @JsonProperty(value="rotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getRotation() {
        return this.rotation;
    }

    @JsonProperty(value="rotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRotation(Integer rotation) {
        this.rotation = rotation;
    }

    public OperationAztecBarcode value(String value) {
        this.value = value;
        return this;
    }

    @Schema(required=true, name="Contains the value that should be encoded in the barcode. Depending on the selected barcode format, there may be specific criteria for the data structure. For a description, please refer to the chapter \"Barcodes\"")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationAztecBarcode operationAztecBarcode = (OperationAztecBarcode)o;
        return Objects.equals(this.charset, operationAztecBarcode.charset) && Objects.equals(this.errorCorrection, operationAztecBarcode.errorCorrection) && Objects.equals(this.layers, operationAztecBarcode.layers) && Objects.equals(this.margin, operationAztecBarcode.margin) && Objects.equals(this.pages, operationAztecBarcode.pages) && Objects.equals(this.position, operationAztecBarcode.position) && Objects.equals(this.rotation, operationAztecBarcode.rotation) && Objects.equals(this.value, operationAztecBarcode.value);
    }

    public int hashCode() {
        return Objects.hash(this.charset, this.errorCorrection, this.layers, this.margin, this.pages, this.position, this.rotation, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationAztecBarcode {\n");
        sb.append("    charset: ").append(this.toIndentedString(this.charset)).append("\n");
        sb.append("    errorCorrection: ").append(this.toIndentedString(this.errorCorrection)).append("\n");
        sb.append("    layers: ").append(this.toIndentedString(this.layers)).append("\n");
        sb.append("    margin: ").append(this.toIndentedString(this.margin)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    rotation: ").append(this.toIndentedString(this.rotation)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

