/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.MetadataDescription;
import net.webpdf.wsclient.openapi.MetadataPdfa;
import net.webpdf.wsclient.openapi.MetadataViewerPreferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Summarizes structural information and settings for the PDF document.")
@JsonPropertyOrder(value={"attachments", "description", "docMDP", "encrypted", "fileSize", "formType", "initialPage", "initialView", "language", "magnification", "magnificationZoom", "objectKey", "pageLayout", "pages", "pdfa", "portfolio", "signatures", "version", "viewerPreferences"})
@JsonTypeName(value="Metadata_Information")
public class MetadataInformation {
    public static final String JSON_PROPERTY_ATTACHMENTS = "attachments";
    private Integer attachments = 0;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private MetadataDescription description;
    public static final String JSON_PROPERTY_DOC_M_D_P = "docMDP";
    private DocMDPEnum docMDP = DocMDPEnum.NONE;
    public static final String JSON_PROPERTY_ENCRYPTED = "encrypted";
    private Boolean encrypted = false;
    public static final String JSON_PROPERTY_FILE_SIZE = "fileSize";
    private Long fileSize = 0L;
    public static final String JSON_PROPERTY_FORM_TYPE = "formType";
    private FormTypeEnum formType = FormTypeEnum.NONE;
    public static final String JSON_PROPERTY_INITIAL_PAGE = "initialPage";
    private Integer initialPage = 1;
    public static final String JSON_PROPERTY_INITIAL_VIEW = "initialView";
    private InitialViewEnum initialView = InitialViewEnum.NONE;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language = "";
    public static final String JSON_PROPERTY_MAGNIFICATION = "magnification";
    private MagnificationEnum magnification = MagnificationEnum.FITVISIBLE;
    public static final String JSON_PROPERTY_MAGNIFICATION_ZOOM = "magnificationZoom";
    private Integer magnificationZoom = 100;
    public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
    private String objectKey = "";
    public static final String JSON_PROPERTY_PAGE_LAYOUT = "pageLayout";
    private PageLayoutEnum pageLayout = PageLayoutEnum.SINGLEPAGE;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private Integer pages = 0;
    public static final String JSON_PROPERTY_PDFA = "pdfa";
    private MetadataPdfa pdfa;
    public static final String JSON_PROPERTY_PORTFOLIO = "portfolio";
    private Boolean portfolio = false;
    public static final String JSON_PROPERTY_SIGNATURES = "signatures";
    private Integer signatures = 0;
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version = "";
    public static final String JSON_PROPERTY_VIEWER_PREFERENCES = "viewerPreferences";
    private MetadataViewerPreferences viewerPreferences;

    public MetadataInformation attachments(Integer attachments) {
        this.attachments = attachments;
        return this;
    }

    @Schema(name="The number of attachments contained in the document.")
    @JsonProperty(value="attachments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="attachments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAttachments(Integer attachments) {
        this.attachments = attachments;
    }

    public MetadataInformation description(MetadataDescription description) {
        this.description = description;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public MetadataDescription getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(MetadataDescription description) {
        this.description = description;
    }

    public MetadataInformation docMDP(DocMDPEnum docMDP) {
        this.docMDP = docMDP;
        return this;
    }

    @Schema(name="A document \"Modification Detection and Prevention\" may be set, that defines which modifications of the document are allowed and which modifications would render the signature invalid.  *   none = The document is unprotected - modify it as you please. *   noChangesAllowed = Any modifications of the document would render the signatures invalid. *   formFillingSignatures = You may fill in forms and further sign the document. *   formFillingSignaturesAndAnnotations = Form filling, signing and adding annotations are allowed.")
    @JsonProperty(value="docMDP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public DocMDPEnum getDocMDP() {
        return this.docMDP;
    }

    @JsonProperty(value="docMDP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocMDP(DocMDPEnum docMDP) {
        this.docMDP = docMDP;
    }

    public MetadataInformation encrypted(Boolean encrypted) {
        this.encrypted = encrypted;
        return this;
    }

    @Schema(name="This will be set to \"true\" for a document, that is either password protected or certificate encrypted.")
    @JsonProperty(value="encrypted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEncrypted() {
        return this.encrypted;
    }

    @JsonProperty(value="encrypted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
    }

    public MetadataInformation fileSize(Long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    @Schema(name="The byte size of the document.")
    @JsonProperty(value="fileSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getFileSize() {
        return this.fileSize;
    }

    @JsonProperty(value="fileSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public MetadataInformation formType(FormTypeEnum formType) {
        this.formType = formType;
        return this;
    }

    @Schema(name="When set to another value than \"none\", the document does contain a PDF form in the hereby given format.  *   none = The document does not contain a form. *   acroForm = The document contains a standard PDF Acroform. *   staticXFA = The document contains a \"XML Forms Architecture\" form with a fixed layout (static). *   dynamicXFA = The document contains a \"XML Forms Architecture\" form with an adaptable/interactive layout (dynamic).")
    @JsonProperty(value="formType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FormTypeEnum getFormType() {
        return this.formType;
    }

    @JsonProperty(value="formType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormType(FormTypeEnum formType) {
        this.formType = formType;
    }

    public MetadataInformation initialPage(Integer initialPage) {
        this.initialPage = initialPage;
        return this;
    }

    @Schema(name="The first page, that shall be displayed when opening the document in a PDF Reader.")
    @JsonProperty(value="initialPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getInitialPage() {
        return this.initialPage;
    }

    @JsonProperty(value="initialPage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitialPage(Integer initialPage) {
        this.initialPage = initialPage;
    }

    public MetadataInformation initialView(InitialViewEnum initialView) {
        this.initialView = initialView;
        return this;
    }

    @Schema(name="Defines which sub-windows will be opened when the PDF document is opened.  *   none = No special view *   outlines = Opens the \"Bookmarks\" tab *   thumbnails = Opens the \"Thumbnails\" tab *   fullscreen = Opens the document in full screen mode")
    @JsonProperty(value="initialView")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public InitialViewEnum getInitialView() {
        return this.initialView;
    }

    @JsonProperty(value="initialView")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitialView(InitialViewEnum initialView) {
        this.initialView = initialView;
    }

    public MetadataInformation language(String language) {
        this.language = language;
        return this;
    }

    @Schema(name="The natural language of the document. This could either contain the language name or a language tag.")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public MetadataInformation magnification(MagnificationEnum magnification) {
        this.magnification = magnification;
        return this;
    }

    @Schema(name="The initial page zoom settings of a document. When opening the document in a Reader, this zoom settings shall be used.  *   none = Uses the application's default view. *   fitWidth = Page width. *   fitPage = Page dimensions. *   fitHeight = Page height. *   fitVisible = Page content width. *   fitActual = Uses the original page dimensions (100% zoom factor). *   zoom = Sets an explicit magnification value.")
    @JsonProperty(value="magnification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MagnificationEnum getMagnification() {
        return this.magnification;
    }

    @JsonProperty(value="magnification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMagnification(MagnificationEnum magnification) {
        this.magnification = magnification;
    }

    public MetadataInformation magnificationZoom(Integer magnificationZoom) {
        this.magnificationZoom = magnificationZoom;
        return this;
    }

    @Schema(name="If a magnification \"zoom\" is selected for this document, this is the actual percentage the pages of the document shall be zoomed to, when opening the document in a PDF Reader.")
    @JsonProperty(value="magnificationZoom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMagnificationZoom() {
        return this.magnificationZoom;
    }

    @JsonProperty(value="magnificationZoom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMagnificationZoom(Integer magnificationZoom) {
        this.magnificationZoom = magnificationZoom;
    }

    public MetadataInformation objectKey(String objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    @Schema(name="The object ID of the document's catalog. (root)  **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getObjectKey() {
        return this.objectKey;
    }

    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public MetadataInformation pageLayout(PageLayoutEnum pageLayout) {
        this.pageLayout = pageLayout;
        return this;
    }

    @Schema(name="The set initial page layout of a document. When opening the document in a Reader, this layout shall be selected to display pages.  *   singlePage = One page at a time. *   oneColumn = One continuous column of pages. *   twoColumnLeft = The pages in two columns, with odd-numbered pages on the left. *   twoColumnRight = The pages in two columns, with odd-numbered pages on the right. *   twoPageLeft = Display the pages two at a time, with odd-numbered pages on the left. *   twoPageRight = Display the pages two at a time, with odd-numbered pages on the right.")
    @JsonProperty(value="pageLayout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PageLayoutEnum getPageLayout() {
        return this.pageLayout;
    }

    @JsonProperty(value="pageLayout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageLayout(PageLayoutEnum pageLayout) {
        this.pageLayout = pageLayout;
    }

    public MetadataInformation pages(Integer pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="The number of pages contained in the document.")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(Integer pages) {
        this.pages = pages;
    }

    public MetadataInformation pdfa(MetadataPdfa pdfa) {
        this.pdfa = pdfa;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="pdfa")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public MetadataPdfa getPdfa() {
        return this.pdfa;
    }

    @JsonProperty(value="pdfa")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPdfa(MetadataPdfa pdfa) {
        this.pdfa = pdfa;
    }

    public MetadataInformation portfolio(Boolean portfolio) {
        this.portfolio = portfolio;
        return this;
    }

    @Schema(name="Will be set to \"true\" for a \"PDF collection\" (Portfolio), that serves as the container for other documents.")
    @JsonProperty(value="portfolio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getPortfolio() {
        return this.portfolio;
    }

    @JsonProperty(value="portfolio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPortfolio(Boolean portfolio) {
        this.portfolio = portfolio;
    }

    public MetadataInformation signatures(Integer signatures) {
        this.signatures = signatures;
        return this;
    }

    @Schema(name="The number of signatures contained in the document.")
    @JsonProperty(value="signatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getSignatures() {
        return this.signatures;
    }

    @JsonProperty(value="signatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignatures(Integer signatures) {
        this.signatures = signatures;
    }

    public MetadataInformation version(String version) {
        this.version = version;
        return this;
    }

    @Schema(name="The version name of the PDF standard the document claims compatibility with.")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(String version) {
        this.version = version;
    }

    public MetadataInformation viewerPreferences(MetadataViewerPreferences viewerPreferences) {
        this.viewerPreferences = viewerPreferences;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="viewerPreferences")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public MetadataViewerPreferences getViewerPreferences() {
        return this.viewerPreferences;
    }

    @JsonProperty(value="viewerPreferences")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setViewerPreferences(MetadataViewerPreferences viewerPreferences) {
        this.viewerPreferences = viewerPreferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataInformation metadataInformation = (MetadataInformation)o;
        return Objects.equals(this.attachments, metadataInformation.attachments) && Objects.equals(this.description, metadataInformation.description) && Objects.equals((Object)this.docMDP, (Object)metadataInformation.docMDP) && Objects.equals(this.encrypted, metadataInformation.encrypted) && Objects.equals(this.fileSize, metadataInformation.fileSize) && Objects.equals((Object)this.formType, (Object)metadataInformation.formType) && Objects.equals(this.initialPage, metadataInformation.initialPage) && Objects.equals((Object)this.initialView, (Object)metadataInformation.initialView) && Objects.equals(this.language, metadataInformation.language) && Objects.equals((Object)this.magnification, (Object)metadataInformation.magnification) && Objects.equals(this.magnificationZoom, metadataInformation.magnificationZoom) && Objects.equals(this.objectKey, metadataInformation.objectKey) && Objects.equals((Object)this.pageLayout, (Object)metadataInformation.pageLayout) && Objects.equals(this.pages, metadataInformation.pages) && Objects.equals(this.pdfa, metadataInformation.pdfa) && Objects.equals(this.portfolio, metadataInformation.portfolio) && Objects.equals(this.signatures, metadataInformation.signatures) && Objects.equals(this.version, metadataInformation.version) && Objects.equals(this.viewerPreferences, metadataInformation.viewerPreferences);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attachments, this.description, this.docMDP, this.encrypted, this.fileSize, this.formType, this.initialPage, this.initialView, this.language, this.magnification, this.magnificationZoom, this.objectKey, this.pageLayout, this.pages, this.pdfa, this.portfolio, this.signatures, this.version, this.viewerPreferences});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataInformation {\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    docMDP: ").append(this.toIndentedString((Object)this.docMDP)).append("\n");
        sb.append("    encrypted: ").append(this.toIndentedString(this.encrypted)).append("\n");
        sb.append("    fileSize: ").append(this.toIndentedString(this.fileSize)).append("\n");
        sb.append("    formType: ").append(this.toIndentedString((Object)this.formType)).append("\n");
        sb.append("    initialPage: ").append(this.toIndentedString(this.initialPage)).append("\n");
        sb.append("    initialView: ").append(this.toIndentedString((Object)this.initialView)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    magnification: ").append(this.toIndentedString((Object)this.magnification)).append("\n");
        sb.append("    magnificationZoom: ").append(this.toIndentedString(this.magnificationZoom)).append("\n");
        sb.append("    objectKey: ").append(this.toIndentedString(this.objectKey)).append("\n");
        sb.append("    pageLayout: ").append(this.toIndentedString((Object)this.pageLayout)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    pdfa: ").append(this.toIndentedString(this.pdfa)).append("\n");
        sb.append("    portfolio: ").append(this.toIndentedString(this.portfolio)).append("\n");
        sb.append("    signatures: ").append(this.toIndentedString(this.signatures)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    viewerPreferences: ").append(this.toIndentedString(this.viewerPreferences)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PageLayoutEnum {
        SINGLEPAGE("singlePage"),
        ONECOLUMN("oneColumn"),
        TWOCOLUMNLEFT("twoColumnLeft"),
        TWOCOLUMNRIGHT("twoColumnRight"),
        TWOPAGELEFT("twoPageLeft"),
        TWOPAGERIGHT("twoPageRight");

        private String value;

        private PageLayoutEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PageLayoutEnum fromValue(String value) {
            for (PageLayoutEnum b : PageLayoutEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MagnificationEnum {
        NONE("none"),
        FITWIDTH("fitWidth"),
        FITVISIBLE("fitVisible"),
        FITHEIGHT("fitHeight"),
        FITPAGE("fitPage"),
        FITACTUAL("fitActual"),
        ZOOM("zoom");

        private String value;

        private MagnificationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MagnificationEnum fromValue(String value) {
            for (MagnificationEnum b : MagnificationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum InitialViewEnum {
        NONE("none"),
        OUTLINES("outlines"),
        THUMBNAILS("thumbnails"),
        FULLSCREEN("fullscreen"),
        LAYERS("layers"),
        ATTACHMENTS("attachments");

        private String value;

        private InitialViewEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InitialViewEnum fromValue(String value) {
            for (InitialViewEnum b : InitialViewEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FormTypeEnum {
        NONE("none"),
        ACROFORM("acroForm"),
        STATICXFA("staticXFA"),
        DYNAMICXFA("dynamicXFA");

        private String value;

        private FormTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FormTypeEnum fromValue(String value) {
            for (FormTypeEnum b : FormTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DocMDPEnum {
        NONE("none"),
        NOCHANGESALLOWED("noChangesAllowed"),
        FORMFILLINGSIGNATURES("formFillingSignatures"),
        FORMFILLINGSIGNATURESANNOTATIONS("formFillingSignaturesAnnotations");

        private String value;

        private DocMDPEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DocMDPEnum fromValue(String value) {
            for (DocMDPEnum b : DocMDPEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

