/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.MetadataAnnotation;
import net.webpdf.wsclient.openapi.MetadataFormValueStyle;
import net.webpdf.wsclient.openapi.MetadataSignature;
import org.jetbrains.annotations.Nullable;

@Schema(description="Lists the properties of a PDF form field.")
@JsonPropertyOrder(value={"alternateName", "annotation", "content", "fullyQualifiedName", "isRichText", "mappingName", "multiSelect", "name", "noExport", "objectKey", "readOnly", "required", "signature", "subType", "type", "value"})
@JsonTypeName(value="Metadata_Field")
public class MetadataField {
    public static final String JSON_PROPERTY_ALTERNATE_NAME = "alternateName";
    private String alternateName = "";
    public static final String JSON_PROPERTY_ANNOTATION = "annotation";
    private List<MetadataAnnotation> annotation = null;
    public static final String JSON_PROPERTY_CONTENT = "content";
    private String content = "";
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    private String fullyQualifiedName = "";
    public static final String JSON_PROPERTY_IS_RICH_TEXT = "isRichText";
    private Boolean isRichText = false;
    public static final String JSON_PROPERTY_MAPPING_NAME = "mappingName";
    private String mappingName = "";
    public static final String JSON_PROPERTY_MULTI_SELECT = "multiSelect";
    private Boolean multiSelect = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_NO_EXPORT = "noExport";
    private Boolean noExport = false;
    public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
    private String objectKey = "";
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly = false;
    public static final String JSON_PROPERTY_REQUIRED = "required";
    private Boolean required = false;
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    private MetadataSignature signature;
    public static final String JSON_PROPERTY_SUB_TYPE = "subType";
    private String subType = "";
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type = "";
    public static final String JSON_PROPERTY_VALUE = "value";
    private List<MetadataFormValueStyle> value = null;

    public MetadataField alternateName(String alternateName) {
        this.alternateName = alternateName;
        return this;
    }

    @Schema(name="The alternate name of the form field.")
    @JsonProperty(value="alternateName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getAlternateName() {
        return this.alternateName;
    }

    @JsonProperty(value="alternateName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlternateName(String alternateName) {
        this.alternateName = alternateName;
    }

    public MetadataField annotation(List<MetadataAnnotation> annotation) {
        this.annotation = annotation;
        return this;
    }

    public MetadataField addAnnotationItem(MetadataAnnotation annotationItem) {
        if (this.annotation == null) {
            this.annotation = new ArrayList<MetadataAnnotation>();
        }
        this.annotation.add(annotationItem);
        return this;
    }

    @Schema(name="Selects the visible representation (widget annotation) for the form field.")
    @JsonProperty(value="annotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<MetadataAnnotation> getAnnotation() {
        return this.annotation;
    }

    @JsonProperty(value="annotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnnotation(List<MetadataAnnotation> annotation) {
        this.annotation = annotation;
    }

    public MetadataField content(String content) {
        this.content = content;
        return this;
    }

    @Schema(name="The textual content of the form field. A single string or a comma-separated list of string values for list types.")
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContent(String content) {
        this.content = content;
    }

    public MetadataField fullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Schema(name="The fully qualified name of the form field.")
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public MetadataField isRichText(Boolean isRichText) {
        this.isRichText = isRichText;
        return this;
    }

    @Schema(name="When set to true, the field contains rich text formatted content.")
    @JsonProperty(value="isRichText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIsRichText() {
        return this.isRichText;
    }

    @JsonProperty(value="isRichText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsRichText(Boolean isRichText) {
        this.isRichText = isRichText;
    }

    public MetadataField mappingName(String mappingName) {
        this.mappingName = mappingName;
        return this;
    }

    @Schema(name="The mapping name of the form field.")
    @JsonProperty(value="mappingName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getMappingName() {
        return this.mappingName;
    }

    @JsonProperty(value="mappingName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMappingName(String mappingName) {
        this.mappingName = mappingName;
    }

    public MetadataField multiSelect(Boolean multiSelect) {
        this.multiSelect = multiSelect;
        return this;
    }

    @Schema(name="When set to true, the form field allows multiple items to be seleted.")
    @JsonProperty(value="multiSelect")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getMultiSelect() {
        return this.multiSelect;
    }

    @JsonProperty(value="multiSelect")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMultiSelect(Boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public MetadataField name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="The partial name of the form field.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public MetadataField noExport(Boolean noExport) {
        this.noExport = noExport;
        return this;
    }

    @Schema(name="When set to true, the form field shall not be included in exports of the document's form data.")
    @JsonProperty(value="noExport")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getNoExport() {
        return this.noExport;
    }

    @JsonProperty(value="noExport")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNoExport(Boolean noExport) {
        this.noExport = noExport;
    }

    public MetadataField objectKey(String objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    @Schema(name="The object ID of the form field. **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getObjectKey() {
        return this.objectKey;
    }

    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public MetadataField readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Schema(name="When set to true, the form field's contents may be displayed but not altered.")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public MetadataField required(Boolean required) {
        this.required = required;
        return this;
    }

    @Schema(name="When set to true, the form field must be filled in.")
    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRequired() {
        return this.required;
    }

    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequired(Boolean required) {
        this.required = required;
    }

    public MetadataField signature(MetadataSignature signature) {
        this.signature = signature;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="signature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataSignature getSignature() {
        return this.signature;
    }

    @JsonProperty(value="signature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignature(MetadataSignature signature) {
        this.signature = signature;
    }

    public MetadataField subType(String subType) {
        this.subType = subType;
        return this;
    }

    @Schema(name="The implementation name of the the form field.")
    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSubType() {
        return this.subType;
    }

    @JsonProperty(value="subType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubType(String subType) {
        this.subType = subType;
    }

    public MetadataField type(String type) {
        this.type = type;
        return this;
    }

    @Schema(name="Indicates the type of the form field.  *   Btn = Button *   Tx = Textfield *   Ch = Choicefield *   Sig = Signaturefield")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public MetadataField value(List<MetadataFormValueStyle> value) {
        this.value = value;
        return this;
    }

    public MetadataField addValueItem(MetadataFormValueStyle valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<MetadataFormValueStyle>();
        }
        this.value.add(valueItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<MetadataFormValueStyle> getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(List<MetadataFormValueStyle> value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataField metadataField = (MetadataField)o;
        return Objects.equals(this.alternateName, metadataField.alternateName) && Objects.equals(this.annotation, metadataField.annotation) && Objects.equals(this.content, metadataField.content) && Objects.equals(this.fullyQualifiedName, metadataField.fullyQualifiedName) && Objects.equals(this.isRichText, metadataField.isRichText) && Objects.equals(this.mappingName, metadataField.mappingName) && Objects.equals(this.multiSelect, metadataField.multiSelect) && Objects.equals(this.name, metadataField.name) && Objects.equals(this.noExport, metadataField.noExport) && Objects.equals(this.objectKey, metadataField.objectKey) && Objects.equals(this.readOnly, metadataField.readOnly) && Objects.equals(this.required, metadataField.required) && Objects.equals(this.signature, metadataField.signature) && Objects.equals(this.subType, metadataField.subType) && Objects.equals(this.type, metadataField.type) && Objects.equals(this.value, metadataField.value);
    }

    public int hashCode() {
        return Objects.hash(this.alternateName, this.annotation, this.content, this.fullyQualifiedName, this.isRichText, this.mappingName, this.multiSelect, this.name, this.noExport, this.objectKey, this.readOnly, this.required, this.signature, this.subType, this.type, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataField {\n");
        sb.append("    alternateName: ").append(this.toIndentedString(this.alternateName)).append("\n");
        sb.append("    annotation: ").append(this.toIndentedString(this.annotation)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    isRichText: ").append(this.toIndentedString(this.isRichText)).append("\n");
        sb.append("    mappingName: ").append(this.toIndentedString(this.mappingName)).append("\n");
        sb.append("    multiSelect: ").append(this.toIndentedString(this.multiSelect)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    noExport: ").append(this.toIndentedString(this.noExport)).append("\n");
        sb.append("    objectKey: ").append(this.toIndentedString(this.objectKey)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    subType: ").append(this.toIndentedString(this.subType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

