/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Selects a border style for a drawn shape's outline.")
@JsonPropertyOrder(value={"dashPattern", "dashPhase", "effectIntensity", "effectStyle", "interiorColor", "style", "width"})
@JsonTypeName(value="Metadata_BorderStyle")
public class MetadataBorderStyle {
    public static final String JSON_PROPERTY_DASH_PATTERN = "dashPattern";
    private String dashPattern = "";
    public static final String JSON_PROPERTY_DASH_PHASE = "dashPhase";
    private Integer dashPhase = 0;
    public static final String JSON_PROPERTY_EFFECT_INTENSITY = "effectIntensity";
    private Float effectIntensity = Float.valueOf(0.0f);
    public static final String JSON_PROPERTY_EFFECT_STYLE = "effectStyle";
    private String effectStyle = "";
    public static final String JSON_PROPERTY_INTERIOR_COLOR = "interiorColor";
    private String interiorColor = "#4800FF";
    public static final String JSON_PROPERTY_STYLE = "style";
    private String style = "S";
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Float width = Float.valueOf(1.0f);

    public MetadataBorderStyle dashPattern(String dashPattern) {
        this.dashPattern = dashPattern;
        return this;
    }

    @Schema(name="The dash pattern (array) of a dashed border. The dash array contains the unit lengths of alternating dashes and gaps, that shall be cycled through along the length of the border.")
    @JsonProperty(value="dashPattern")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getDashPattern() {
        return this.dashPattern;
    }

    @JsonProperty(value="dashPattern")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDashPattern(String dashPattern) {
        this.dashPattern = dashPattern;
    }

    public MetadataBorderStyle dashPhase(Integer dashPhase) {
        this.dashPhase = dashPhase;
        return this;
    }

    @Schema(name="The phase of the dash pattern.")
    @JsonProperty(value="dashPhase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDashPhase() {
        return this.dashPhase;
    }

    @JsonProperty(value="dashPhase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDashPhase(Integer dashPhase) {
        this.dashPhase = dashPhase;
    }

    public MetadataBorderStyle effectIntensity(Float effectIntensity) {
        this.effectIntensity = effectIntensity;
        return this;
    }

    @Schema(name="The intensity of a possibly set cloud effect, in a range from 0 to 2.")
    @JsonProperty(value="effectIntensity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getEffectIntensity() {
        return this.effectIntensity;
    }

    @JsonProperty(value="effectIntensity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEffectIntensity(Float effectIntensity) {
        this.effectIntensity = effectIntensity;
    }

    public MetadataBorderStyle effectStyle(String effectStyle) {
        this.effectStyle = effectStyle;
        return this;
    }

    @Schema(name="The border effect to apply to the border shape.  *   S = Apply no border effects. *   C = Apply a cloud pattern to the border shape.")
    @JsonProperty(value="effectStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getEffectStyle() {
        return this.effectStyle;
    }

    @JsonProperty(value="effectStyle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEffectStyle(String effectStyle) {
        this.effectStyle = effectStyle;
    }

    public MetadataBorderStyle interiorColor(String interiorColor) {
        this.interiorColor = interiorColor;
        return this;
    }

    @Schema(name="The interior (fill) color for the shape.")
    @JsonProperty(value="interiorColor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getInteriorColor() {
        return this.interiorColor;
    }

    @JsonProperty(value="interiorColor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInteriorColor(String interiorColor) {
        this.interiorColor = interiorColor;
    }

    public MetadataBorderStyle style(String style) {
        this.style = style;
        return this;
    }

    @Schema(name="The style of the shapes border.  *   S = Solid *   D = Dashed *   B = Beveled *   I = Inset *   U = Underline  **Important:** Further custom styles may be contained and shall default to a solid border if unknown.")
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStyle(String style) {
        this.style = style;
    }

    public MetadataBorderStyle width(Float width) {
        this.width = width;
        return this;
    }

    @Schema(name="The border width/line thickness in points.")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Float getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWidth(Float width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataBorderStyle metadataBorderStyle = (MetadataBorderStyle)o;
        return Objects.equals(this.dashPattern, metadataBorderStyle.dashPattern) && Objects.equals(this.dashPhase, metadataBorderStyle.dashPhase) && Objects.equals(this.effectIntensity, metadataBorderStyle.effectIntensity) && Objects.equals(this.effectStyle, metadataBorderStyle.effectStyle) && Objects.equals(this.interiorColor, metadataBorderStyle.interiorColor) && Objects.equals(this.style, metadataBorderStyle.style) && Objects.equals(this.width, metadataBorderStyle.width);
    }

    public int hashCode() {
        return Objects.hash(this.dashPattern, this.dashPhase, this.effectIntensity, this.effectStyle, this.interiorColor, this.style, this.width);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataBorderStyle {\n");
        sb.append("    dashPattern: ").append(this.toIndentedString(this.dashPattern)).append("\n");
        sb.append("    dashPhase: ").append(this.toIndentedString(this.dashPhase)).append("\n");
        sb.append("    effectIntensity: ").append(this.toIndentedString(this.effectIntensity)).append("\n");
        sb.append("    effectStyle: ").append(this.toIndentedString(this.effectStyle)).append("\n");
        sb.append("    interiorColor: ").append(this.toIndentedString(this.interiorColor)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

