/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.DocumentFileFilterRule;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a file filter with a list of \"include\" and \"exclude\" filter rules. First, the \"include rules\" are applied. If a file matches, the \"exclude rules\" are applied. Only if both rules apply, the file will be passed through the filter.")
@JsonPropertyOrder(value={"excludeRules", "includeRules"})
@JsonTypeName(value="Document_FileFilter")
public class DocumentFileFilter {
    public static final String JSON_PROPERTY_EXCLUDE_RULES = "excludeRules";
    private List<DocumentFileFilterRule> excludeRules = null;
    public static final String JSON_PROPERTY_INCLUDE_RULES = "includeRules";
    private List<DocumentFileFilterRule> includeRules = null;

    public DocumentFileFilter excludeRules(List<DocumentFileFilterRule> excludeRules) {
        this.excludeRules = excludeRules;
        return this;
    }

    public DocumentFileFilter addExcludeRulesItem(DocumentFileFilterRule excludeRulesItem) {
        if (this.excludeRules == null) {
            this.excludeRules = new ArrayList<DocumentFileFilterRule>();
        }
        this.excludeRules.add(excludeRulesItem);
        return this;
    }

    @Schema(name="Sets the list of rules for files to be excluded (black list)")
    @JsonProperty(value="excludeRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<DocumentFileFilterRule> getExcludeRules() {
        return this.excludeRules;
    }

    @JsonProperty(value="excludeRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExcludeRules(List<DocumentFileFilterRule> excludeRules) {
        this.excludeRules = excludeRules;
    }

    public DocumentFileFilter includeRules(List<DocumentFileFilterRule> includeRules) {
        this.includeRules = includeRules;
        return this;
    }

    public DocumentFileFilter addIncludeRulesItem(DocumentFileFilterRule includeRulesItem) {
        if (this.includeRules == null) {
            this.includeRules = new ArrayList<DocumentFileFilterRule>();
        }
        this.includeRules.add(includeRulesItem);
        return this;
    }

    @Schema(name="Sets the list of rules for files to be included (white list)")
    @JsonProperty(value="includeRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<DocumentFileFilterRule> getIncludeRules() {
        return this.includeRules;
    }

    @JsonProperty(value="includeRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeRules(List<DocumentFileFilterRule> includeRules) {
        this.includeRules = includeRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentFileFilter documentFileFilter = (DocumentFileFilter)o;
        return Objects.equals(this.excludeRules, documentFileFilter.excludeRules) && Objects.equals(this.includeRules, documentFileFilter.includeRules);
    }

    public int hashCode() {
        return Objects.hash(this.excludeRules, this.includeRules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentFileFilter {\n");
        sb.append("    excludeRules: ").append(this.toIndentedString(this.excludeRules)).append("\n");
        sb.append("    includeRules: ").append(this.toIndentedString(this.includeRules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

