/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.DocumentPassword;
import net.webpdf.wsclient.openapi.MetadataDocument;
import net.webpdf.wsclient.openapi.WebserviceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="Contains the file information about a document in the document storage")
@JsonPropertyOrder(value={"documentId", "error", "fileExtension", "fileLastModified", "fileName", "filePath", "fileSize", "fileTypeGroups", "fileTypeId", "historyId", "isFileLocked", "metadata", "mimeType", "parentDocumentId", "password"})
@JsonTypeName(value="Document_File")
public class DocumentFile {
    public static final String JSON_PROPERTY_DOCUMENT_ID = "documentId";
    private String documentId = "";
    public static final String JSON_PROPERTY_ERROR = "error";
    private WebserviceException error;
    public static final String JSON_PROPERTY_FILE_EXTENSION = "fileExtension";
    private String fileExtension = "";
    public static final String JSON_PROPERTY_FILE_LAST_MODIFIED = "fileLastModified";
    private String fileLastModified = "";
    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    private String fileName = "";
    public static final String JSON_PROPERTY_FILE_PATH = "filePath";
    private String filePath = "";
    public static final String JSON_PROPERTY_FILE_SIZE = "fileSize";
    private Long fileSize = 0L;
    public static final String JSON_PROPERTY_FILE_TYPE_GROUPS = "fileTypeGroups";
    private String fileTypeGroups = "";
    public static final String JSON_PROPERTY_FILE_TYPE_ID = "fileTypeId";
    private Integer fileTypeId = 0;
    public static final String JSON_PROPERTY_HISTORY_ID = "historyId";
    private Integer historyId = 0;
    public static final String JSON_PROPERTY_IS_FILE_LOCKED = "isFileLocked";
    private Boolean isFileLocked = false;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private MetadataDocument metadata;
    public static final String JSON_PROPERTY_MIME_TYPE = "mimeType";
    private String mimeType = "";
    public static final String JSON_PROPERTY_PARENT_DOCUMENT_ID = "parentDocumentId";
    private String parentDocumentId = "";
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private DocumentPassword password;

    public DocumentFile() {
    }

    @JsonCreator
    public DocumentFile(@JsonProperty(value="documentId") String documentId, @JsonProperty(value="fileExtension") String fileExtension, @JsonProperty(value="fileLastModified") String fileLastModified, @JsonProperty(value="filePath") String filePath, @JsonProperty(value="fileSize") Long fileSize, @JsonProperty(value="fileTypeGroups") String fileTypeGroups, @JsonProperty(value="fileTypeId") Integer fileTypeId, @JsonProperty(value="historyId") Integer historyId, @JsonProperty(value="isFileLocked") Boolean isFileLocked, @JsonProperty(value="mimeType") String mimeType, @JsonProperty(value="parentDocumentId") String parentDocumentId) {
        this();
        this.documentId = documentId;
        this.fileExtension = fileExtension;
        this.fileLastModified = fileLastModified;
        this.filePath = filePath;
        this.fileSize = fileSize;
        this.fileTypeGroups = fileTypeGroups;
        this.fileTypeId = fileTypeId;
        this.historyId = historyId;
        this.isFileLocked = isFileLocked;
        this.mimeType = mimeType;
        this.parentDocumentId = parentDocumentId;
    }

    @Schema(required=true, name="Unique document id, which is required to access this document")
    @JsonProperty(value="documentId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getDocumentId() {
        return this.documentId;
    }

    public DocumentFile error(WebserviceException error) {
        this.error = error;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public WebserviceException getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setError(WebserviceException error) {
        this.error = error;
    }

    @Schema(name="File extension (without dot)")
    @JsonProperty(value="fileExtension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Schema(name="Date of the last file modification")
    @JsonProperty(value="fileLastModified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFileLastModified() {
        return this.fileLastModified;
    }

    public DocumentFile fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Schema(name="File name for the document (without extension)")
    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Schema(name="File path for the document")
    @JsonProperty(value="filePath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFilePath() {
        return this.filePath;
    }

    @Schema(name="File size of the document (in bytes)")
    @JsonProperty(value="fileSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Long getFileSize() {
        return this.fileSize;
    }

    @Schema(name="An internal unique text that describes the group to which the file belongs")
    @JsonProperty(value="fileTypeGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFileTypeGroups() {
        return this.fileTypeGroups;
    }

    @Schema(name="An internal unique id for the file type")
    @JsonProperty(value="fileTypeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getFileTypeId() {
        return this.fileTypeId;
    }

    @Schema(name="History id of the file entry")
    @JsonProperty(value="historyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getHistoryId() {
        return this.historyId;
    }

    @Schema(name="File is locked on the server, because an other operation uses the file")
    @JsonProperty(value="isFileLocked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIsFileLocked() {
        return this.isFileLocked;
    }

    public DocumentFile metadata(MetadataDocument metadata) {
        this.metadata = metadata;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataDocument getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(MetadataDocument metadata) {
        this.metadata = metadata;
    }

    @Schema(name="Mime type of the document")
    @JsonProperty(value="mimeType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getMimeType() {
        return this.mimeType;
    }

    @Schema(name="If available, the id of the parent document")
    @JsonProperty(value="parentDocumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getParentDocumentId() {
        return this.parentDocumentId;
    }

    public DocumentFile password(DocumentPassword password) {
        this.password = password;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public DocumentPassword getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(DocumentPassword password) {
        this.password = password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentFile documentFile = (DocumentFile)o;
        return Objects.equals(this.documentId, documentFile.documentId) && Objects.equals(this.error, documentFile.error) && Objects.equals(this.fileExtension, documentFile.fileExtension) && Objects.equals(this.fileLastModified, documentFile.fileLastModified) && Objects.equals(this.fileName, documentFile.fileName) && Objects.equals(this.filePath, documentFile.filePath) && Objects.equals(this.fileSize, documentFile.fileSize) && Objects.equals(this.fileTypeGroups, documentFile.fileTypeGroups) && Objects.equals(this.fileTypeId, documentFile.fileTypeId) && Objects.equals(this.historyId, documentFile.historyId) && Objects.equals(this.isFileLocked, documentFile.isFileLocked) && Objects.equals(this.metadata, documentFile.metadata) && Objects.equals(this.mimeType, documentFile.mimeType) && Objects.equals(this.parentDocumentId, documentFile.parentDocumentId) && Objects.equals(this.password, documentFile.password);
    }

    public int hashCode() {
        return Objects.hash(this.documentId, this.error, this.fileExtension, this.fileLastModified, this.fileName, this.filePath, this.fileSize, this.fileTypeGroups, this.fileTypeId, this.historyId, this.isFileLocked, this.metadata, this.mimeType, this.parentDocumentId, this.password);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentFile {\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    fileExtension: ").append(this.toIndentedString(this.fileExtension)).append("\n");
        sb.append("    fileLastModified: ").append(this.toIndentedString(this.fileLastModified)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    filePath: ").append(this.toIndentedString(this.filePath)).append("\n");
        sb.append("    fileSize: ").append(this.toIndentedString(this.fileSize)).append("\n");
        sb.append("    fileTypeGroups: ").append(this.toIndentedString(this.fileTypeGroups)).append("\n");
        sb.append("    fileTypeId: ").append(this.toIndentedString(this.fileTypeId)).append("\n");
        sb.append("    historyId: ").append(this.toIndentedString(this.historyId)).append("\n");
        sb.append("    isFileLocked: ").append(this.toIndentedString(this.isFileLocked)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    parentDocumentId: ").append(this.toIndentedString(this.parentDocumentId)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

