/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ApplicationConfigPortalAuthTimeout;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines which settings apply for authentication to the portal.")
@JsonPropertyOrder(value={"allowAnonymous", "enabled", "timeout"})
@JsonTypeName(value="ApplicationConfig_PortalAuth")
public class ApplicationConfigPortalAuth {
    public static final String JSON_PROPERTY_ALLOW_ANONYMOUS = "allowAnonymous";
    private Boolean allowAnonymous = true;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_TIMEOUT = "timeout";
    private ApplicationConfigPortalAuthTimeout timeout;

    public ApplicationConfigPortalAuth allowAnonymous(Boolean allowAnonymous) {
        this.allowAnonymous = allowAnonymous;
        return this;
    }

    @Schema(name="If enabled, then anonymous login (without username and password) are allowed on the front end portal page. This has no effect on the admin page, which always denies anonymous access.")
    @JsonProperty(value="allowAnonymous")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getAllowAnonymous() {
        return this.allowAnonymous;
    }

    @JsonProperty(value="allowAnonymous")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowAnonymous(Boolean allowAnonymous) {
        this.allowAnonymous = allowAnonymous;
    }

    public ApplicationConfigPortalAuth enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="Defines whether the login for the front end portal page is available or not. This has no effect on the admin page, which is always available.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ApplicationConfigPortalAuth timeout(ApplicationConfigPortalAuthTimeout timeout) {
        this.timeout = timeout;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ApplicationConfigPortalAuthTimeout getTimeout() {
        return this.timeout;
    }

    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeout(ApplicationConfigPortalAuthTimeout timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationConfigPortalAuth applicationConfigPortalAuth = (ApplicationConfigPortalAuth)o;
        return Objects.equals(this.allowAnonymous, applicationConfigPortalAuth.allowAnonymous) && Objects.equals(this.enabled, applicationConfigPortalAuth.enabled) && Objects.equals(this.timeout, applicationConfigPortalAuth.timeout);
    }

    public int hashCode() {
        return Objects.hash(this.allowAnonymous, this.enabled, this.timeout);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationConfigPortalAuth {\n");
        sb.append("    allowAnonymous: ").append(this.toIndentedString(this.allowAnonymous)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

