
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for TiffCompressionType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="TiffCompressionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="rle"/>
 *     <enumeration value="deflate"/>
 *     <enumeration value="group3"/>
 *     <enumeration value="group4"/>
 *     <enumeration value="jpeg"/>
 *     <enumeration value="lzw"/>
 *     <enumeration value="packbits"/>
 *     <enumeration value="zlib"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "TiffCompressionType")
@XmlEnum
public enum TiffCompressionType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("rle")
    RLE("rle"),
    @XmlEnumValue("deflate")
    DEFLATE("deflate"),
    @XmlEnumValue("group3")
    GROUP_3("group3"),
    @XmlEnumValue("group4")
    GROUP_4("group4"),
    @XmlEnumValue("jpeg")
    JPEG("jpeg"),
    @XmlEnumValue("lzw")
    LZW("lzw"),
    @XmlEnumValue("packbits")
    PACKBITS("packbits"),
    @XmlEnumValue("zlib")
    ZLIB("zlib");
    private final String value;

    TiffCompressionType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static TiffCompressionType fromValue(String v) {
        for (TiffCompressionType c: TiffCompressionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
