
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for SplitModeType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="SplitModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="last"/>
 *     <enumeration value="first"/>
 *     <enumeration value="list"/>
 *     <enumeration value="single"/>
 *     <enumeration value="each"/>
 *     <enumeration value="group"/>
 *     <enumeration value="burst"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "SplitModeType")
@XmlEnum
public enum SplitModeType {

    @XmlEnumValue("last")
    LAST("last"),
    @XmlEnumValue("first")
    FIRST("first"),
    @XmlEnumValue("list")
    LIST("list"),
    @XmlEnumValue("single")
    SINGLE("single"),
    @XmlEnumValue("each")
    EACH("each"),
    @XmlEnumValue("group")
    GROUP("group"),
    @XmlEnumValue("burst")
    BURST("burst");
    private final String value;

    SplitModeType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static SplitModeType fromValue(String v) {
        for (SplitModeType c: SplitModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
