
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PageGroupType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="PageGroupType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="all"/>
 *     <enumeration value="even"/>
 *     <enumeration value="odd"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PageGroupType")
@XmlEnum
public enum PageGroupType {

    @XmlEnumValue("all")
    ALL("all"),
    @XmlEnumValue("even")
    EVEN("even"),
    @XmlEnumValue("odd")
    ODD("odd");
    private final String value;

    PageGroupType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PageGroupType fromValue(String v) {
        for (PageGroupType c: PageGroupType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
