
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179664_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p388603_="https://jakarta.ee/xml/ns/jaxb" xmlns:p96940_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The options operation element can be used to change the way documents are displayed.&#13;
 * &#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p179664_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:p388603_="https://jakarta.ee/xml/ns/jaxb" xmlns:p96940_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;b&gt;Tip:&lt;/b&gt;&#13;
 *                     For all hereby contained options, please consult the chapter "Display Options". This is especially important concerning the content format of headers and footers.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for OptionsType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="OptionsType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <all>
 *         <element name="pageTransitions" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice maxOccurs="unbounded">
 *                   <element name="add">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="pageTransition" type="{http://schema.webpdf.de/1.0/operation}TransitionType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                   <element name="remove">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="transitionSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionTransitionType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="background" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice>
 *                   <element name="add">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="colorBackground" type="{http://schema.webpdf.de/1.0/operation}ColorBackgroundType"/>
 *                             <element name="imageBackground" type="{http://schema.webpdf.de/1.0/operation}ImageBackgroundType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                   <element name="remove">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="backgroundSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionBackgroundType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="headerFooter" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice>
 *                   <element name="add">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="headerFooterContent" type="{http://schema.webpdf.de/1.0/operation}HeaderFooterType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                   <element name="remove">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="headerFooterSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionHeaderFooterType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="boxes" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice maxOccurs="unbounded">
 *                   <element name="resize">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="boxesResize" type="{http://schema.webpdf.de/1.0/operation}BoxesResizeType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                   <element name="remove">
 *                     <complexType>
 *                       <complexContent>
 *                         <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           <choice>
 *                             <element name="boxesRemove" type="{http://schema.webpdf.de/1.0/operation}SelectionBoxType"/>
 *                           </choice>
 *                         </restriction>
 *                       </complexContent>
 *                     </complexType>
 *                   </element>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *         <element name="viewerPreferences" type="{http://schema.webpdf.de/1.0/operation}ViewerPreferencesType" minOccurs="0"/>
 *       </all>
 *       <attribute name="pageLayout" type="{http://schema.webpdf.de/1.0/operation}PageLayoutType" default="singlePage" />
 *       <attribute name="initialView" type="{http://schema.webpdf.de/1.0/operation}InitialViewType" default="none" />
 *       <attribute name="magnification" type="{http://schema.webpdf.de/1.0/operation}MagnificationType" default="fitWidth" />
 *       <attribute name="magnificationZoom" default="100">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="6400"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="initialPage" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="language" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OptionsType", propOrder = {
    "pageTransitions",
    "background",
    "headerFooter",
    "boxes",
    "viewerPreferences"
})
public class OptionsType
    extends BaseToolboxType
{

    protected OptionsType.PageTransitions pageTransitions;
    protected OptionsType.Background background;
    protected OptionsType.HeaderFooter headerFooter;
    protected OptionsType.Boxes boxes;
    protected ViewerPreferencesType viewerPreferences;
    @XmlAttribute(name = "pageLayout")
    protected PageLayoutType pageLayout;
    @XmlAttribute(name = "initialView")
    protected InitialViewType initialView;
    @XmlAttribute(name = "magnification")
    protected MagnificationType magnification;
    @XmlAttribute(name = "magnificationZoom")
    protected Integer magnificationZoom;
    @XmlAttribute(name = "initialPage")
    protected Integer initialPage;
    @XmlAttribute(name = "language")
    protected String language;

    /**
     * Gets the value of the pageTransitions property.
     * 
     * @return
     *     possible object is
     *     {@link OptionsType.PageTransitions }
     *     
     */
    public OptionsType.PageTransitions getPageTransitions() {
        return pageTransitions;
    }

    /**
     * Sets the value of the pageTransitions property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptionsType.PageTransitions }
     *     
     */
    public void setPageTransitions(OptionsType.PageTransitions value) {
        this.pageTransitions = value;
    }

    public boolean isSetPageTransitions() {
        return (this.pageTransitions!= null);
    }

    /**
     * Gets the value of the background property.
     * 
     * @return
     *     possible object is
     *     {@link OptionsType.Background }
     *     
     */
    public OptionsType.Background getBackground() {
        return background;
    }

    /**
     * Sets the value of the background property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptionsType.Background }
     *     
     */
    public void setBackground(OptionsType.Background value) {
        this.background = value;
    }

    public boolean isSetBackground() {
        return (this.background!= null);
    }

    /**
     * Gets the value of the headerFooter property.
     * 
     * @return
     *     possible object is
     *     {@link OptionsType.HeaderFooter }
     *     
     */
    public OptionsType.HeaderFooter getHeaderFooter() {
        return headerFooter;
    }

    /**
     * Sets the value of the headerFooter property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptionsType.HeaderFooter }
     *     
     */
    public void setHeaderFooter(OptionsType.HeaderFooter value) {
        this.headerFooter = value;
    }

    public boolean isSetHeaderFooter() {
        return (this.headerFooter!= null);
    }

    /**
     * Gets the value of the boxes property.
     * 
     * @return
     *     possible object is
     *     {@link OptionsType.Boxes }
     *     
     */
    public OptionsType.Boxes getBoxes() {
        return boxes;
    }

    /**
     * Sets the value of the boxes property.
     * 
     * @param value
     *     allowed object is
     *     {@link OptionsType.Boxes }
     *     
     */
    public void setBoxes(OptionsType.Boxes value) {
        this.boxes = value;
    }

    public boolean isSetBoxes() {
        return (this.boxes!= null);
    }

    /**
     * Gets the value of the viewerPreferences property.
     * 
     * @return
     *     possible object is
     *     {@link ViewerPreferencesType }
     *     
     */
    public ViewerPreferencesType getViewerPreferences() {
        return viewerPreferences;
    }

    /**
     * Sets the value of the viewerPreferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link ViewerPreferencesType }
     *     
     */
    public void setViewerPreferences(ViewerPreferencesType value) {
        this.viewerPreferences = value;
    }

    public boolean isSetViewerPreferences() {
        return (this.viewerPreferences!= null);
    }

    /**
     * Gets the value of the pageLayout property.
     * 
     * @return
     *     possible object is
     *     {@link PageLayoutType }
     *     
     */
    public PageLayoutType getPageLayout() {
        if (pageLayout == null) {
            return PageLayoutType.SINGLE_PAGE;
        } else {
            return pageLayout;
        }
    }

    /**
     * Sets the value of the pageLayout property.
     * 
     * @param value
     *     allowed object is
     *     {@link PageLayoutType }
     *     
     */
    public void setPageLayout(PageLayoutType value) {
        this.pageLayout = value;
    }

    public boolean isSetPageLayout() {
        return (this.pageLayout!= null);
    }

    /**
     * Gets the value of the initialView property.
     * 
     * @return
     *     possible object is
     *     {@link InitialViewType }
     *     
     */
    public InitialViewType getInitialView() {
        if (initialView == null) {
            return InitialViewType.NONE;
        } else {
            return initialView;
        }
    }

    /**
     * Sets the value of the initialView property.
     * 
     * @param value
     *     allowed object is
     *     {@link InitialViewType }
     *     
     */
    public void setInitialView(InitialViewType value) {
        this.initialView = value;
    }

    public boolean isSetInitialView() {
        return (this.initialView!= null);
    }

    /**
     * Gets the value of the magnification property.
     * 
     * @return
     *     possible object is
     *     {@link MagnificationType }
     *     
     */
    public MagnificationType getMagnification() {
        if (magnification == null) {
            return MagnificationType.FIT_WIDTH;
        } else {
            return magnification;
        }
    }

    /**
     * Sets the value of the magnification property.
     * 
     * @param value
     *     allowed object is
     *     {@link MagnificationType }
     *     
     */
    public void setMagnification(MagnificationType value) {
        this.magnification = value;
    }

    public boolean isSetMagnification() {
        return (this.magnification!= null);
    }

    /**
     * Gets the value of the magnificationZoom property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getMagnificationZoom() {
        if (magnificationZoom == null) {
            return  100;
        } else {
            return magnificationZoom;
        }
    }

    /**
     * Sets the value of the magnificationZoom property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setMagnificationZoom(int value) {
        this.magnificationZoom = value;
    }

    public boolean isSetMagnificationZoom() {
        return (this.magnificationZoom!= null);
    }

    public void unsetMagnificationZoom() {
        this.magnificationZoom = null;
    }

    /**
     * Gets the value of the initialPage property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getInitialPage() {
        if (initialPage == null) {
            return  1;
        } else {
            return initialPage;
        }
    }

    /**
     * Sets the value of the initialPage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setInitialPage(int value) {
        this.initialPage = value;
    }

    public boolean isSetInitialPage() {
        return (this.initialPage!= null);
    }

    public void unsetInitialPage() {
        this.initialPage = null;
    }

    /**
     * Gets the value of the language property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLanguage() {
        if (language == null) {
            return "";
        } else {
            return language;
        }
    }

    /**
     * Sets the value of the language property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLanguage(String value) {
        this.language = value;
    }

    public boolean isSetLanguage() {
        return (this.language!= null);
    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice>
     *         <element name="add">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="colorBackground" type="{http://schema.webpdf.de/1.0/operation}ColorBackgroundType"/>
     *                   <element name="imageBackground" type="{http://schema.webpdf.de/1.0/operation}ImageBackgroundType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *         <element name="remove">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="backgroundSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionBackgroundType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "add",
        "remove"
    })
    public static class Background {

        protected OptionsType.Background.Add add;
        protected OptionsType.Background.Remove remove;

        /**
         * Gets the value of the add property.
         * 
         * @return
         *     possible object is
         *     {@link OptionsType.Background.Add }
         *     
         */
        public OptionsType.Background.Add getAdd() {
            return add;
        }

        /**
         * Sets the value of the add property.
         * 
         * @param value
         *     allowed object is
         *     {@link OptionsType.Background.Add }
         *     
         */
        public void setAdd(OptionsType.Background.Add value) {
            this.add = value;
        }

        public boolean isSetAdd() {
            return (this.add!= null);
        }

        /**
         * Gets the value of the remove property.
         * 
         * @return
         *     possible object is
         *     {@link OptionsType.Background.Remove }
         *     
         */
        public OptionsType.Background.Remove getRemove() {
            return remove;
        }

        /**
         * Sets the value of the remove property.
         * 
         * @param value
         *     allowed object is
         *     {@link OptionsType.Background.Remove }
         *     
         */
        public void setRemove(OptionsType.Background.Remove value) {
            this.remove = value;
        }

        public boolean isSetRemove() {
            return (this.remove!= null);
        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="colorBackground" type="{http://schema.webpdf.de/1.0/operation}ColorBackgroundType"/>
         *         <element name="imageBackground" type="{http://schema.webpdf.de/1.0/operation}ImageBackgroundType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "colorBackground",
            "imageBackground"
        })
        public static class Add {

            protected ColorBackgroundType colorBackground;
            protected ImageBackgroundType imageBackground;

            /**
             * Gets the value of the colorBackground property.
             * 
             * @return
             *     possible object is
             *     {@link ColorBackgroundType }
             *     
             */
            public ColorBackgroundType getColorBackground() {
                return colorBackground;
            }

            /**
             * Sets the value of the colorBackground property.
             * 
             * @param value
             *     allowed object is
             *     {@link ColorBackgroundType }
             *     
             */
            public void setColorBackground(ColorBackgroundType value) {
                this.colorBackground = value;
            }

            public boolean isSetColorBackground() {
                return (this.colorBackground!= null);
            }

            /**
             * Gets the value of the imageBackground property.
             * 
             * @return
             *     possible object is
             *     {@link ImageBackgroundType }
             *     
             */
            public ImageBackgroundType getImageBackground() {
                return imageBackground;
            }

            /**
             * Sets the value of the imageBackground property.
             * 
             * @param value
             *     allowed object is
             *     {@link ImageBackgroundType }
             *     
             */
            public void setImageBackground(ImageBackgroundType value) {
                this.imageBackground = value;
            }

            public boolean isSetImageBackground() {
                return (this.imageBackground!= null);
            }

        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="backgroundSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionBackgroundType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "backgroundSelection"
        })
        public static class Remove {

            protected SelectionBackgroundType backgroundSelection;

            /**
             * Gets the value of the backgroundSelection property.
             * 
             * @return
             *     possible object is
             *     {@link SelectionBackgroundType }
             *     
             */
            public SelectionBackgroundType getBackgroundSelection() {
                return backgroundSelection;
            }

            /**
             * Sets the value of the backgroundSelection property.
             * 
             * @param value
             *     allowed object is
             *     {@link SelectionBackgroundType }
             *     
             */
            public void setBackgroundSelection(SelectionBackgroundType value) {
                this.backgroundSelection = value;
            }

            public boolean isSetBackgroundSelection() {
                return (this.backgroundSelection!= null);
            }

        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded">
     *         <element name="resize">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="boxesResize" type="{http://schema.webpdf.de/1.0/operation}BoxesResizeType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *         <element name="remove">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="boxesRemove" type="{http://schema.webpdf.de/1.0/operation}SelectionBoxType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "resize",
        "remove"
    })
    public static class Boxes {

        protected List<OptionsType.Boxes.Resize> resize;
        protected List<OptionsType.Boxes.Remove> remove;

        /**
         * Gets the value of the resize property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the resize property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getResize().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link OptionsType.Boxes.Resize }
         * 
         * 
         * @return
         *     The value of the resize property.
         */
        public List<OptionsType.Boxes.Resize> getResize() {
            if (resize == null) {
                resize = new ArrayList<>();
            }
            return this.resize;
        }

        /**
         * Gets the value of the remove property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the remove property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getRemove().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link OptionsType.Boxes.Remove }
         * 
         * 
         * @return
         *     The value of the remove property.
         */
        public List<OptionsType.Boxes.Remove> getRemove() {
            if (remove == null) {
                remove = new ArrayList<>();
            }
            return this.remove;
        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="boxesRemove" type="{http://schema.webpdf.de/1.0/operation}SelectionBoxType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "boxesRemove"
        })
        public static class Remove {

            protected SelectionBoxType boxesRemove;

            /**
             * Gets the value of the boxesRemove property.
             * 
             * @return
             *     possible object is
             *     {@link SelectionBoxType }
             *     
             */
            public SelectionBoxType getBoxesRemove() {
                return boxesRemove;
            }

            /**
             * Sets the value of the boxesRemove property.
             * 
             * @param value
             *     allowed object is
             *     {@link SelectionBoxType }
             *     
             */
            public void setBoxesRemove(SelectionBoxType value) {
                this.boxesRemove = value;
            }

            public boolean isSetBoxesRemove() {
                return (this.boxesRemove!= null);
            }

        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="boxesResize" type="{http://schema.webpdf.de/1.0/operation}BoxesResizeType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "boxesResize"
        })
        public static class Resize {

            protected BoxesResizeType boxesResize;

            /**
             * Gets the value of the boxesResize property.
             * 
             * @return
             *     possible object is
             *     {@link BoxesResizeType }
             *     
             */
            public BoxesResizeType getBoxesResize() {
                return boxesResize;
            }

            /**
             * Sets the value of the boxesResize property.
             * 
             * @param value
             *     allowed object is
             *     {@link BoxesResizeType }
             *     
             */
            public void setBoxesResize(BoxesResizeType value) {
                this.boxesResize = value;
            }

            public boolean isSetBoxesResize() {
                return (this.boxesResize!= null);
            }

        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice>
     *         <element name="add">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="headerFooterContent" type="{http://schema.webpdf.de/1.0/operation}HeaderFooterType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *         <element name="remove">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="headerFooterSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionHeaderFooterType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "add",
        "remove"
    })
    public static class HeaderFooter {

        protected OptionsType.HeaderFooter.Add add;
        protected OptionsType.HeaderFooter.Remove remove;

        /**
         * Gets the value of the add property.
         * 
         * @return
         *     possible object is
         *     {@link OptionsType.HeaderFooter.Add }
         *     
         */
        public OptionsType.HeaderFooter.Add getAdd() {
            return add;
        }

        /**
         * Sets the value of the add property.
         * 
         * @param value
         *     allowed object is
         *     {@link OptionsType.HeaderFooter.Add }
         *     
         */
        public void setAdd(OptionsType.HeaderFooter.Add value) {
            this.add = value;
        }

        public boolean isSetAdd() {
            return (this.add!= null);
        }

        /**
         * Gets the value of the remove property.
         * 
         * @return
         *     possible object is
         *     {@link OptionsType.HeaderFooter.Remove }
         *     
         */
        public OptionsType.HeaderFooter.Remove getRemove() {
            return remove;
        }

        /**
         * Sets the value of the remove property.
         * 
         * @param value
         *     allowed object is
         *     {@link OptionsType.HeaderFooter.Remove }
         *     
         */
        public void setRemove(OptionsType.HeaderFooter.Remove value) {
            this.remove = value;
        }

        public boolean isSetRemove() {
            return (this.remove!= null);
        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="headerFooterContent" type="{http://schema.webpdf.de/1.0/operation}HeaderFooterType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "headerFooterContent"
        })
        public static class Add {

            protected HeaderFooterType headerFooterContent;

            /**
             * Gets the value of the headerFooterContent property.
             * 
             * @return
             *     possible object is
             *     {@link HeaderFooterType }
             *     
             */
            public HeaderFooterType getHeaderFooterContent() {
                return headerFooterContent;
            }

            /**
             * Sets the value of the headerFooterContent property.
             * 
             * @param value
             *     allowed object is
             *     {@link HeaderFooterType }
             *     
             */
            public void setHeaderFooterContent(HeaderFooterType value) {
                this.headerFooterContent = value;
            }

            public boolean isSetHeaderFooterContent() {
                return (this.headerFooterContent!= null);
            }

        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="headerFooterSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionHeaderFooterType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "headerFooterSelection"
        })
        public static class Remove {

            protected SelectionHeaderFooterType headerFooterSelection;

            /**
             * Gets the value of the headerFooterSelection property.
             * 
             * @return
             *     possible object is
             *     {@link SelectionHeaderFooterType }
             *     
             */
            public SelectionHeaderFooterType getHeaderFooterSelection() {
                return headerFooterSelection;
            }

            /**
             * Sets the value of the headerFooterSelection property.
             * 
             * @param value
             *     allowed object is
             *     {@link SelectionHeaderFooterType }
             *     
             */
            public void setHeaderFooterSelection(SelectionHeaderFooterType value) {
                this.headerFooterSelection = value;
            }

            public boolean isSetHeaderFooterSelection() {
                return (this.headerFooterSelection!= null);
            }

        }

    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded">
     *         <element name="add">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="pageTransition" type="{http://schema.webpdf.de/1.0/operation}TransitionType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *         <element name="remove">
     *           <complexType>
     *             <complexContent>
     *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 <choice>
     *                   <element name="transitionSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionTransitionType"/>
     *                 </choice>
     *               </restriction>
     *             </complexContent>
     *           </complexType>
     *         </element>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "add",
        "remove"
    })
    public static class PageTransitions {

        protected List<OptionsType.PageTransitions.Add> add;
        protected List<OptionsType.PageTransitions.Remove> remove;

        /**
         * Gets the value of the add property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the add property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getAdd().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link OptionsType.PageTransitions.Add }
         * 
         * 
         * @return
         *     The value of the add property.
         */
        public List<OptionsType.PageTransitions.Add> getAdd() {
            if (add == null) {
                add = new ArrayList<>();
            }
            return this.add;
        }

        /**
         * Gets the value of the remove property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the remove property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getRemove().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link OptionsType.PageTransitions.Remove }
         * 
         * 
         * @return
         *     The value of the remove property.
         */
        public List<OptionsType.PageTransitions.Remove> getRemove() {
            if (remove == null) {
                remove = new ArrayList<>();
            }
            return this.remove;
        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="pageTransition" type="{http://schema.webpdf.de/1.0/operation}TransitionType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "pageTransition"
        })
        public static class Add {

            protected TransitionType pageTransition;

            /**
             * Gets the value of the pageTransition property.
             * 
             * @return
             *     possible object is
             *     {@link TransitionType }
             *     
             */
            public TransitionType getPageTransition() {
                return pageTransition;
            }

            /**
             * Sets the value of the pageTransition property.
             * 
             * @param value
             *     allowed object is
             *     {@link TransitionType }
             *     
             */
            public void setPageTransition(TransitionType value) {
                this.pageTransition = value;
            }

            public boolean isSetPageTransition() {
                return (this.pageTransition!= null);
            }

        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>{@code
         * <complexType>
         *   <complexContent>
         *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       <choice>
         *         <element name="transitionSelection" type="{http://schema.webpdf.de/1.0/operation}SelectionTransitionType"/>
         *       </choice>
         *     </restriction>
         *   </complexContent>
         * </complexType>
         * }</pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "transitionSelection"
        })
        public static class Remove {

            protected SelectionTransitionType transitionSelection;

            /**
             * Gets the value of the transitionSelection property.
             * 
             * @return
             *     possible object is
             *     {@link SelectionTransitionType }
             *     
             */
            public SelectionTransitionType getTransitionSelection() {
                return transitionSelection;
            }

            /**
             * Sets the value of the transitionSelection property.
             * 
             * @param value
             *     allowed object is
             *     {@link SelectionTransitionType }
             *     
             */
            public void setTransitionSelection(SelectionTransitionType value) {
                this.transitionSelection = value;
            }

            public boolean isSetTransitionSelection() {
                return (this.transitionSelection!= null);
            }

        }

    }

}
