
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The fitRectangle element is used to specify a location within the document. It will jump to a page in the document and set a zoom factor that will ensure, as far as possible, that a rectangle produced by the offsets from the page margins is displayed.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for FitRectangleDestinationType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="FitRectangleDestinationType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}DestinationEventType">
 *       <attribute name="page" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="leftOffset" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="bottomOffset" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="rightOffset" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="topOffset" default="0">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="metrics" type="{http://schema.webpdf.de/1.0/operation}MetricsType" default="px" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FitRectangleDestinationType")
public class FitRectangleDestinationType
    extends DestinationEventType
{

    @XmlAttribute(name = "page")
    protected Integer page;
    @XmlAttribute(name = "leftOffset")
    protected Integer leftOffset;
    @XmlAttribute(name = "bottomOffset")
    protected Integer bottomOffset;
    @XmlAttribute(name = "rightOffset")
    protected Integer rightOffset;
    @XmlAttribute(name = "topOffset")
    protected Integer topOffset;
    @XmlAttribute(name = "metrics")
    protected MetricsType metrics;

    /**
     * Gets the value of the page property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getPage() {
        if (page == null) {
            return  1;
        } else {
            return page;
        }
    }

    /**
     * Sets the value of the page property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setPage(int value) {
        this.page = value;
    }

    public boolean isSetPage() {
        return (this.page!= null);
    }

    public void unsetPage() {
        this.page = null;
    }

    /**
     * Gets the value of the leftOffset property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getLeftOffset() {
        if (leftOffset == null) {
            return  0;
        } else {
            return leftOffset;
        }
    }

    /**
     * Sets the value of the leftOffset property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setLeftOffset(int value) {
        this.leftOffset = value;
    }

    public boolean isSetLeftOffset() {
        return (this.leftOffset!= null);
    }

    public void unsetLeftOffset() {
        this.leftOffset = null;
    }

    /**
     * Gets the value of the bottomOffset property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getBottomOffset() {
        if (bottomOffset == null) {
            return  0;
        } else {
            return bottomOffset;
        }
    }

    /**
     * Sets the value of the bottomOffset property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setBottomOffset(int value) {
        this.bottomOffset = value;
    }

    public boolean isSetBottomOffset() {
        return (this.bottomOffset!= null);
    }

    public void unsetBottomOffset() {
        this.bottomOffset = null;
    }

    /**
     * Gets the value of the rightOffset property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getRightOffset() {
        if (rightOffset == null) {
            return  0;
        } else {
            return rightOffset;
        }
    }

    /**
     * Sets the value of the rightOffset property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setRightOffset(int value) {
        this.rightOffset = value;
    }

    public boolean isSetRightOffset() {
        return (this.rightOffset!= null);
    }

    public void unsetRightOffset() {
        this.rightOffset = null;
    }

    /**
     * Gets the value of the topOffset property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getTopOffset() {
        if (topOffset == null) {
            return  0;
        } else {
            return topOffset;
        }
    }

    /**
     * Sets the value of the topOffset property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setTopOffset(int value) {
        this.topOffset = value;
    }

    public boolean isSetTopOffset() {
        return (this.topOffset!= null);
    }

    public void unsetTopOffset() {
        this.topOffset = null;
    }

    /**
     * Gets the value of the metrics property.
     * 
     * @return
     *     possible object is
     *     {@link MetricsType }
     *     
     */
    public MetricsType getMetrics() {
        if (metrics == null) {
            return MetricsType.PX;
        } else {
            return metrics;
        }
    }

    /**
     * Sets the value of the metrics property.
     * 
     * @param value
     *     allowed object is
     *     {@link MetricsType }
     *     
     */
    public void setMetrics(MetricsType value) {
        this.metrics = value;
    }

    public boolean isSetMetrics() {
        return (this.metrics!= null);
    }

}
