
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for FileDataFormatType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="FileDataFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="pdf"/>
 *     <enumeration value="zip"/>
 *     <enumeration value="id"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "FileDataFormatType")
@XmlEnum
public enum FileDataFormatType {

    @XmlEnumValue("pdf")
    PDF("pdf"),
    @XmlEnumValue("zip")
    ZIP("zip"),
    @XmlEnumValue("id")
    ID("id");
    private final String value;

    FileDataFormatType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static FileDataFormatType fromValue(String v) {
        for (FileDataFormatType c: FileDataFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
