
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for ExtractionFileFormatType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="ExtractionFileFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="text"/>
 *     <enumeration value="xml"/>
 *     <enumeration value="json"/>
 *     <enumeration value="zip"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "ExtractionFileFormatType")
@XmlEnum
public enum ExtractionFileFormatType {

    @XmlEnumValue("text")
    TEXT("text"),
    @XmlEnumValue("xml")
    XML("xml"),
    @XmlEnumValue("json")
    JSON("json"),
    @XmlEnumValue("zip")
    ZIP("zip");
    private final String value;

    ExtractionFileFormatType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static ExtractionFileFormatType fromValue(String v) {
        for (ExtractionFileFormatType c: ExtractionFileFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
