
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for DuplexType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="DuplexType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="simplex"/>
 *     <enumeration value="duplexFlipShortEdge"/>
 *     <enumeration value="duplexFlipLongEdge"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "DuplexType")
@XmlEnum
public enum DuplexType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("simplex")
    SIMPLEX("simplex"),
    @XmlEnumValue("duplexFlipShortEdge")
    DUPLEX_FLIP_SHORT_EDGE("duplexFlipShortEdge"),
    @XmlEnumValue("duplexFlipLongEdge")
    DUPLEX_FLIP_LONG_EDGE("duplexFlipLongEdge");
    private final String value;

    DuplexType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static DuplexType fromValue(String v) {
        for (DuplexType c: DuplexType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
