
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for BarcodeDetectInputFormatType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="BarcodeDetectInputFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="pdf"/>
 *     <enumeration value="img"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "BarcodeDetectInputFormatType")
@XmlEnum
public enum BarcodeDetectInputFormatType {

    @XmlEnumValue("pdf")
    PDF("pdf"),
    @XmlEnumValue("img")
    IMG("img");
    private final String value;

    BarcodeDetectInputFormatType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static BarcodeDetectInputFormatType fromValue(String v) {
        for (BarcodeDetectInputFormatType c: BarcodeDetectInputFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
