
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for AttachmentModeType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="AttachmentModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="embed"/>
 *     <enumeration value="remove"/>
 *     <enumeration value="convert"/>
 *     <enumeration value="convertMerge"/>
 *     <enumeration value="convertEmbed"/>
 *     <enumeration value="convertMergeEmbed"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "AttachmentModeType")
@XmlEnum
public enum AttachmentModeType {

    @XmlEnumValue("embed")
    EMBED("embed"),
    @XmlEnumValue("remove")
    REMOVE("remove"),
    @XmlEnumValue("convert")
    CONVERT("convert"),
    @XmlEnumValue("convertMerge")
    CONVERT_MERGE("convertMerge"),
    @XmlEnumValue("convertEmbed")
    CONVERT_EMBED("convertEmbed"),
    @XmlEnumValue("convertMergeEmbed")
    CONVERT_MERGE_EMBED("convertMergeEmbed");
    private final String value;

    AttachmentModeType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static AttachmentModeType fromValue(String v) {
        for (AttachmentModeType c: AttachmentModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
