
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for ApplicationOperationType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="ApplicationOperationType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="open"/>
 *     <enumeration value="print"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "ApplicationOperationType")
@XmlEnum
public enum ApplicationOperationType {

    @XmlEnumValue("open")
    OPEN("open"),
    @XmlEnumValue("print")
    PRINT("print");
    private final String value;

    ApplicationOperationType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static ApplicationOperationType fromValue(String v) {
        for (ApplicationOperationType c: ApplicationOperationType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
