
package net.webpdf.wsclient.schema.extraction.info;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for InitialViewType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="InitialViewType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="none"/>
 *     <enumeration value="outlines"/>
 *     <enumeration value="thumbnails"/>
 *     <enumeration value="fullscreen"/>
 *     <enumeration value="layers"/>
 *     <enumeration value="attachments"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "InitialViewType")
@XmlEnum
public enum InitialViewType {

    @XmlEnumValue("none")
    NONE("none"),
    @XmlEnumValue("outlines")
    OUTLINES("outlines"),
    @XmlEnumValue("thumbnails")
    THUMBNAILS("thumbnails"),
    @XmlEnumValue("fullscreen")
    FULLSCREEN("fullscreen"),
    @XmlEnumValue("layers")
    LAYERS("layers"),
    @XmlEnumValue("attachments")
    ATTACHMENTS("attachments");
    private final String value;

    InitialViewType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static InitialViewType fromValue(String v) {
        for (InitialViewType c: InitialViewType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
