/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines the result of the execution of a web service operation. The result contains in &#x60;code&#x60; the value zero if the execution was successful or a negative number as error code if an error occurred.  In case of an error code, &#x60;description&#x60; contains a description of the error and &#x60;stackTrace&#x60; contains the Java stack trace if an exception occurred.
 */
@Schema(description = "Defines the result of the execution of a web service operation. The result contains in `code` the value zero if the execution was successful or a negative number as error code if an error occurred.  In case of an error code, `description` contains a description of the error and `stackTrace` contains the Java stack trace if an exception occurred.")
@JsonPropertyOrder({
  WebserviceResult.JSON_PROPERTY_CODE,
  WebserviceResult.JSON_PROPERTY_DESCRIPTION,
  WebserviceResult.JSON_PROPERTY_EXIT_CODE,
  WebserviceResult.JSON_PROPERTY_STACK_TRACE
})
@JsonTypeName("Webservice_Result")

public class WebserviceResult {
  public static final String JSON_PROPERTY_CODE = "code";
  private Integer code = 0;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description = "";

  public static final String JSON_PROPERTY_EXIT_CODE = "exitCode";
  private Integer exitCode = 0;

  public static final String JSON_PROPERTY_STACK_TRACE = "stackTrace";
  private WebserviceResultStackTrace stackTrace;

  public WebserviceResult() {
  }

  public WebserviceResult code(Integer code) {
    
    this.code = code;
    return this;
  }

  /**
   * The error code of the operation. For a successful operation, this value must be zero. If you get any other negative value, the execution has failed.
   * @return code
   **/
  @Nullable
  @Schema(name = "The error code of the operation. For a successful operation, this value must be zero. If you get any other negative value, the execution has failed.")
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(Integer code) {
    this.code = code;
  }


  public WebserviceResult description(String description) {
    
    this.description = description;
    return this;
  }

  /**
   * A description of the operation´s result.
   * @return description
   **/
  @Nullable
  @Schema(name = "A description of the operation´s result.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public WebserviceResult exitCode(Integer exitCode) {
    
    this.exitCode = exitCode;
    return this;
  }

  /**
   * The exit code of an external application, if such an application was used for the operation.
   * @return exitCode
   **/
  @Nullable
  @Schema(name = "The exit code of an external application, if such an application was used for the operation.")
  @JsonProperty(JSON_PROPERTY_EXIT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getExitCode() {
    return exitCode;
  }


  @JsonProperty(JSON_PROPERTY_EXIT_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExitCode(Integer exitCode) {
    this.exitCode = exitCode;
  }


  public WebserviceResult stackTrace(WebserviceResultStackTrace stackTrace) {
    
    this.stackTrace = stackTrace;
    return this;
  }

  /**
   * Get stackTrace
   * @return stackTrace
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_STACK_TRACE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WebserviceResultStackTrace getStackTrace() {
    return stackTrace;
  }


  @JsonProperty(JSON_PROPERTY_STACK_TRACE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStackTrace(WebserviceResultStackTrace stackTrace) {
    this.stackTrace = stackTrace;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WebserviceResult webserviceResult = (WebserviceResult) o;
    return Objects.equals(this.code, webserviceResult.code) &&
        Objects.equals(this.description, webserviceResult.description) &&
        Objects.equals(this.exitCode, webserviceResult.exitCode) &&
        Objects.equals(this.stackTrace, webserviceResult.stackTrace);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, description, exitCode, stackTrace);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WebserviceResult {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    exitCode: ").append(toIndentedString(exitCode)).append("\n");
    sb.append("    stackTrace: ").append(toIndentedString(stackTrace)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
