/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Defines the restrictions and limits that apply when using the REST API and user sessions on the server.
 */
@Schema(description = "Defines the restrictions and limits that apply when using the REST API and user sessions on the server.")
@JsonPropertyOrder({
  ServerConfigSessionLimits.JSON_PROPERTY_DISK_SPACE_LIMIT,
  ServerConfigSessionLimits.JSON_PROPERTY_DISK_SPACE_LIMIT_USER,
  ServerConfigSessionLimits.JSON_PROPERTY_MAX_FILES,
  ServerConfigSessionLimits.JSON_PROPERTY_MAX_FILES_USER,
  ServerConfigSessionLimits.JSON_PROPERTY_UPLOAD_LIMIT,
  ServerConfigSessionLimits.JSON_PROPERTY_UPLOAD_LIMIT_USER
})
@JsonTypeName("ServerConfig_SessionLimits")

public class ServerConfigSessionLimits {
  public static final String JSON_PROPERTY_DISK_SPACE_LIMIT = "diskSpaceLimit";
  private Integer diskSpaceLimit = 0;

  public static final String JSON_PROPERTY_DISK_SPACE_LIMIT_USER = "diskSpaceLimitUser";
  private Integer diskSpaceLimitUser = 0;

  public static final String JSON_PROPERTY_MAX_FILES = "maxFiles";
  private Integer maxFiles = 0;

  public static final String JSON_PROPERTY_MAX_FILES_USER = "maxFilesUser";
  private Integer maxFilesUser = 0;

  public static final String JSON_PROPERTY_UPLOAD_LIMIT = "uploadLimit";
  private Integer uploadLimit = 0;

  public static final String JSON_PROPERTY_UPLOAD_LIMIT_USER = "uploadLimitUser";
  private Integer uploadLimitUser = 0;

  public ServerConfigSessionLimits() {
  }

  public ServerConfigSessionLimits diskSpaceLimit(Integer diskSpaceLimit) {
    
    this.diskSpaceLimit = diskSpaceLimit;
    return this;
  }

  /**
   * Sets the overall global disk space (in bytes) the server may use (set to 0 to disable this limitation).
   * minimum: 0
   * @return diskSpaceLimit
   **/
  @Nullable
  @Schema(name = "Sets the overall global disk space (in bytes) the server may use (set to 0 to disable this limitation).")
  @JsonProperty(JSON_PROPERTY_DISK_SPACE_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDiskSpaceLimit() {
    return diskSpaceLimit;
  }


  @JsonProperty(JSON_PROPERTY_DISK_SPACE_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiskSpaceLimit(Integer diskSpaceLimit) {
    this.diskSpaceLimit = diskSpaceLimit;
  }


  public ServerConfigSessionLimits diskSpaceLimitUser(Integer diskSpaceLimitUser) {
    
    this.diskSpaceLimitUser = diskSpaceLimitUser;
    return this;
  }

  /**
   * Sets the maximum disk space (in bytes) a single user may use (set to 0 to disable this limitation).
   * minimum: 0
   * @return diskSpaceLimitUser
   **/
  @Nullable
  @Schema(name = "Sets the maximum disk space (in bytes) a single user may use (set to 0 to disable this limitation).")
  @JsonProperty(JSON_PROPERTY_DISK_SPACE_LIMIT_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDiskSpaceLimitUser() {
    return diskSpaceLimitUser;
  }


  @JsonProperty(JSON_PROPERTY_DISK_SPACE_LIMIT_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiskSpaceLimitUser(Integer diskSpaceLimitUser) {
    this.diskSpaceLimitUser = diskSpaceLimitUser;
  }


  public ServerConfigSessionLimits maxFiles(Integer maxFiles) {
    
    this.maxFiles = maxFiles;
    return this;
  }

  /**
   * Sets the maximum number of files that may be uploaded to the server (set to 0 to disable this limitation).
   * minimum: 0
   * @return maxFiles
   **/
  @Nullable
  @Schema(name = "Sets the maximum number of files that may be uploaded to the server (set to 0 to disable this limitation).")
  @JsonProperty(JSON_PROPERTY_MAX_FILES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxFiles() {
    return maxFiles;
  }


  @JsonProperty(JSON_PROPERTY_MAX_FILES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxFiles(Integer maxFiles) {
    this.maxFiles = maxFiles;
  }


  public ServerConfigSessionLimits maxFilesUser(Integer maxFilesUser) {
    
    this.maxFilesUser = maxFilesUser;
    return this;
  }

  /**
   * Sets the maximum number of files a single user may upload to the server (set to 0 to disable this limitation).
   * minimum: 0
   * @return maxFilesUser
   **/
  @Nullable
  @Schema(name = "Sets the maximum number of files a single user may upload to the server (set to 0 to disable this limitation).")
  @JsonProperty(JSON_PROPERTY_MAX_FILES_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxFilesUser() {
    return maxFilesUser;
  }


  @JsonProperty(JSON_PROPERTY_MAX_FILES_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxFilesUser(Integer maxFilesUser) {
    this.maxFilesUser = maxFilesUser;
  }


  public ServerConfigSessionLimits uploadLimit(Integer uploadLimit) {
    
    this.uploadLimit = uploadLimit;
    return this;
  }

  /**
   * Sets the maximum size (in bytes) a file uploaded to the server may have (set to 0 to disable this limitation).
   * minimum: 0
   * @return uploadLimit
   **/
  @Nullable
  @Schema(name = "Sets the maximum size (in bytes) a file uploaded to the server may have (set to 0 to disable this limitation).")
  @JsonProperty(JSON_PROPERTY_UPLOAD_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getUploadLimit() {
    return uploadLimit;
  }


  @JsonProperty(JSON_PROPERTY_UPLOAD_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUploadLimit(Integer uploadLimit) {
    this.uploadLimit = uploadLimit;
  }


  public ServerConfigSessionLimits uploadLimitUser(Integer uploadLimitUser) {
    
    this.uploadLimitUser = uploadLimitUser;
    return this;
  }

  /**
   * Sets the maximum size (in bytes) a file uploaded by a single user may have (set to 0 to disable this limitation).
   * minimum: 0
   * @return uploadLimitUser
   **/
  @Nullable
  @Schema(name = "Sets the maximum size (in bytes) a file uploaded by a single user may have (set to 0 to disable this limitation).")
  @JsonProperty(JSON_PROPERTY_UPLOAD_LIMIT_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getUploadLimitUser() {
    return uploadLimitUser;
  }


  @JsonProperty(JSON_PROPERTY_UPLOAD_LIMIT_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUploadLimitUser(Integer uploadLimitUser) {
    this.uploadLimitUser = uploadLimitUser;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServerConfigSessionLimits serverConfigSessionLimits = (ServerConfigSessionLimits) o;
    return Objects.equals(this.diskSpaceLimit, serverConfigSessionLimits.diskSpaceLimit) &&
        Objects.equals(this.diskSpaceLimitUser, serverConfigSessionLimits.diskSpaceLimitUser) &&
        Objects.equals(this.maxFiles, serverConfigSessionLimits.maxFiles) &&
        Objects.equals(this.maxFilesUser, serverConfigSessionLimits.maxFilesUser) &&
        Objects.equals(this.uploadLimit, serverConfigSessionLimits.uploadLimit) &&
        Objects.equals(this.uploadLimitUser, serverConfigSessionLimits.uploadLimitUser);
  }

  @Override
  public int hashCode() {
    return Objects.hash(diskSpaceLimit, diskSpaceLimitUser, maxFiles, maxFilesUser, uploadLimit, uploadLimitUser);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServerConfigSessionLimits {\n");
    sb.append("    diskSpaceLimit: ").append(toIndentedString(diskSpaceLimit)).append("\n");
    sb.append("    diskSpaceLimitUser: ").append(toIndentedString(diskSpaceLimitUser)).append("\n");
    sb.append("    maxFiles: ").append(toIndentedString(maxFiles)).append("\n");
    sb.append("    maxFilesUser: ").append(toIndentedString(maxFilesUser)).append("\n");
    sb.append("    uploadLimit: ").append(toIndentedString(uploadLimit)).append("\n");
    sb.append("    uploadLimitUser: ").append(toIndentedString(uploadLimitUser)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
