/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The description operation element can be used to change the description for documents.
 */
@Schema(description = "The description operation element can be used to change the description for documents.")
@JsonPropertyOrder({
  OperationToolboxDescriptionDescription.JSON_PROPERTY_ALLOW_EMPTY_VALUES,
  OperationToolboxDescriptionDescription.JSON_PROPERTY_AUTHOR,
  OperationToolboxDescriptionDescription.JSON_PROPERTY_CREATOR,
  OperationToolboxDescriptionDescription.JSON_PROPERTY_CUSTOM,
  OperationToolboxDescriptionDescription.JSON_PROPERTY_KEYWORDS,
  OperationToolboxDescriptionDescription.JSON_PROPERTY_PRODUCER,
  OperationToolboxDescriptionDescription.JSON_PROPERTY_SUBJECT,
  OperationToolboxDescriptionDescription.JSON_PROPERTY_TITLE
})
@JsonTypeName("Operation_ToolboxDescription_description")

public class OperationToolboxDescriptionDescription {
  public static final String JSON_PROPERTY_ALLOW_EMPTY_VALUES = "allowEmptyValues";
  private Boolean allowEmptyValues = false;

  public static final String JSON_PROPERTY_AUTHOR = "author";
  private String author = "";

  public static final String JSON_PROPERTY_CREATOR = "creator";
  private String creator = "";

  public static final String JSON_PROPERTY_CUSTOM = "custom";
  private List<OperationDescriptionCustom> custom = null;

  public static final String JSON_PROPERTY_KEYWORDS = "keywords";
  private String keywords = "";

  public static final String JSON_PROPERTY_PRODUCER = "producer";
  private String producer = "";

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  private String subject = "";

  public static final String JSON_PROPERTY_TITLE = "title";
  private String title = "";

  public OperationToolboxDescriptionDescription() {
  }

  public OperationToolboxDescriptionDescription allowEmptyValues(Boolean allowEmptyValues) {
    
    this.allowEmptyValues = allowEmptyValues;
    return this;
  }

  /**
   * If \&quot;true,\&quot; empty values will be accepted.
   * @return allowEmptyValues
   **/
  @Nullable
  @Schema(name = "If \"true,\" empty values will be accepted.")
  @JsonProperty(JSON_PROPERTY_ALLOW_EMPTY_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowEmptyValues() {
    return allowEmptyValues;
  }


  @JsonProperty(JSON_PROPERTY_ALLOW_EMPTY_VALUES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAllowEmptyValues(Boolean allowEmptyValues) {
    this.allowEmptyValues = allowEmptyValues;
  }


  public OperationToolboxDescriptionDescription author(String author) {
    
    this.author = author;
    return this;
  }

  /**
   * Used to set the PDF document&#39;s Author field. Multiple values should be separated with \&quot;;\&quot;.
   * @return author
   **/
  @Nullable
  @Schema(name = "Used to set the PDF document's Author field. Multiple values should be separated with \";\".")
  @JsonProperty(JSON_PROPERTY_AUTHOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAuthor() {
    return author;
  }


  @JsonProperty(JSON_PROPERTY_AUTHOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAuthor(String author) {
    this.author = author;
  }


  public OperationToolboxDescriptionDescription creator(String creator) {
    
    this.creator = creator;
    return this;
  }

  /**
   * Used to set the PDF document&#39;s Creator field.
   * @return creator
   **/
  @Nullable
  @Schema(name = "Used to set the PDF document's Creator field.")
  @JsonProperty(JSON_PROPERTY_CREATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreator() {
    return creator;
  }


  @JsonProperty(JSON_PROPERTY_CREATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreator(String creator) {
    this.creator = creator;
  }


  public OperationToolboxDescriptionDescription custom(List<OperationDescriptionCustom> custom) {
    
    this.custom = custom;
    return this;
  }

  public OperationToolboxDescriptionDescription addCustomItem(OperationDescriptionCustom customItem) {
    if (this.custom == null) {
      this.custom = new ArrayList<>();
    }
    this.custom.add(customItem);
    return this;
  }

  /**
   * Get custom
   * @return custom
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_CUSTOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OperationDescriptionCustom> getCustom() {
    return custom;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCustom(List<OperationDescriptionCustom> custom) {
    this.custom = custom;
  }


  public OperationToolboxDescriptionDescription keywords(String keywords) {
    
    this.keywords = keywords;
    return this;
  }

  /**
   * Used to set the PDF document&#39;s Keywords field. Multiple values should be separated with \&quot;;\&quot;.
   * @return keywords
   **/
  @Nullable
  @Schema(name = "Used to set the PDF document's Keywords field. Multiple values should be separated with \";\".")
  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getKeywords() {
    return keywords;
  }


  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKeywords(String keywords) {
    this.keywords = keywords;
  }


  public OperationToolboxDescriptionDescription producer(String producer) {
    
    this.producer = producer;
    return this;
  }

  /**
   * Used to set the PDF document&#39;s Producer field.
   * @return producer
   **/
  @Nullable
  @Schema(name = "Used to set the PDF document's Producer field.")
  @JsonProperty(JSON_PROPERTY_PRODUCER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProducer() {
    return producer;
  }


  @JsonProperty(JSON_PROPERTY_PRODUCER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProducer(String producer) {
    this.producer = producer;
  }


  public OperationToolboxDescriptionDescription subject(String subject) {
    
    this.subject = subject;
    return this;
  }

  /**
   * Used to set the PDF document&#39;s Subject field.
   * @return subject
   **/
  @Nullable
  @Schema(name = "Used to set the PDF document's Subject field.")
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(String subject) {
    this.subject = subject;
  }


  public OperationToolboxDescriptionDescription title(String title) {
    
    this.title = title;
    return this;
  }

  /**
   * Used to set the PDF document&#39;s Title field.
   * @return title
   **/
  @Nullable
  @Schema(name = "Used to set the PDF document's Title field.")
  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(String title) {
    this.title = title;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationToolboxDescriptionDescription operationToolboxDescriptionDescription = (OperationToolboxDescriptionDescription) o;
    return Objects.equals(this.allowEmptyValues, operationToolboxDescriptionDescription.allowEmptyValues) &&
        Objects.equals(this.author, operationToolboxDescriptionDescription.author) &&
        Objects.equals(this.creator, operationToolboxDescriptionDescription.creator) &&
        Objects.equals(this.custom, operationToolboxDescriptionDescription.custom) &&
        Objects.equals(this.keywords, operationToolboxDescriptionDescription.keywords) &&
        Objects.equals(this.producer, operationToolboxDescriptionDescription.producer) &&
        Objects.equals(this.subject, operationToolboxDescriptionDescription.subject) &&
        Objects.equals(this.title, operationToolboxDescriptionDescription.title);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowEmptyValues, author, creator, custom, keywords, producer, subject, title);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationToolboxDescriptionDescription {\n");
    sb.append("    allowEmptyValues: ").append(toIndentedString(allowEmptyValues)).append("\n");
    sb.append("    author: ").append(toIndentedString(author)).append("\n");
    sb.append("    creator: ").append(toIndentedString(creator)).append("\n");
    sb.append("    custom: ").append(toIndentedString(custom)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    producer: ").append(toIndentedString(producer)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
