/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Simplifies document structures, deletes metadata, and flattens page contents in order to remove confidential information that could be hidden in the document structure. Subelements can be used to exempt specific content from this operation or to configure how it will be handled in greater detail. If a subelement is not passed, the represented function will be considered to be enabled and configured with the corresponding default values.
 */
@Schema(description = "Simplifies document structures, deletes metadata, and flattens page contents in order to remove confidential information that could be hidden in the document structure. Subelements can be used to exempt specific content from this operation or to configure how it will be handled in greater detail. If a subelement is not passed, the represented function will be considered to be enabled and configured with the corresponding default values.")
@JsonPropertyOrder({
  OperationSanitize.JSON_PROPERTY_ACTIONS,
  OperationSanitize.JSON_PROPERTY_ANNOTATIONS,
  OperationSanitize.JSON_PROPERTY_ATTACHMENTS,
  OperationSanitize.JSON_PROPERTY_FORMS,
  OperationSanitize.JSON_PROPERTY_LAYERS,
  OperationSanitize.JSON_PROPERTY_METADATA,
  OperationSanitize.JSON_PROPERTY_OUTLINES,
  OperationSanitize.JSON_PROPERTY_PAGES,
  OperationSanitize.JSON_PROPERTY_TAGS
})
@JsonTypeName("Operation_Sanitize")

public class OperationSanitize {
  public static final String JSON_PROPERTY_ACTIONS = "actions";
  private OperationSanitizeActions actions;

  public static final String JSON_PROPERTY_ANNOTATIONS = "annotations";
  private OperationSanitizeAnnotations annotations;

  public static final String JSON_PROPERTY_ATTACHMENTS = "attachments";
  private OperationSanitizeAttachments attachments;

  public static final String JSON_PROPERTY_FORMS = "forms";
  private OperationSanitizeForms forms;

  public static final String JSON_PROPERTY_LAYERS = "layers";
  private OperationSanitizeLayers layers;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private OperationSanitizeMetadata metadata;

  public static final String JSON_PROPERTY_OUTLINES = "outlines";
  private OperationSanitizeOutlines outlines;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private OperationSanitizePages pages;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private OperationSanitizeTags tags;

  public OperationSanitize() {
  }

  public OperationSanitize actions(OperationSanitizeActions actions) {
    
    this.actions = actions;
    return this;
  }

  /**
   * Get actions
   * @return actions
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationSanitizeActions getActions() {
    return actions;
  }


  @JsonProperty(JSON_PROPERTY_ACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActions(OperationSanitizeActions actions) {
    this.actions = actions;
  }


  public OperationSanitize annotations(OperationSanitizeAnnotations annotations) {
    
    this.annotations = annotations;
    return this;
  }

  /**
   * Get annotations
   * @return annotations
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ANNOTATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationSanitizeAnnotations getAnnotations() {
    return annotations;
  }


  @JsonProperty(JSON_PROPERTY_ANNOTATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnotations(OperationSanitizeAnnotations annotations) {
    this.annotations = annotations;
  }


  public OperationSanitize attachments(OperationSanitizeAttachments attachments) {
    
    this.attachments = attachments;
    return this;
  }

  /**
   * Get attachments
   * @return attachments
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationSanitizeAttachments getAttachments() {
    return attachments;
  }


  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachments(OperationSanitizeAttachments attachments) {
    this.attachments = attachments;
  }


  public OperationSanitize forms(OperationSanitizeForms forms) {
    
    this.forms = forms;
    return this;
  }

  /**
   * Get forms
   * @return forms
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_FORMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationSanitizeForms getForms() {
    return forms;
  }


  @JsonProperty(JSON_PROPERTY_FORMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setForms(OperationSanitizeForms forms) {
    this.forms = forms;
  }


  public OperationSanitize layers(OperationSanitizeLayers layers) {
    
    this.layers = layers;
    return this;
  }

  /**
   * Get layers
   * @return layers
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_LAYERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationSanitizeLayers getLayers() {
    return layers;
  }


  @JsonProperty(JSON_PROPERTY_LAYERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLayers(OperationSanitizeLayers layers) {
    this.layers = layers;
  }


  public OperationSanitize metadata(OperationSanitizeMetadata metadata) {
    
    this.metadata = metadata;
    return this;
  }

  /**
   * Get metadata
   * @return metadata
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationSanitizeMetadata getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(OperationSanitizeMetadata metadata) {
    this.metadata = metadata;
  }


  public OperationSanitize outlines(OperationSanitizeOutlines outlines) {
    
    this.outlines = outlines;
    return this;
  }

  /**
   * Get outlines
   * @return outlines
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_OUTLINES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationSanitizeOutlines getOutlines() {
    return outlines;
  }


  @JsonProperty(JSON_PROPERTY_OUTLINES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOutlines(OperationSanitizeOutlines outlines) {
    this.outlines = outlines;
  }


  public OperationSanitize pages(OperationSanitizePages pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * Get pages
   * @return pages
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationSanitizePages getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(OperationSanitizePages pages) {
    this.pages = pages;
  }


  public OperationSanitize tags(OperationSanitizeTags tags) {
    
    this.tags = tags;
    return this;
  }

  /**
   * Get tags
   * @return tags
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationSanitizeTags getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(OperationSanitizeTags tags) {
    this.tags = tags;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationSanitize operationSanitize = (OperationSanitize) o;
    return Objects.equals(this.actions, operationSanitize.actions) &&
        Objects.equals(this.annotations, operationSanitize.annotations) &&
        Objects.equals(this.attachments, operationSanitize.attachments) &&
        Objects.equals(this.forms, operationSanitize.forms) &&
        Objects.equals(this.layers, operationSanitize.layers) &&
        Objects.equals(this.metadata, operationSanitize.metadata) &&
        Objects.equals(this.outlines, operationSanitize.outlines) &&
        Objects.equals(this.pages, operationSanitize.pages) &&
        Objects.equals(this.tags, operationSanitize.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(actions, annotations, attachments, forms, layers, metadata, outlines, pages, tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationSanitize {\n");
    sb.append("    actions: ").append(toIndentedString(actions)).append("\n");
    sb.append("    annotations: ").append(toIndentedString(annotations)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("    forms: ").append(toIndentedString(forms)).append("\n");
    sb.append("    layers: ").append(toIndentedString(layers)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    outlines: ").append(toIndentedString(outlines)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
