/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * A QR barcode.
 */
@Schema(description = "A QR barcode.")
@JsonPropertyOrder({
  OperationQrBarcode.JSON_PROPERTY_CHARSET,
  OperationQrBarcode.JSON_PROPERTY_ERROR_CORRECTION,
  OperationQrBarcode.JSON_PROPERTY_MARGIN,
  OperationQrBarcode.JSON_PROPERTY_PAGES,
  OperationQrBarcode.JSON_PROPERTY_POSITION,
  OperationQrBarcode.JSON_PROPERTY_ROTATION,
  OperationQrBarcode.JSON_PROPERTY_VALUE
})
@JsonTypeName("Operation_QrBarcode")

public class OperationQrBarcode {
  public static final String JSON_PROPERTY_CHARSET = "charset";
  private String charset = "utf-8";

  /**
   * Used to adjust the error correction level for generated QR codes. The higher the level, the more error-resistant the barcode, ensuring that damaged codes will still be readable.  *   l &#x3D; Low *   m &#x3D; Medium *   q &#x3D; Quartile *   h &#x3D; High
   */
  public enum ErrorCorrectionEnum {
    L("l"),
    
    M("m"),
    
    Q("q"),
    
    H("h");

    private String value;

    ErrorCorrectionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ErrorCorrectionEnum fromValue(String value) {
      for (ErrorCorrectionEnum b : ErrorCorrectionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ERROR_CORRECTION = "errorCorrection";
  private ErrorCorrectionEnum errorCorrection = ErrorCorrectionEnum.L;

  public static final String JSON_PROPERTY_MARGIN = "margin";
  private Integer margin = 0;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private String pages = "";

  public static final String JSON_PROPERTY_POSITION = "position";
  private OperationRectangle position;

  public static final String JSON_PROPERTY_ROTATION = "rotation";
  private Integer rotation = 0;

  public static final String JSON_PROPERTY_VALUE = "value";
  private String value = "";

  public OperationQrBarcode() {
  }

  public OperationQrBarcode charset(String charset) {
    
    this.charset = charset;
    return this;
  }

  /**
   * Used to specify the character set in which the barcode contents should be stored.
   * @return charset
   **/
  @Nullable
  @Schema(name = "Used to specify the character set in which the barcode contents should be stored.")
  @JsonProperty(JSON_PROPERTY_CHARSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCharset() {
    return charset;
  }


  @JsonProperty(JSON_PROPERTY_CHARSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCharset(String charset) {
    this.charset = charset;
  }


  public OperationQrBarcode errorCorrection(ErrorCorrectionEnum errorCorrection) {
    
    this.errorCorrection = errorCorrection;
    return this;
  }

  /**
   * Used to adjust the error correction level for generated QR codes. The higher the level, the more error-resistant the barcode, ensuring that damaged codes will still be readable.  *   l &#x3D; Low *   m &#x3D; Medium *   q &#x3D; Quartile *   h &#x3D; High
   * @return errorCorrection
   **/
  @Nullable
  @Schema(name = "Used to adjust the error correction level for generated QR codes. The higher the level, the more error-resistant the barcode, ensuring that damaged codes will still be readable.  *   l = Low *   m = Medium *   q = Quartile *   h = High")
  @JsonProperty(JSON_PROPERTY_ERROR_CORRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ErrorCorrectionEnum getErrorCorrection() {
    return errorCorrection;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_CORRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorCorrection(ErrorCorrectionEnum errorCorrection) {
    this.errorCorrection = errorCorrection;
  }


  public OperationQrBarcode margin(Integer margin) {
    
    this.margin = margin;
    return this;
  }

  /**
   * Used to specify the width of the empty frame that should be generated around the barcode. This shall use the same metrics as the position - if no position is present, the default (mm) shall be assumed.
   * minimum: 0
   * @return margin
   **/
  @Nullable
  @Schema(name = "Used to specify the width of the empty frame that should be generated around the barcode. This shall use the same metrics as the position - if no position is present, the default (mm) shall be assumed.")
  @JsonProperty(JSON_PROPERTY_MARGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMargin() {
    return margin;
  }


  @JsonProperty(JSON_PROPERTY_MARGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMargin(Integer margin) {
    this.margin = margin;
  }


  public OperationQrBarcode pages(String pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * The page range for generating barcodes. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: \&quot;1-10\&quot; or \&quot;1,2,5-10\&quot;)
   * @return pages
   **/
  @Nullable
  @Schema(name = "The page range for generating barcodes. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: \"1-10\" or \"1,2,5-10\")")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(String pages) {
    this.pages = pages;
  }


  public OperationQrBarcode position(OperationRectangle position) {
    
    this.position = position;
    return this;
  }

  /**
   * Get position
   * @return position
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationRectangle getPosition() {
    return position;
  }


  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPosition(OperationRectangle position) {
    this.position = position;
  }


  public OperationQrBarcode rotation(Integer rotation) {
    
    this.rotation = rotation;
    return this;
  }

  /**
   * Used to specify the barcode&#39;s rotation in 90-degree increments. When there is a value that falls under a full 90-degree increment, the next higher increment will be automatically selected.
   * minimum: 0
   * @return rotation
   **/
  @Nullable
  @Schema(name = "Used to specify the barcode's rotation in 90-degree increments. When there is a value that falls under a full 90-degree increment, the next higher increment will be automatically selected.")
  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRotation() {
    return rotation;
  }


  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRotation(Integer rotation) {
    this.rotation = rotation;
  }


  public OperationQrBarcode value(String value) {
    
    this.value = value;
    return this;
  }

  /**
   * Contains the value that should be encoded in the barcode. Depending on the selected barcode format, there may be specific criteria for the data structure. For a description, please refer to the chapter \&quot;Barcodes\&quot;
   * @return value
   **/
  @NotNull
  @Schema(required = true, name = "Contains the value that should be encoded in the barcode. Depending on the selected barcode format, there may be specific criteria for the data structure. For a description, please refer to the chapter \"Barcodes\"")
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setValue(String value) {
    this.value = value;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationQrBarcode operationQrBarcode = (OperationQrBarcode) o;
    return Objects.equals(this.charset, operationQrBarcode.charset) &&
        Objects.equals(this.errorCorrection, operationQrBarcode.errorCorrection) &&
        Objects.equals(this.margin, operationQrBarcode.margin) &&
        Objects.equals(this.pages, operationQrBarcode.pages) &&
        Objects.equals(this.position, operationQrBarcode.position) &&
        Objects.equals(this.rotation, operationQrBarcode.rotation) &&
        Objects.equals(this.value, operationQrBarcode.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(charset, errorCorrection, margin, pages, position, rotation, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationQrBarcode {\n");
    sb.append("    charset: ").append(toIndentedString(charset)).append("\n");
    sb.append("    errorCorrection: ").append(toIndentedString(errorCorrection)).append("\n");
    sb.append("    margin: ").append(toIndentedString(margin)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    rotation: ").append(toIndentedString(rotation)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
