/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * A PDF417 barcode.
 */
@Schema(description = "A PDF417 barcode.")
@JsonPropertyOrder({
  OperationPdf417Barcode.JSON_PROPERTY_CHARSET,
  OperationPdf417Barcode.JSON_PROPERTY_COMPACT,
  OperationPdf417Barcode.JSON_PROPERTY_COMPACTION_MODE,
  OperationPdf417Barcode.JSON_PROPERTY_DATA_CODEWORDS_MAX,
  OperationPdf417Barcode.JSON_PROPERTY_DATA_CODEWORDS_MIN,
  OperationPdf417Barcode.JSON_PROPERTY_ERROR_CORRECTION,
  OperationPdf417Barcode.JSON_PROPERTY_MARGIN,
  OperationPdf417Barcode.JSON_PROPERTY_PAGES,
  OperationPdf417Barcode.JSON_PROPERTY_POSITION,
  OperationPdf417Barcode.JSON_PROPERTY_ROTATION,
  OperationPdf417Barcode.JSON_PROPERTY_SHAPE,
  OperationPdf417Barcode.JSON_PROPERTY_SYMBOLS_PER_CODEWORD_MAX,
  OperationPdf417Barcode.JSON_PROPERTY_SYMBOLS_PER_CODEWORD_MIN,
  OperationPdf417Barcode.JSON_PROPERTY_VALUE
})
@JsonTypeName("Operation_Pdf417Barcode")

public class OperationPdf417Barcode {
  public static final String JSON_PROPERTY_CHARSET = "charset";
  private String charset = "utf-8";

  public static final String JSON_PROPERTY_COMPACT = "compact";
  private Boolean compact = false;

  /**
   * If PDF417 barcode compression has been enabled with the \&quot;compact\&quot; attribute, the encoding selected here for the compression of generated PDF417 barcodes will be used.  *   auto &#x3D; Try to determine the best encoding method automatically. *   byte &#x3D; Select a byte encoding method in which every 5 codewords represent 6 bytes. *   numeric &#x3D; Select a numeric encoding method in which a group of 15 codewords represents up to 44 decimal numbers. *   text &#x3D; Select a text encoding method in which each codeword represents up to 2 letters.
   */
  public enum CompactionModeEnum {
    TEXT("text"),
    
    NUMERIC("numeric"),
    
    BYTE("byte"),
    
    AUTO("auto");

    private String value;

    CompactionModeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CompactionModeEnum fromValue(String value) {
      for (CompactionModeEnum b : CompactionModeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_COMPACTION_MODE = "compactionMode";
  private CompactionModeEnum compactionMode = CompactionModeEnum.AUTO;

  public static final String JSON_PROPERTY_DATA_CODEWORDS_MAX = "dataCodewordsMax";
  private Integer dataCodewordsMax = 0;

  public static final String JSON_PROPERTY_DATA_CODEWORDS_MIN = "dataCodewordsMin";
  private Integer dataCodewordsMin = 0;

  public static final String JSON_PROPERTY_ERROR_CORRECTION = "errorCorrection";
  private Integer errorCorrection = 2;

  public static final String JSON_PROPERTY_MARGIN = "margin";
  private Integer margin = 0;

  public static final String JSON_PROPERTY_PAGES = "pages";
  private String pages = "";

  public static final String JSON_PROPERTY_POSITION = "position";
  private OperationRectangle position;

  public static final String JSON_PROPERTY_ROTATION = "rotation";
  private Integer rotation = 0;

  /**
   * Can be used to force a specific shape for generated Data Matrix codes.  *   default &#x3D; Select an appropriate shape. *   rectangle &#x3D; Force a rectangular shape. *   square &#x3D; Force a square shape.
   */
  public enum ShapeEnum {
    DEFAULT("default"),
    
    RECTANGLE("rectangle"),
    
    SQUARE("square");

    private String value;

    ShapeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ShapeEnum fromValue(String value) {
      for (ShapeEnum b : ShapeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SHAPE = "shape";
  private ShapeEnum shape = ShapeEnum.DEFAULT;

  public static final String JSON_PROPERTY_SYMBOLS_PER_CODEWORD_MAX = "symbolsPerCodewordMax";
  private Integer symbolsPerCodewordMax = 0;

  public static final String JSON_PROPERTY_SYMBOLS_PER_CODEWORD_MIN = "symbolsPerCodewordMin";
  private Integer symbolsPerCodewordMin = 0;

  public static final String JSON_PROPERTY_VALUE = "value";
  private String value = "";

  public OperationPdf417Barcode() {
  }

  public OperationPdf417Barcode charset(String charset) {
    
    this.charset = charset;
    return this;
  }

  /**
   * Used to specify the character set in which the barcode contents should be stored.
   * @return charset
   **/
  @Nullable
  @Schema(name = "Used to specify the character set in which the barcode contents should be stored.")
  @JsonProperty(JSON_PROPERTY_CHARSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCharset() {
    return charset;
  }


  @JsonProperty(JSON_PROPERTY_CHARSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCharset(String charset) {
    this.charset = charset;
  }


  public OperationPdf417Barcode compact(Boolean compact) {
    
    this.compact = compact;
    return this;
  }

  /**
   * If this value is set to \&quot;true,\&quot; the contents of all generated PDF417 barcodes will be compressed using the encoding selected with the \&quot;compactionMode\&quot; attribute.
   * @return compact
   **/
  @Nullable
  @Schema(name = "If this value is set to \"true,\" the contents of all generated PDF417 barcodes will be compressed using the encoding selected with the \"compactionMode\" attribute.")
  @JsonProperty(JSON_PROPERTY_COMPACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCompact() {
    return compact;
  }


  @JsonProperty(JSON_PROPERTY_COMPACT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompact(Boolean compact) {
    this.compact = compact;
  }


  public OperationPdf417Barcode compactionMode(CompactionModeEnum compactionMode) {
    
    this.compactionMode = compactionMode;
    return this;
  }

  /**
   * If PDF417 barcode compression has been enabled with the \&quot;compact\&quot; attribute, the encoding selected here for the compression of generated PDF417 barcodes will be used.  *   auto &#x3D; Try to determine the best encoding method automatically. *   byte &#x3D; Select a byte encoding method in which every 5 codewords represent 6 bytes. *   numeric &#x3D; Select a numeric encoding method in which a group of 15 codewords represents up to 44 decimal numbers. *   text &#x3D; Select a text encoding method in which each codeword represents up to 2 letters.
   * @return compactionMode
   **/
  @Nullable
  @Schema(name = "If PDF417 barcode compression has been enabled with the \"compact\" attribute, the encoding selected here for the compression of generated PDF417 barcodes will be used.  *   auto = Try to determine the best encoding method automatically. *   byte = Select a byte encoding method in which every 5 codewords represent 6 bytes. *   numeric = Select a numeric encoding method in which a group of 15 codewords represents up to 44 decimal numbers. *   text = Select a text encoding method in which each codeword represents up to 2 letters.")
  @JsonProperty(JSON_PROPERTY_COMPACTION_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CompactionModeEnum getCompactionMode() {
    return compactionMode;
  }


  @JsonProperty(JSON_PROPERTY_COMPACTION_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompactionMode(CompactionModeEnum compactionMode) {
    this.compactionMode = compactionMode;
  }


  public OperationPdf417Barcode dataCodewordsMax(Integer dataCodewordsMax) {
    
    this.dataCodewordsMax = dataCodewordsMax;
    return this;
  }

  /**
   * Used to specify the maximum number of codewords allowed in a single PDF417 barcode row.
   * minimum: 1
   * @return dataCodewordsMax
   **/
  @Nullable
  @Schema(name = "Used to specify the maximum number of codewords allowed in a single PDF417 barcode row.")
  @JsonProperty(JSON_PROPERTY_DATA_CODEWORDS_MAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDataCodewordsMax() {
    return dataCodewordsMax;
  }


  @JsonProperty(JSON_PROPERTY_DATA_CODEWORDS_MAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataCodewordsMax(Integer dataCodewordsMax) {
    this.dataCodewordsMax = dataCodewordsMax;
  }


  public OperationPdf417Barcode dataCodewordsMin(Integer dataCodewordsMin) {
    
    this.dataCodewordsMin = dataCodewordsMin;
    return this;
  }

  /**
   * Used to specify the minimum number of codewords allowed in a single PDF417 barcode row.
   * minimum: 1
   * @return dataCodewordsMin
   **/
  @Nullable
  @Schema(name = "Used to specify the minimum number of codewords allowed in a single PDF417 barcode row.")
  @JsonProperty(JSON_PROPERTY_DATA_CODEWORDS_MIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDataCodewordsMin() {
    return dataCodewordsMin;
  }


  @JsonProperty(JSON_PROPERTY_DATA_CODEWORDS_MIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDataCodewordsMin(Integer dataCodewordsMin) {
    this.dataCodewordsMin = dataCodewordsMin;
  }


  public OperationPdf417Barcode errorCorrection(Integer errorCorrection) {
    
    this.errorCorrection = errorCorrection;
    return this;
  }

  /**
   * Used to adjust the error correction level for generated PDF417 codes. The higher the level, the more error-resistant the barcode, ensuring that damaged codes will still be readable. A level of 1 to 8 can be specified.
   * minimum: 1
   * maximum: 8
   * @return errorCorrection
   **/
  @Nullable
  @Schema(name = "Used to adjust the error correction level for generated PDF417 codes. The higher the level, the more error-resistant the barcode, ensuring that damaged codes will still be readable. A level of 1 to 8 can be specified.")
  @JsonProperty(JSON_PROPERTY_ERROR_CORRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getErrorCorrection() {
    return errorCorrection;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_CORRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorCorrection(Integer errorCorrection) {
    this.errorCorrection = errorCorrection;
  }


  public OperationPdf417Barcode margin(Integer margin) {
    
    this.margin = margin;
    return this;
  }

  /**
   * Used to specify the width of the empty frame that should be generated around the barcode. This shall use the same metrics as the position - if no position is present, the default (mm) shall be assumed.
   * minimum: 0
   * @return margin
   **/
  @Nullable
  @Schema(name = "Used to specify the width of the empty frame that should be generated around the barcode. This shall use the same metrics as the position - if no position is present, the default (mm) shall be assumed.")
  @JsonProperty(JSON_PROPERTY_MARGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMargin() {
    return margin;
  }


  @JsonProperty(JSON_PROPERTY_MARGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMargin(Integer margin) {
    this.margin = margin;
  }


  public OperationPdf417Barcode pages(String pages) {
    
    this.pages = pages;
    return this;
  }

  /**
   * The page range for generating barcodes. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: \&quot;1-10\&quot; or \&quot;1,2,5-10\&quot;)
   * @return pages
   **/
  @Nullable
  @Schema(name = "The page range for generating barcodes. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: \"1-10\" or \"1,2,5-10\")")
  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPages() {
    return pages;
  }


  @JsonProperty(JSON_PROPERTY_PAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPages(String pages) {
    this.pages = pages;
  }


  public OperationPdf417Barcode position(OperationRectangle position) {
    
    this.position = position;
    return this;
  }

  /**
   * Get position
   * @return position
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OperationRectangle getPosition() {
    return position;
  }


  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPosition(OperationRectangle position) {
    this.position = position;
  }


  public OperationPdf417Barcode rotation(Integer rotation) {
    
    this.rotation = rotation;
    return this;
  }

  /**
   * Used to specify the barcode&#39;s rotation in 90-degree increments. When there is a value that falls under a full 90-degree increment, the next higher increment will be automatically selected.
   * minimum: 0
   * @return rotation
   **/
  @Nullable
  @Schema(name = "Used to specify the barcode's rotation in 90-degree increments. When there is a value that falls under a full 90-degree increment, the next higher increment will be automatically selected.")
  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRotation() {
    return rotation;
  }


  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRotation(Integer rotation) {
    this.rotation = rotation;
  }


  public OperationPdf417Barcode shape(ShapeEnum shape) {
    
    this.shape = shape;
    return this;
  }

  /**
   * Can be used to force a specific shape for generated Data Matrix codes.  *   default &#x3D; Select an appropriate shape. *   rectangle &#x3D; Force a rectangular shape. *   square &#x3D; Force a square shape.
   * @return shape
   **/
  @Nullable
  @Schema(name = "Can be used to force a specific shape for generated Data Matrix codes.  *   default = Select an appropriate shape. *   rectangle = Force a rectangular shape. *   square = Force a square shape.")
  @JsonProperty(JSON_PROPERTY_SHAPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ShapeEnum getShape() {
    return shape;
  }


  @JsonProperty(JSON_PROPERTY_SHAPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShape(ShapeEnum shape) {
    this.shape = shape;
  }


  public OperationPdf417Barcode symbolsPerCodewordMax(Integer symbolsPerCodewordMax) {
    
    this.symbolsPerCodewordMax = symbolsPerCodewordMax;
    return this;
  }

  /**
   * Used to specify the maximum number of code symbols that are allowed to be in a single codeword in the PDF417 barcode.
   * minimum: 1
   * @return symbolsPerCodewordMax
   **/
  @Nullable
  @Schema(name = "Used to specify the maximum number of code symbols that are allowed to be in a single codeword in the PDF417 barcode.")
  @JsonProperty(JSON_PROPERTY_SYMBOLS_PER_CODEWORD_MAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSymbolsPerCodewordMax() {
    return symbolsPerCodewordMax;
  }


  @JsonProperty(JSON_PROPERTY_SYMBOLS_PER_CODEWORD_MAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSymbolsPerCodewordMax(Integer symbolsPerCodewordMax) {
    this.symbolsPerCodewordMax = symbolsPerCodewordMax;
  }


  public OperationPdf417Barcode symbolsPerCodewordMin(Integer symbolsPerCodewordMin) {
    
    this.symbolsPerCodewordMin = symbolsPerCodewordMin;
    return this;
  }

  /**
   * Used to specify the minimum number of code symbols that are allowed to be in a single codeword in the PDF417 barcode.
   * minimum: 1
   * @return symbolsPerCodewordMin
   **/
  @Nullable
  @Schema(name = "Used to specify the minimum number of code symbols that are allowed to be in a single codeword in the PDF417 barcode.")
  @JsonProperty(JSON_PROPERTY_SYMBOLS_PER_CODEWORD_MIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSymbolsPerCodewordMin() {
    return symbolsPerCodewordMin;
  }


  @JsonProperty(JSON_PROPERTY_SYMBOLS_PER_CODEWORD_MIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSymbolsPerCodewordMin(Integer symbolsPerCodewordMin) {
    this.symbolsPerCodewordMin = symbolsPerCodewordMin;
  }


  public OperationPdf417Barcode value(String value) {
    
    this.value = value;
    return this;
  }

  /**
   * Contains the value that should be encoded in the barcode. Depending on the selected barcode format, there may be specific criteria for the data structure. For a description, please refer to the chapter \&quot;Barcodes\&quot;
   * @return value
   **/
  @NotNull
  @Schema(required = true, name = "Contains the value that should be encoded in the barcode. Depending on the selected barcode format, there may be specific criteria for the data structure. For a description, please refer to the chapter \"Barcodes\"")
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setValue(String value) {
    this.value = value;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationPdf417Barcode operationPdf417Barcode = (OperationPdf417Barcode) o;
    return Objects.equals(this.charset, operationPdf417Barcode.charset) &&
        Objects.equals(this.compact, operationPdf417Barcode.compact) &&
        Objects.equals(this.compactionMode, operationPdf417Barcode.compactionMode) &&
        Objects.equals(this.dataCodewordsMax, operationPdf417Barcode.dataCodewordsMax) &&
        Objects.equals(this.dataCodewordsMin, operationPdf417Barcode.dataCodewordsMin) &&
        Objects.equals(this.errorCorrection, operationPdf417Barcode.errorCorrection) &&
        Objects.equals(this.margin, operationPdf417Barcode.margin) &&
        Objects.equals(this.pages, operationPdf417Barcode.pages) &&
        Objects.equals(this.position, operationPdf417Barcode.position) &&
        Objects.equals(this.rotation, operationPdf417Barcode.rotation) &&
        Objects.equals(this.shape, operationPdf417Barcode.shape) &&
        Objects.equals(this.symbolsPerCodewordMax, operationPdf417Barcode.symbolsPerCodewordMax) &&
        Objects.equals(this.symbolsPerCodewordMin, operationPdf417Barcode.symbolsPerCodewordMin) &&
        Objects.equals(this.value, operationPdf417Barcode.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(charset, compact, compactionMode, dataCodewordsMax, dataCodewordsMin, errorCorrection, margin, pages, position, rotation, shape, symbolsPerCodewordMax, symbolsPerCodewordMin, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationPdf417Barcode {\n");
    sb.append("    charset: ").append(toIndentedString(charset)).append("\n");
    sb.append("    compact: ").append(toIndentedString(compact)).append("\n");
    sb.append("    compactionMode: ").append(toIndentedString(compactionMode)).append("\n");
    sb.append("    dataCodewordsMax: ").append(toIndentedString(dataCodewordsMax)).append("\n");
    sb.append("    dataCodewordsMin: ").append(toIndentedString(dataCodewordsMin)).append("\n");
    sb.append("    errorCorrection: ").append(toIndentedString(errorCorrection)).append("\n");
    sb.append("    margin: ").append(toIndentedString(margin)).append("\n");
    sb.append("    pages: ").append(toIndentedString(pages)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    rotation: ").append(toIndentedString(rotation)).append("\n");
    sb.append("    shape: ").append(toIndentedString(shape)).append("\n");
    sb.append("    symbolsPerCodewordMax: ").append(toIndentedString(symbolsPerCodewordMax)).append("\n");
    sb.append("    symbolsPerCodewordMin: ").append(toIndentedString(symbolsPerCodewordMin)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
