/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * The optimization element allows to correct the images of the pages to optimize them for OCR. Except for the \&quot;deskew\&quot; parameter, none of the optimizations are actually visible in the generated documents. The other optimizations are only used to improve the text recognition.
 */
@Schema(description = "The optimization element allows to correct the images of the pages to optimize them for OCR. Except for the \"deskew\" parameter, none of the optimizations are actually visible in the generated documents. The other optimizations are only used to improve the text recognition.")
@JsonPropertyOrder({
  OperationImageOptimization.JSON_PROPERTY_DESKEW,
  OperationImageOptimization.JSON_PROPERTY_DESPECKLE,
  OperationImageOptimization.JSON_PROPERTY_EDGE_ACCENTUATION,
  OperationImageOptimization.JSON_PROPERTY_EDGE_ACCENTUATION_VALUE,
  OperationImageOptimization.JSON_PROPERTY_GAMMA_CORRECTION,
  OperationImageOptimization.JSON_PROPERTY_GAMMA_CORRECTION_VALUE,
  OperationImageOptimization.JSON_PROPERTY_INCREASE_CONTRAST,
  OperationImageOptimization.JSON_PROPERTY_INCREASE_CONTRAST_VALUE,
  OperationImageOptimization.JSON_PROPERTY_MEDIAN_FILTER,
  OperationImageOptimization.JSON_PROPERTY_MEDIAN_FILTER_VALUE,
  OperationImageOptimization.JSON_PROPERTY_NOISE_REDUCTION,
  OperationImageOptimization.JSON_PROPERTY_NOISE_REDUCTION_VALUE,
  OperationImageOptimization.JSON_PROPERTY_REDUCE_DITHERING,
  OperationImageOptimization.JSON_PROPERTY_SHARPEN,
  OperationImageOptimization.JSON_PROPERTY_SHARPEN_VALUE
})
@JsonTypeName("Operation_ImageOptimization")

public class OperationImageOptimization {
  public static final String JSON_PROPERTY_DESKEW = "deskew";
  private Boolean deskew = true;

  public static final String JSON_PROPERTY_DESPECKLE = "despeckle";
  private Boolean despeckle = true;

  /**
   * If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off &#x3D; Do not apply this optimization *   value &#x3D; Select your own value *   low &#x3D; Apply optimization only with low intensity to avoid information loss. *   medium &#x3D; Perform optimization with medium intensity. *   high &#x3D; Perform optimization with strong intensity and accept possible information losses.
   */
  public enum EdgeAccentuationEnum {
    OFF("off"),
    
    VALUE("value"),
    
    LOW("low"),
    
    MEDIUM("medium"),
    
    HIGH("high");

    private String value;

    EdgeAccentuationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EdgeAccentuationEnum fromValue(String value) {
      for (EdgeAccentuationEnum b : EdgeAccentuationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EDGE_ACCENTUATION = "edgeAccentuation";
  private EdgeAccentuationEnum edgeAccentuation = EdgeAccentuationEnum.LOW;

  public static final String JSON_PROPERTY_EDGE_ACCENTUATION_VALUE = "edgeAccentuationValue";
  private Integer edgeAccentuationValue = 100;

  /**
   * If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off &#x3D; Do not apply this optimization *   value &#x3D; Select your own value *   low &#x3D; Apply optimization only with low intensity to avoid information loss. *   medium &#x3D; Perform optimization with medium intensity. *   high &#x3D; Perform optimization with strong intensity and accept possible information losses.
   */
  public enum GammaCorrectionEnum {
    OFF("off"),
    
    VALUE("value"),
    
    LOW("low"),
    
    MEDIUM("medium"),
    
    HIGH("high");

    private String value;

    GammaCorrectionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static GammaCorrectionEnum fromValue(String value) {
      for (GammaCorrectionEnum b : GammaCorrectionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_GAMMA_CORRECTION = "gammaCorrection";
  private GammaCorrectionEnum gammaCorrection = GammaCorrectionEnum.OFF;

  public static final String JSON_PROPERTY_GAMMA_CORRECTION_VALUE = "gammaCorrectionValue";
  private Float gammaCorrectionValue = 0.0f;

  /**
   * If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off &#x3D; Do not apply this optimization *   value &#x3D; Select your own value *   low &#x3D; Apply optimization only with low intensity to avoid information loss. *   medium &#x3D; Perform optimization with medium intensity. *   high &#x3D; Perform optimization with strong intensity and accept possible information losses.
   */
  public enum IncreaseContrastEnum {
    OFF("off"),
    
    VALUE("value"),
    
    LOW("low"),
    
    MEDIUM("medium"),
    
    HIGH("high");

    private String value;

    IncreaseContrastEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static IncreaseContrastEnum fromValue(String value) {
      for (IncreaseContrastEnum b : IncreaseContrastEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INCREASE_CONTRAST = "increaseContrast";
  private IncreaseContrastEnum increaseContrast = IncreaseContrastEnum.OFF;

  public static final String JSON_PROPERTY_INCREASE_CONTRAST_VALUE = "increaseContrastValue";
  private Integer increaseContrastValue = 0;

  /**
   * If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off &#x3D; Do not apply this optimization *   value &#x3D; Select your own value *   low &#x3D; Apply optimization only with low intensity to avoid information loss. *   medium &#x3D; Perform optimization with medium intensity. *   high &#x3D; Perform optimization with strong intensity and accept possible information losses.
   */
  public enum MedianFilterEnum {
    OFF("off"),
    
    VALUE("value"),
    
    LOW("low"),
    
    MEDIUM("medium"),
    
    HIGH("high");

    private String value;

    MedianFilterEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MedianFilterEnum fromValue(String value) {
      for (MedianFilterEnum b : MedianFilterEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MEDIAN_FILTER = "medianFilter";
  private MedianFilterEnum medianFilter = MedianFilterEnum.LOW;

  public static final String JSON_PROPERTY_MEDIAN_FILTER_VALUE = "medianFilterValue";
  private Integer medianFilterValue = 1;

  /**
   * If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off &#x3D; Do not apply this optimization *   value &#x3D; Select your own value *   low &#x3D; Apply optimization only with low intensity to avoid information loss. *   medium &#x3D; Perform optimization with medium intensity. *   high &#x3D; Perform optimization with strong intensity and accept possible information losses.
   */
  public enum NoiseReductionEnum {
    OFF("off"),
    
    VALUE("value"),
    
    LOW("low"),
    
    MEDIUM("medium"),
    
    HIGH("high");

    private String value;

    NoiseReductionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NoiseReductionEnum fromValue(String value) {
      for (NoiseReductionEnum b : NoiseReductionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NOISE_REDUCTION = "noiseReduction";
  private NoiseReductionEnum noiseReduction = NoiseReductionEnum.LOW;

  public static final String JSON_PROPERTY_NOISE_REDUCTION_VALUE = "noiseReductionValue";
  private Float noiseReductionValue = 1.0f;

  public static final String JSON_PROPERTY_REDUCE_DITHERING = "reduceDithering";
  private Boolean reduceDithering = false;

  /**
   * If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off &#x3D; Do not apply this optimization *   value &#x3D; Select your own value *   low &#x3D; Apply optimization only with low intensity to avoid information loss. *   medium &#x3D; Perform optimization with medium intensity. *   high &#x3D; Perform optimization with strong intensity and accept possible information losses.
   */
  public enum SharpenEnum {
    OFF("off"),
    
    VALUE("value"),
    
    LOW("low"),
    
    MEDIUM("medium"),
    
    HIGH("high");

    private String value;

    SharpenEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SharpenEnum fromValue(String value) {
      for (SharpenEnum b : SharpenEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SHARPEN = "sharpen";
  private SharpenEnum sharpen = SharpenEnum.LOW;

  public static final String JSON_PROPERTY_SHARPEN_VALUE = "sharpenValue";
  private Float sharpenValue = 1.0f;

  public OperationImageOptimization() {
  }

  public OperationImageOptimization deskew(Boolean deskew) {
    
    this.deskew = deskew;
    return this;
  }

  /**
   * Straight scans of pages can be created with a slight skew. If this value is set to true, an attempt is made to counter-rotate this skew and thus \&quot;deskew\&quot; the page. The results of this manipulation are visible in the resulting document.
   * @return deskew
   **/
  @Nullable
  @Schema(name = "Straight scans of pages can be created with a slight skew. If this value is set to true, an attempt is made to counter-rotate this skew and thus \"deskew\" the page. The results of this manipulation are visible in the resulting document.")
  @JsonProperty(JSON_PROPERTY_DESKEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeskew() {
    return deskew;
  }


  @JsonProperty(JSON_PROPERTY_DESKEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeskew(Boolean deskew) {
    this.deskew = deskew;
  }


  public OperationImageOptimization despeckle(Boolean despeckle) {
    
    this.despeckle = despeckle;
    return this;
  }

  /**
   * If this mode is set, impurities and stains are reduced. These are caused, for example, by dust or dirt on the pane of a scanner. It is recommended to activate this optimization.
   * @return despeckle
   **/
  @Nullable
  @Schema(name = "If this mode is set, impurities and stains are reduced. These are caused, for example, by dust or dirt on the pane of a scanner. It is recommended to activate this optimization.")
  @JsonProperty(JSON_PROPERTY_DESPECKLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDespeckle() {
    return despeckle;
  }


  @JsonProperty(JSON_PROPERTY_DESPECKLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDespeckle(Boolean despeckle) {
    this.despeckle = despeckle;
  }


  public OperationImageOptimization edgeAccentuation(EdgeAccentuationEnum edgeAccentuation) {
    
    this.edgeAccentuation = edgeAccentuation;
    return this;
  }

  /**
   * If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off &#x3D; Do not apply this optimization *   value &#x3D; Select your own value *   low &#x3D; Apply optimization only with low intensity to avoid information loss. *   medium &#x3D; Perform optimization with medium intensity. *   high &#x3D; Perform optimization with strong intensity and accept possible information losses.
   * @return edgeAccentuation
   **/
  @Nullable
  @Schema(name = "If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off = Do not apply this optimization *   value = Select your own value *   low = Apply optimization only with low intensity to avoid information loss. *   medium = Perform optimization with medium intensity. *   high = Perform optimization with strong intensity and accept possible information losses.")
  @JsonProperty(JSON_PROPERTY_EDGE_ACCENTUATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EdgeAccentuationEnum getEdgeAccentuation() {
    return edgeAccentuation;
  }


  @JsonProperty(JSON_PROPERTY_EDGE_ACCENTUATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEdgeAccentuation(EdgeAccentuationEnum edgeAccentuation) {
    this.edgeAccentuation = edgeAccentuation;
  }


  public OperationImageOptimization edgeAccentuationValue(Integer edgeAccentuationValue) {
    
    this.edgeAccentuationValue = edgeAccentuationValue;
    return this;
  }

  /**
   * Allows in combination with the edgeAccentuation mode \&quot;value\&quot; the free choice of a value for this optimization. An integer percentage value indicates the intensity of the edge accentuation. The actual image is overlaid with a corresponding sharpening filter for the edge accentuation - this percentage value specifies how intensively this effect should be emphasized compared to the original image. The predefined values range between 100 (low) and 200 percent (high).
   * minimum: 0
   * @return edgeAccentuationValue
   **/
  @Nullable
  @Schema(name = "Allows in combination with the edgeAccentuation mode \"value\" the free choice of a value for this optimization. An integer percentage value indicates the intensity of the edge accentuation. The actual image is overlaid with a corresponding sharpening filter for the edge accentuation - this percentage value specifies how intensively this effect should be emphasized compared to the original image. The predefined values range between 100 (low) and 200 percent (high).")
  @JsonProperty(JSON_PROPERTY_EDGE_ACCENTUATION_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getEdgeAccentuationValue() {
    return edgeAccentuationValue;
  }


  @JsonProperty(JSON_PROPERTY_EDGE_ACCENTUATION_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEdgeAccentuationValue(Integer edgeAccentuationValue) {
    this.edgeAccentuationValue = edgeAccentuationValue;
  }


  public OperationImageOptimization gammaCorrection(GammaCorrectionEnum gammaCorrection) {
    
    this.gammaCorrection = gammaCorrection;
    return this;
  }

  /**
   * If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off &#x3D; Do not apply this optimization *   value &#x3D; Select your own value *   low &#x3D; Apply optimization only with low intensity to avoid information loss. *   medium &#x3D; Perform optimization with medium intensity. *   high &#x3D; Perform optimization with strong intensity and accept possible information losses.
   * @return gammaCorrection
   **/
  @Nullable
  @Schema(name = "If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off = Do not apply this optimization *   value = Select your own value *   low = Apply optimization only with low intensity to avoid information loss. *   medium = Perform optimization with medium intensity. *   high = Perform optimization with strong intensity and accept possible information losses.")
  @JsonProperty(JSON_PROPERTY_GAMMA_CORRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GammaCorrectionEnum getGammaCorrection() {
    return gammaCorrection;
  }


  @JsonProperty(JSON_PROPERTY_GAMMA_CORRECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGammaCorrection(GammaCorrectionEnum gammaCorrection) {
    this.gammaCorrection = gammaCorrection;
  }


  public OperationImageOptimization gammaCorrectionValue(Float gammaCorrectionValue) {
    
    this.gammaCorrectionValue = gammaCorrectionValue;
    return this;
  }

  /**
   * Allows in combination with the gammaCorrection mode \&quot;value\&quot; the free choice of a value for this optimization. A comma value greater than 0 specifies the value to be applied to the image as gamma correction. The predefined values range between 1.5 (low) and 2.5 (high).
   * minimum: 0.0
   * @return gammaCorrectionValue
   **/
  @Nullable
  @Schema(name = "Allows in combination with the gammaCorrection mode \"value\" the free choice of a value for this optimization. A comma value greater than 0 specifies the value to be applied to the image as gamma correction. The predefined values range between 1.5 (low) and 2.5 (high).")
  @JsonProperty(JSON_PROPERTY_GAMMA_CORRECTION_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getGammaCorrectionValue() {
    return gammaCorrectionValue;
  }


  @JsonProperty(JSON_PROPERTY_GAMMA_CORRECTION_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGammaCorrectionValue(Float gammaCorrectionValue) {
    this.gammaCorrectionValue = gammaCorrectionValue;
  }


  public OperationImageOptimization increaseContrast(IncreaseContrastEnum increaseContrast) {
    
    this.increaseContrast = increaseContrast;
    return this;
  }

  /**
   * If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off &#x3D; Do not apply this optimization *   value &#x3D; Select your own value *   low &#x3D; Apply optimization only with low intensity to avoid information loss. *   medium &#x3D; Perform optimization with medium intensity. *   high &#x3D; Perform optimization with strong intensity and accept possible information losses.
   * @return increaseContrast
   **/
  @Nullable
  @Schema(name = "If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off = Do not apply this optimization *   value = Select your own value *   low = Apply optimization only with low intensity to avoid information loss. *   medium = Perform optimization with medium intensity. *   high = Perform optimization with strong intensity and accept possible information losses.")
  @JsonProperty(JSON_PROPERTY_INCREASE_CONTRAST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IncreaseContrastEnum getIncreaseContrast() {
    return increaseContrast;
  }


  @JsonProperty(JSON_PROPERTY_INCREASE_CONTRAST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncreaseContrast(IncreaseContrastEnum increaseContrast) {
    this.increaseContrast = increaseContrast;
  }


  public OperationImageOptimization increaseContrastValue(Integer increaseContrastValue) {
    
    this.increaseContrastValue = increaseContrastValue;
    return this;
  }

  /**
   * Allows in combination with the increaseContrast mode \&quot;value\&quot; the free choice of a value for this optimization. An integer value between -100 and +100 specifies the intensity of the contrast enhancement. The predefined values range between 25 (low) and 75 (high).
   * minimum: -100
   * maximum: 100
   * @return increaseContrastValue
   **/
  @Nullable
  @Schema(name = "Allows in combination with the increaseContrast mode \"value\" the free choice of a value for this optimization. An integer value between -100 and +100 specifies the intensity of the contrast enhancement. The predefined values range between 25 (low) and 75 (high).")
  @JsonProperty(JSON_PROPERTY_INCREASE_CONTRAST_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getIncreaseContrastValue() {
    return increaseContrastValue;
  }


  @JsonProperty(JSON_PROPERTY_INCREASE_CONTRAST_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncreaseContrastValue(Integer increaseContrastValue) {
    this.increaseContrastValue = increaseContrastValue;
  }


  public OperationImageOptimization medianFilter(MedianFilterEnum medianFilter) {
    
    this.medianFilter = medianFilter;
    return this;
  }

  /**
   * If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off &#x3D; Do not apply this optimization *   value &#x3D; Select your own value *   low &#x3D; Apply optimization only with low intensity to avoid information loss. *   medium &#x3D; Perform optimization with medium intensity. *   high &#x3D; Perform optimization with strong intensity and accept possible information losses.
   * @return medianFilter
   **/
  @Nullable
  @Schema(name = "If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off = Do not apply this optimization *   value = Select your own value *   low = Apply optimization only with low intensity to avoid information loss. *   medium = Perform optimization with medium intensity. *   high = Perform optimization with strong intensity and accept possible information losses.")
  @JsonProperty(JSON_PROPERTY_MEDIAN_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MedianFilterEnum getMedianFilter() {
    return medianFilter;
  }


  @JsonProperty(JSON_PROPERTY_MEDIAN_FILTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMedianFilter(MedianFilterEnum medianFilter) {
    this.medianFilter = medianFilter;
  }


  public OperationImageOptimization medianFilterValue(Integer medianFilterValue) {
    
    this.medianFilterValue = medianFilterValue;
    return this;
  }

  /**
   * Allows, in combination with the medianFilter mode \&quot;value\&quot;, the free choice of a value for this optimization. An integer value greater than 0 specifies the grid size with which the effect is to be applied to the image. The predefined values range between 1 (low) and 3 (high).
   * minimum: 0
   * @return medianFilterValue
   **/
  @Nullable
  @Schema(name = "Allows, in combination with the medianFilter mode \"value\", the free choice of a value for this optimization. An integer value greater than 0 specifies the grid size with which the effect is to be applied to the image. The predefined values range between 1 (low) and 3 (high).")
  @JsonProperty(JSON_PROPERTY_MEDIAN_FILTER_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMedianFilterValue() {
    return medianFilterValue;
  }


  @JsonProperty(JSON_PROPERTY_MEDIAN_FILTER_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMedianFilterValue(Integer medianFilterValue) {
    this.medianFilterValue = medianFilterValue;
  }


  public OperationImageOptimization noiseReduction(NoiseReductionEnum noiseReduction) {
    
    this.noiseReduction = noiseReduction;
    return this;
  }

  /**
   * If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off &#x3D; Do not apply this optimization *   value &#x3D; Select your own value *   low &#x3D; Apply optimization only with low intensity to avoid information loss. *   medium &#x3D; Perform optimization with medium intensity. *   high &#x3D; Perform optimization with strong intensity and accept possible information losses.
   * @return noiseReduction
   **/
  @Nullable
  @Schema(name = "If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off = Do not apply this optimization *   value = Select your own value *   low = Apply optimization only with low intensity to avoid information loss. *   medium = Perform optimization with medium intensity. *   high = Perform optimization with strong intensity and accept possible information losses.")
  @JsonProperty(JSON_PROPERTY_NOISE_REDUCTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NoiseReductionEnum getNoiseReduction() {
    return noiseReduction;
  }


  @JsonProperty(JSON_PROPERTY_NOISE_REDUCTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNoiseReduction(NoiseReductionEnum noiseReduction) {
    this.noiseReduction = noiseReduction;
  }


  public OperationImageOptimization noiseReductionValue(Float noiseReductionValue) {
    
    this.noiseReductionValue = noiseReductionValue;
    return this;
  }

  /**
   * Allows in combination with the noiseReduction mode \&quot;value\&quot; the free choice of a value for this optimization. A decimal value greater than 0 indicates the intensity with which the effect is to be applied to the image. The predefined values range between 1.0 (low) and 3.0 (high).
   * minimum: 0.0
   * @return noiseReductionValue
   **/
  @Nullable
  @Schema(name = "Allows in combination with the noiseReduction mode \"value\" the free choice of a value for this optimization. A decimal value greater than 0 indicates the intensity with which the effect is to be applied to the image. The predefined values range between 1.0 (low) and 3.0 (high).")
  @JsonProperty(JSON_PROPERTY_NOISE_REDUCTION_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getNoiseReductionValue() {
    return noiseReductionValue;
  }


  @JsonProperty(JSON_PROPERTY_NOISE_REDUCTION_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNoiseReductionValue(Float noiseReductionValue) {
    this.noiseReductionValue = noiseReductionValue;
  }


  public OperationImageOptimization reduceDithering(Boolean reduceDithering) {
    
    this.reduceDithering = reduceDithering;
    return this;
  }

  /**
   * In black and white images (including black and white scans), color values are often represented by a halftone according to their brightness (dithering / moiré effect). These halftones/hatchings translate a color value into a uniform sequence of black and white areas that visually appear to be a uniform area of the same color/brightness. Such patterns can be very difficult to delineate against actual text that may be in such a \&quot;colored\&quot; area. Setting this value to true will try to reduce such dithering patterns. This mode should only be set if absolutely necessary, as this process can be very lossy.
   * @return reduceDithering
   **/
  @Nullable
  @Schema(name = "In black and white images (including black and white scans), color values are often represented by a halftone according to their brightness (dithering / moiré effect). These halftones/hatchings translate a color value into a uniform sequence of black and white areas that visually appear to be a uniform area of the same color/brightness. Such patterns can be very difficult to delineate against actual text that may be in such a \"colored\" area. Setting this value to true will try to reduce such dithering patterns. This mode should only be set if absolutely necessary, as this process can be very lossy.")
  @JsonProperty(JSON_PROPERTY_REDUCE_DITHERING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReduceDithering() {
    return reduceDithering;
  }


  @JsonProperty(JSON_PROPERTY_REDUCE_DITHERING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReduceDithering(Boolean reduceDithering) {
    this.reduceDithering = reduceDithering;
  }


  public OperationImageOptimization sharpen(SharpenEnum sharpen) {
    
    this.sharpen = sharpen;
    return this;
  }

  /**
   * If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off &#x3D; Do not apply this optimization *   value &#x3D; Select your own value *   low &#x3D; Apply optimization only with low intensity to avoid information loss. *   medium &#x3D; Perform optimization with medium intensity. *   high &#x3D; Perform optimization with strong intensity and accept possible information losses.
   * @return sharpen
   **/
  @Nullable
  @Schema(name = "If this value is set, edge sharpening is applied to the image. This optimization usually leads to significantly better recognition results, but can also lead to information loss.  *   off = Do not apply this optimization *   value = Select your own value *   low = Apply optimization only with low intensity to avoid information loss. *   medium = Perform optimization with medium intensity. *   high = Perform optimization with strong intensity and accept possible information losses.")
  @JsonProperty(JSON_PROPERTY_SHARPEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SharpenEnum getSharpen() {
    return sharpen;
  }


  @JsonProperty(JSON_PROPERTY_SHARPEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSharpen(SharpenEnum sharpen) {
    this.sharpen = sharpen;
  }


  public OperationImageOptimization sharpenValue(Float sharpenValue) {
    
    this.sharpenValue = sharpenValue;
    return this;
  }

  /**
   * Allows in combination with the sharpen mode \&quot;value\&quot; the free choice of a value for this optimization. A comma value greater than 0 indicates the intensity with which the effect is to be applied to the image. The predefined values range between 1.0 (low) and 3.0 (high).
   * minimum: 0.0
   * @return sharpenValue
   **/
  @Nullable
  @Schema(name = "Allows in combination with the sharpen mode \"value\" the free choice of a value for this optimization. A comma value greater than 0 indicates the intensity with which the effect is to be applied to the image. The predefined values range between 1.0 (low) and 3.0 (high).")
  @JsonProperty(JSON_PROPERTY_SHARPEN_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getSharpenValue() {
    return sharpenValue;
  }


  @JsonProperty(JSON_PROPERTY_SHARPEN_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSharpenValue(Float sharpenValue) {
    this.sharpenValue = sharpenValue;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OperationImageOptimization operationImageOptimization = (OperationImageOptimization) o;
    return Objects.equals(this.deskew, operationImageOptimization.deskew) &&
        Objects.equals(this.despeckle, operationImageOptimization.despeckle) &&
        Objects.equals(this.edgeAccentuation, operationImageOptimization.edgeAccentuation) &&
        Objects.equals(this.edgeAccentuationValue, operationImageOptimization.edgeAccentuationValue) &&
        Objects.equals(this.gammaCorrection, operationImageOptimization.gammaCorrection) &&
        Objects.equals(this.gammaCorrectionValue, operationImageOptimization.gammaCorrectionValue) &&
        Objects.equals(this.increaseContrast, operationImageOptimization.increaseContrast) &&
        Objects.equals(this.increaseContrastValue, operationImageOptimization.increaseContrastValue) &&
        Objects.equals(this.medianFilter, operationImageOptimization.medianFilter) &&
        Objects.equals(this.medianFilterValue, operationImageOptimization.medianFilterValue) &&
        Objects.equals(this.noiseReduction, operationImageOptimization.noiseReduction) &&
        Objects.equals(this.noiseReductionValue, operationImageOptimization.noiseReductionValue) &&
        Objects.equals(this.reduceDithering, operationImageOptimization.reduceDithering) &&
        Objects.equals(this.sharpen, operationImageOptimization.sharpen) &&
        Objects.equals(this.sharpenValue, operationImageOptimization.sharpenValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deskew, despeckle, edgeAccentuation, edgeAccentuationValue, gammaCorrection, gammaCorrectionValue, increaseContrast, increaseContrastValue, medianFilter, medianFilterValue, noiseReduction, noiseReductionValue, reduceDithering, sharpen, sharpenValue);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OperationImageOptimization {\n");
    sb.append("    deskew: ").append(toIndentedString(deskew)).append("\n");
    sb.append("    despeckle: ").append(toIndentedString(despeckle)).append("\n");
    sb.append("    edgeAccentuation: ").append(toIndentedString(edgeAccentuation)).append("\n");
    sb.append("    edgeAccentuationValue: ").append(toIndentedString(edgeAccentuationValue)).append("\n");
    sb.append("    gammaCorrection: ").append(toIndentedString(gammaCorrection)).append("\n");
    sb.append("    gammaCorrectionValue: ").append(toIndentedString(gammaCorrectionValue)).append("\n");
    sb.append("    increaseContrast: ").append(toIndentedString(increaseContrast)).append("\n");
    sb.append("    increaseContrastValue: ").append(toIndentedString(increaseContrastValue)).append("\n");
    sb.append("    medianFilter: ").append(toIndentedString(medianFilter)).append("\n");
    sb.append("    medianFilterValue: ").append(toIndentedString(medianFilterValue)).append("\n");
    sb.append("    noiseReduction: ").append(toIndentedString(noiseReduction)).append("\n");
    sb.append("    noiseReductionValue: ").append(toIndentedString(noiseReductionValue)).append("\n");
    sb.append("    reduceDithering: ").append(toIndentedString(reduceDithering)).append("\n");
    sb.append("    sharpen: ").append(toIndentedString(sharpen)).append("\n");
    sb.append("    sharpenValue: ").append(toIndentedString(sharpenValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
