/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * MetadataPagePages
 */
@JsonPropertyOrder({
  MetadataPagePages.JSON_PROPERTY_BOXES,
  MetadataPagePages.JSON_PROPERTY_HEIGHT,
  MetadataPagePages.JSON_PROPERTY_LABEL,
  MetadataPagePages.JSON_PROPERTY_NUMBER,
  MetadataPagePages.JSON_PROPERTY_OBJECT_KEY,
  MetadataPagePages.JSON_PROPERTY_ROTATION,
  MetadataPagePages.JSON_PROPERTY_WIDTH
})
@JsonTypeName("Metadata_PagePages")

public class MetadataPagePages {
  public static final String JSON_PROPERTY_BOXES = "boxes";
  private MetadataBoxes boxes;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Float height = 0f;

  public static final String JSON_PROPERTY_LABEL = "label";
  private String label = "";

  public static final String JSON_PROPERTY_NUMBER = "number";
  private Integer number = 0;

  public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
  private String objectKey = "";

  public static final String JSON_PROPERTY_ROTATION = "rotation";
  private Integer rotation = 0;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Float width = 0f;

  public MetadataPagePages() {
  }

  public MetadataPagePages boxes(MetadataBoxes boxes) {
    
    this.boxes = boxes;
    return this;
  }

  /**
   * Get boxes
   * @return boxes
   **/
  @NotNull
  @Schema(required = true, name = "")
  @JsonProperty(JSON_PROPERTY_BOXES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MetadataBoxes getBoxes() {
    return boxes;
  }


  @JsonProperty(JSON_PROPERTY_BOXES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBoxes(MetadataBoxes boxes) {
    this.boxes = boxes;
  }


  public MetadataPagePages height(Float height) {
    
    this.height = height;
    return this;
  }

  /**
   * The height of this page in points.
   * minimum: 0
   * @return height
   **/
  @Nullable
  @Schema(name = "The height of this page in points.")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeight(Float height) {
    this.height = height;
  }


  public MetadataPagePages label(String label) {
    
    this.label = label;
    return this;
  }

  /**
   * The page label of this page.
   * @return label
   **/
  @Nullable
  @Schema(name = "The page label of this page.")
  @JsonProperty(JSON_PROPERTY_LABEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLabel() {
    return label;
  }


  @JsonProperty(JSON_PROPERTY_LABEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLabel(String label) {
    this.label = label;
  }


  public MetadataPagePages number(Integer number) {
    
    this.number = number;
    return this;
  }

  /**
   * The page number of this page.
   * minimum: 0
   * @return number
   **/
  @Nullable
  @Schema(name = "The page number of this page.")
  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumber() {
    return number;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumber(Integer number) {
    this.number = number;
  }


  public MetadataPagePages objectKey(String objectKey) {
    
    this.objectKey = objectKey;
    return this;
  }

  /**
   * The object ID of the page. **Info:** A PDF object ID consists of two numbers, where the first number selects the object&#39;s number and the second the \&quot;generation\&quot; of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.
   * @return objectKey
   **/
  @Nullable
  @Schema(name = "The object ID of the page. **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObjectKey() {
    return objectKey;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObjectKey(String objectKey) {
    this.objectKey = objectKey;
  }


  public MetadataPagePages rotation(Integer rotation) {
    
    this.rotation = rotation;
    return this;
  }

  /**
   * The rotation of this page in degrees.
   * minimum: 0
   * @return rotation
   **/
  @Nullable
  @Schema(name = "The rotation of this page in degrees.")
  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRotation() {
    return rotation;
  }


  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRotation(Integer rotation) {
    this.rotation = rotation;
  }


  public MetadataPagePages width(Float width) {
    
    this.width = width;
    return this;
  }

  /**
   * The width of this page in points.
   * minimum: 0
   * @return width
   **/
  @Nullable
  @Schema(name = "The width of this page in points.")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWidth(Float width) {
    this.width = width;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataPagePages metadataPagePages = (MetadataPagePages) o;
    return Objects.equals(this.boxes, metadataPagePages.boxes) &&
        Objects.equals(this.height, metadataPagePages.height) &&
        Objects.equals(this.label, metadataPagePages.label) &&
        Objects.equals(this.number, metadataPagePages.number) &&
        Objects.equals(this.objectKey, metadataPagePages.objectKey) &&
        Objects.equals(this.rotation, metadataPagePages.rotation) &&
        Objects.equals(this.width, metadataPagePages.width);
  }

  @Override
  public int hashCode() {
    return Objects.hash(boxes, height, label, number, objectKey, rotation, width);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataPagePages {\n");
    sb.append("    boxes: ").append(toIndentedString(boxes)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    objectKey: ").append(toIndentedString(objectKey)).append("\n");
    sb.append("    rotation: ").append(toIndentedString(rotation)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
