/*
 * webPDF
 * This is the REST API description for the webPDF server.  You can find out more about webPDF at [https://www.webpdf.de](https://www.webpdf.de)  ### API authorization The WebPDF API web service endpoints are protected and require authorization for access. The authorization is in the form of an authorization token called an \"access token\".  Such a token authorizes the use of the API and can be issued in two ways:  1) the built-in authentication process using `POST /authentication/user/login`, which authenticates a user with credentials and issues an access token, or 2) via an external OAuth2 provider that issues an OAuth token (a JWT based \"access token\") that can be validated by the server during the API call.  The server (or API) can use both paths in parallel, or individual ones can be turned on or off.  The integrated (local) authorization is available without configuration, while the use of OAuth2 tokens must first be configured in the server.  ### User authentication To use local authorization, a user must be authenticated against a user source. Such a user source can be, for example, the integrated user database or an LDAP/AD server.  To authenticate use the `POST /authentication/user/login` call below in the **Authentication** group with a username and password. This will return a JSON response with access token as property `token`.  It is also possible to authenticate as an anonymous user by calling `POST /authentication/user/login` without user credentials. _Note:_ This feature can be disabled via the configuration for the local authorization provider.  ### Access token (endpoint authorization) All API calls (web service endpoints) require an access token for authorization. The access token is passed to the endpoint in the `Authorization` header as `Bearer: [access token]`.  The access token can be the token provided via the local authorization provider (via `POST /authentication/user/login`) or an OAuth2 JWT (JSON Web Token) provided by an external authorization provider.  Omitting this header or supplying an invalid token results in an error `401 Unauthorized`.  ### Refresh token (session renew) When the local authorization provider issues an access token, a second token, called a refresh token, is also issued. This token is referenced as `refreshToken` in the JSON response when `POST /authentication/user/login` is used.  This token allows a new access token to be issued before the token and the associated session (see **Session** below) expires. With `POST /authentication/user/refresh` the refresh token can be 'exchanged' for a new access token and a new refresh token. This prevents the access token from expiring and terminating an active session.  ### Session The REST API of this server is a stateful session based API.  Whenever an access token is issued by the local authorization provider is issued or an externally issued OAuth2 token is used with the API, a new session is created for the token.  This session retains all documents (see **Document storage** below) and user settings until the session expires or an explicit logout (`GET /authentication/user/logout`) is invoked.  ### Document storage A document is uploaded to the server with `POST /documents` and is stored in the **document storage** of the server. The document storage is always assigned to a session (see \"**Session**\" above).  A unique ID `documentID` will be created for the uploaded file as reference. As the result of the upload the `DocumentFile` is fetched via `303 See Other` from `GET /documents/{documentId}/info`. The document information `DocumentFile` contains the document ID in the field `documentId`. Most API calls in `/documents/...` and most call which work on documents (e.g. `/converter/{documentId}` or `/pdfa/{documentId}` ) require the ID to reference a document. The `documentID` can also be fetched from the list returned by `GET /documents/list`.  ### Experimental Web services Web services marked with experimental are subject to change at any time and without notice! These web services usually provide new features that are not yet finally implemented.  ### Try it out (Swagger UI only) You can call the web service API online via the documentation by pressing the **'Try it out'** button for each call. For this you need an authorization in the form of an access token.  To obtain an access token, use `POST /authentication/user/login`, click on the \"lock\" icon, enter the user credentials and select \"**Authorize**\". Execute the login via the \"**'Try it out'**\" button and then via the \"**'Execute'**\" button.   Click the **'Authorize'** button below and enter the access token at `BearerAuth` and click **'Authorize'**.  Alternatively, you can enter the access token using the \"lock\" icon above each individual call. 
 *
 * The version of the OpenAPI document: webPDF 9.0.0.3081 (2023-08-20T15:49:01Z) 
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.webpdf.wsclient.openapi;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.*;
import java.util.*;
import com.fasterxml.jackson.annotation.*;

/**
 * Lists the properties of a PDF form field.
 */
@Schema(description = "Lists the properties of a PDF form field.")
@JsonPropertyOrder({
  MetadataField.JSON_PROPERTY_ALTERNATE_NAME,
  MetadataField.JSON_PROPERTY_ANNOTATION,
  MetadataField.JSON_PROPERTY_CONTENT,
  MetadataField.JSON_PROPERTY_FULLY_QUALIFIED_NAME,
  MetadataField.JSON_PROPERTY_IS_RICH_TEXT,
  MetadataField.JSON_PROPERTY_MAPPING_NAME,
  MetadataField.JSON_PROPERTY_MULTI_SELECT,
  MetadataField.JSON_PROPERTY_NAME,
  MetadataField.JSON_PROPERTY_NO_EXPORT,
  MetadataField.JSON_PROPERTY_OBJECT_KEY,
  MetadataField.JSON_PROPERTY_READ_ONLY,
  MetadataField.JSON_PROPERTY_REQUIRED,
  MetadataField.JSON_PROPERTY_SIGNATURE,
  MetadataField.JSON_PROPERTY_SUB_TYPE,
  MetadataField.JSON_PROPERTY_TYPE,
  MetadataField.JSON_PROPERTY_VALUE
})
@JsonTypeName("Metadata_Field")

public class MetadataField {
  public static final String JSON_PROPERTY_ALTERNATE_NAME = "alternateName";
  private String alternateName = "";

  public static final String JSON_PROPERTY_ANNOTATION = "annotation";
  private List<MetadataAnnotation> annotation = null;

  public static final String JSON_PROPERTY_CONTENT = "content";
  private String content = "";

  public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
  private String fullyQualifiedName = "";

  public static final String JSON_PROPERTY_IS_RICH_TEXT = "isRichText";
  private Boolean isRichText = false;

  public static final String JSON_PROPERTY_MAPPING_NAME = "mappingName";
  private String mappingName = "";

  public static final String JSON_PROPERTY_MULTI_SELECT = "multiSelect";
  private Boolean multiSelect = false;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name = "";

  public static final String JSON_PROPERTY_NO_EXPORT = "noExport";
  private Boolean noExport = false;

  public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
  private String objectKey = "";

  public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
  private Boolean readOnly = false;

  public static final String JSON_PROPERTY_REQUIRED = "required";
  private Boolean required = false;

  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private MetadataSignature signature;

  public static final String JSON_PROPERTY_SUB_TYPE = "subType";
  private String subType = "";

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type = "";

  public static final String JSON_PROPERTY_VALUE = "value";
  private List<MetadataFormValueStyle> value = null;

  public MetadataField() {
  }

  public MetadataField alternateName(String alternateName) {
    
    this.alternateName = alternateName;
    return this;
  }

  /**
   * The alternate name of the form field.
   * @return alternateName
   **/
  @Nullable
  @Schema(name = "The alternate name of the form field.")
  @JsonProperty(JSON_PROPERTY_ALTERNATE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAlternateName() {
    return alternateName;
  }


  @JsonProperty(JSON_PROPERTY_ALTERNATE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAlternateName(String alternateName) {
    this.alternateName = alternateName;
  }


  public MetadataField annotation(List<MetadataAnnotation> annotation) {
    
    this.annotation = annotation;
    return this;
  }

  public MetadataField addAnnotationItem(MetadataAnnotation annotationItem) {
    if (this.annotation == null) {
      this.annotation = new ArrayList<>();
    }
    this.annotation.add(annotationItem);
    return this;
  }

  /**
   * Selects the visible representation (widget annotation) for the form field.
   * @return annotation
   **/
  @Nullable
  @Schema(name = "Selects the visible representation (widget annotation) for the form field.")
  @JsonProperty(JSON_PROPERTY_ANNOTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MetadataAnnotation> getAnnotation() {
    return annotation;
  }


  @JsonProperty(JSON_PROPERTY_ANNOTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnnotation(List<MetadataAnnotation> annotation) {
    this.annotation = annotation;
  }


  public MetadataField content(String content) {
    
    this.content = content;
    return this;
  }

  /**
   * The textual content of the form field. A single string or a comma-separated list of string values for list types.
   * @return content
   **/
  @Nullable
  @Schema(name = "The textual content of the form field. A single string or a comma-separated list of string values for list types.")
  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContent() {
    return content;
  }


  @JsonProperty(JSON_PROPERTY_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContent(String content) {
    this.content = content;
  }


  public MetadataField fullyQualifiedName(String fullyQualifiedName) {
    
    this.fullyQualifiedName = fullyQualifiedName;
    return this;
  }

  /**
   * The fully qualified name of the form field.
   * @return fullyQualifiedName
   **/
  @Nullable
  @Schema(name = "The fully qualified name of the form field.")
  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullyQualifiedName() {
    return fullyQualifiedName;
  }


  @JsonProperty(JSON_PROPERTY_FULLY_QUALIFIED_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFullyQualifiedName(String fullyQualifiedName) {
    this.fullyQualifiedName = fullyQualifiedName;
  }


  public MetadataField isRichText(Boolean isRichText) {
    
    this.isRichText = isRichText;
    return this;
  }

  /**
   * When set to true, the field contains rich text formatted content.
   * @return isRichText
   **/
  @Nullable
  @Schema(name = "When set to true, the field contains rich text formatted content.")
  @JsonProperty(JSON_PROPERTY_IS_RICH_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsRichText() {
    return isRichText;
  }


  @JsonProperty(JSON_PROPERTY_IS_RICH_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsRichText(Boolean isRichText) {
    this.isRichText = isRichText;
  }


  public MetadataField mappingName(String mappingName) {
    
    this.mappingName = mappingName;
    return this;
  }

  /**
   * The mapping name of the form field.
   * @return mappingName
   **/
  @Nullable
  @Schema(name = "The mapping name of the form field.")
  @JsonProperty(JSON_PROPERTY_MAPPING_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMappingName() {
    return mappingName;
  }


  @JsonProperty(JSON_PROPERTY_MAPPING_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMappingName(String mappingName) {
    this.mappingName = mappingName;
  }


  public MetadataField multiSelect(Boolean multiSelect) {
    
    this.multiSelect = multiSelect;
    return this;
  }

  /**
   * When set to true, the form field allows multiple items to be seleted.
   * @return multiSelect
   **/
  @Nullable
  @Schema(name = "When set to true, the form field allows multiple items to be seleted.")
  @JsonProperty(JSON_PROPERTY_MULTI_SELECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMultiSelect() {
    return multiSelect;
  }


  @JsonProperty(JSON_PROPERTY_MULTI_SELECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMultiSelect(Boolean multiSelect) {
    this.multiSelect = multiSelect;
  }


  public MetadataField name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * The partial name of the form field.
   * @return name
   **/
  @Nullable
  @Schema(name = "The partial name of the form field.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public MetadataField noExport(Boolean noExport) {
    
    this.noExport = noExport;
    return this;
  }

  /**
   * When set to true, the form field shall not be included in exports of the document&#39;s form data.
   * @return noExport
   **/
  @Nullable
  @Schema(name = "When set to true, the form field shall not be included in exports of the document's form data.")
  @JsonProperty(JSON_PROPERTY_NO_EXPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getNoExport() {
    return noExport;
  }


  @JsonProperty(JSON_PROPERTY_NO_EXPORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNoExport(Boolean noExport) {
    this.noExport = noExport;
  }


  public MetadataField objectKey(String objectKey) {
    
    this.objectKey = objectKey;
    return this;
  }

  /**
   * The object ID of the form field. **Info:** A PDF object ID consists of two numbers, where the first number selects the object&#39;s number and the second the \&quot;generation\&quot; of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.
   * @return objectKey
   **/
  @Nullable
  @Schema(name = "The object ID of the form field. **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObjectKey() {
    return objectKey;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObjectKey(String objectKey) {
    this.objectKey = objectKey;
  }


  public MetadataField readOnly(Boolean readOnly) {
    
    this.readOnly = readOnly;
    return this;
  }

  /**
   * When set to true, the form field&#39;s contents may be displayed but not altered.
   * @return readOnly
   **/
  @Nullable
  @Schema(name = "When set to true, the form field's contents may be displayed but not altered.")
  @JsonProperty(JSON_PROPERTY_READ_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReadOnly() {
    return readOnly;
  }


  @JsonProperty(JSON_PROPERTY_READ_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReadOnly(Boolean readOnly) {
    this.readOnly = readOnly;
  }


  public MetadataField required(Boolean required) {
    
    this.required = required;
    return this;
  }

  /**
   * When set to true, the form field must be filled in.
   * @return required
   **/
  @Nullable
  @Schema(name = "When set to true, the form field must be filled in.")
  @JsonProperty(JSON_PROPERTY_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getRequired() {
    return required;
  }


  @JsonProperty(JSON_PROPERTY_REQUIRED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequired(Boolean required) {
    this.required = required;
  }


  public MetadataField signature(MetadataSignature signature) {
    
    this.signature = signature;
    return this;
  }

  /**
   * Get signature
   * @return signature
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MetadataSignature getSignature() {
    return signature;
  }


  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignature(MetadataSignature signature) {
    this.signature = signature;
  }


  public MetadataField subType(String subType) {
    
    this.subType = subType;
    return this;
  }

  /**
   * The implementation name of the the form field.
   * @return subType
   **/
  @Nullable
  @Schema(name = "The implementation name of the the form field.")
  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubType() {
    return subType;
  }


  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubType(String subType) {
    this.subType = subType;
  }


  public MetadataField type(String type) {
    
    this.type = type;
    return this;
  }

  /**
   * Indicates the type of the form field.  *   Btn &#x3D; Button *   Tx &#x3D; Textfield *   Ch &#x3D; Choicefield *   Sig &#x3D; Signaturefield
   * @return type
   **/
  @Nullable
  @Schema(name = "Indicates the type of the form field.  *   Btn = Button *   Tx = Textfield *   Ch = Choicefield *   Sig = Signaturefield")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }


  public MetadataField value(List<MetadataFormValueStyle> value) {
    
    this.value = value;
    return this;
  }

  public MetadataField addValueItem(MetadataFormValueStyle valueItem) {
    if (this.value == null) {
      this.value = new ArrayList<>();
    }
    this.value.add(valueItem);
    return this;
  }

  /**
   * Get value
   * @return value
   **/
  @Nullable
  @Schema(name = "")
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MetadataFormValueStyle> getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(List<MetadataFormValueStyle> value) {
    this.value = value;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataField metadataField = (MetadataField) o;
    return Objects.equals(this.alternateName, metadataField.alternateName) &&
        Objects.equals(this.annotation, metadataField.annotation) &&
        Objects.equals(this.content, metadataField.content) &&
        Objects.equals(this.fullyQualifiedName, metadataField.fullyQualifiedName) &&
        Objects.equals(this.isRichText, metadataField.isRichText) &&
        Objects.equals(this.mappingName, metadataField.mappingName) &&
        Objects.equals(this.multiSelect, metadataField.multiSelect) &&
        Objects.equals(this.name, metadataField.name) &&
        Objects.equals(this.noExport, metadataField.noExport) &&
        Objects.equals(this.objectKey, metadataField.objectKey) &&
        Objects.equals(this.readOnly, metadataField.readOnly) &&
        Objects.equals(this.required, metadataField.required) &&
        Objects.equals(this.signature, metadataField.signature) &&
        Objects.equals(this.subType, metadataField.subType) &&
        Objects.equals(this.type, metadataField.type) &&
        Objects.equals(this.value, metadataField.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(alternateName, annotation, content, fullyQualifiedName, isRichText, mappingName, multiSelect, name, noExport, objectKey, readOnly, required, signature, subType, type, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataField {\n");
    sb.append("    alternateName: ").append(toIndentedString(alternateName)).append("\n");
    sb.append("    annotation: ").append(toIndentedString(annotation)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    fullyQualifiedName: ").append(toIndentedString(fullyQualifiedName)).append("\n");
    sb.append("    isRichText: ").append(toIndentedString(isRichText)).append("\n");
    sb.append("    mappingName: ").append(toIndentedString(mappingName)).append("\n");
    sb.append("    multiSelect: ").append(toIndentedString(multiSelect)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    noExport: ").append(toIndentedString(noExport)).append("\n");
    sb.append("    objectKey: ").append(toIndentedString(objectKey)).append("\n");
    sb.append("    readOnly: ").append(toIndentedString(readOnly)).append("\n");
    sb.append("    required: ").append(toIndentedString(required)).append("\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    subType: ").append(toIndentedString(subType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
